/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.recipe;

import gnu.trove.strategy.HashingStrategy;
import gregtech.api.util.GT_Recipe;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeHashStrat {
    public static final HashingStrategy<GT_Recipe> RecipeHashingStrategy = new HashingStrategy<GT_Recipe>(){

        public int computeHashCode(GT_Recipe recipe) {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{recipe.mDuration, recipe.mEUt});
        }

        public boolean equals(GT_Recipe recipe1, GT_Recipe recipe2) {
            return RecipeHashStrat.areRecipesEqual(recipe1, recipe2);
        }
    };

    public static boolean areRecipesEqual(GT_Recipe recipe1, GT_Recipe recipe2) {
        RecipeHashStrat.sortItemStackArray(recipe1.mInputs);
        ItemStack[] recipe1OutputCopy = (ItemStack[])recipe1.mOutputs.clone();
        RecipeHashStrat.sortItemStackArray(recipe1OutputCopy);
        RecipeHashStrat.sortFluidStackArray(recipe1.mFluidInputs);
        RecipeHashStrat.sortFluidStackArray(recipe1.mFluidOutputs);
        RecipeHashStrat.sortItemStackArray(recipe2.mInputs);
        ItemStack[] recipe2OutputCopy = (ItemStack[])recipe2.mOutputs.clone();
        RecipeHashStrat.sortItemStackArray(recipe2OutputCopy);
        RecipeHashStrat.sortFluidStackArray(recipe2.mFluidInputs);
        RecipeHashStrat.sortFluidStackArray(recipe2.mFluidOutputs);
        if (recipe1.mEUt != recipe2.mEUt) {
            return false;
        }
        if (recipe1.mDuration != recipe2.mDuration) {
            return false;
        }
        if (!RecipeHashStrat.areItemsStackArraysEqual(recipe1.mInputs, recipe2.mInputs)) {
            return false;
        }
        if (!RecipeHashStrat.areItemsStackArraysEqual(recipe1OutputCopy, recipe2OutputCopy)) {
            return false;
        }
        if (!RecipeHashStrat.areFluidStackArraysEqual(recipe1.mFluidInputs, recipe2.mFluidInputs)) {
            return false;
        }
        return RecipeHashStrat.areFluidStackArraysEqual(recipe1.mFluidOutputs, recipe2.mFluidOutputs);
    }

    public static void sortItemStackArray(ItemStack[] itemStackArray) {
        Arrays.sort(itemStackArray, Comparator.comparing(itemStack -> Item.func_150891_b((Item)itemStack.func_77973_b())).thenComparing(ItemStack::func_77960_j).thenComparing(itemStack -> itemStack.field_77994_a));
    }

    public static void sortFluidStackArray(FluidStack[] fluidStackArray) {
        Arrays.sort(fluidStackArray, Comparator.comparing(FluidStack::getFluidID).thenComparing(fluidStack -> fluidStack.amount));
    }

    public static boolean areItemsStackArraysEqual(ItemStack[] array1, ItemStack[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (!Objects.equals(array1[i].func_77973_b(), array2[i].func_77973_b())) {
                return false;
            }
            if (!Objects.equals(array1[i].func_77960_j(), array2[i].func_77960_j())) {
                return false;
            }
            if (Objects.equals(array1[i].field_77994_a, array2[i].field_77994_a)) continue;
            return false;
        }
        return true;
    }

    public static boolean areFluidStackArraysEqual(FluidStack[] array1, FluidStack[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (!Objects.equals(array1[i].getFluid(), array2[i].getFluid())) {
                return false;
            }
            if (Objects.equals(array1[i].amount, array2[i].amount)) continue;
            return false;
        }
        return true;
    }
}

