/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAlleleBoolean;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.VoidProtectionHelper;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.TreeFarmHelper;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GregtechMetaTileEntityTreeFarm
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntityTreeFarm>
implements ISurvivalConstructable {
    public static int CASING_TEXTURE_ID;
    public static String mCasingName;
    public static HashMap<String, ItemStack> sLogCache;
    private static final int TICKS_PER_OPERATION = 100;
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntityTreeFarm> STRUCTURE_DEFINITION;
    private TreeFarmHelper.SAWTOOL mToolType;
    private ItemStack mSapling;
    private ItemStack mWood;
    private float heightModifier = 1.0f;
    private float saplingsModifier = 1.0f;
    private int girthModifier = 1;
    private static int sRecipeID;

    public GregtechMetaTileEntityTreeFarm(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(1, 15);
    }

    public GregtechMetaTileEntityTreeFarm(String aName) {
        super(aName);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(1, 15);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntityTreeFarm(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Tree Farm";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Converts EU to Logs").addInfo("Eu Usage: 100% | Parallel: 1").addInfo("Requires a Saw or Chainsaw in GUI slot").addInfo("Output multiplier:").addInfo("Saw = 1x").addInfo("Buzzsaw = 2x").addInfo("Chainsaw = 4x").addInfo("Add a sapling in the input bus to select wood type output").addInfo("The sapling is not consumed").addInfo("Tools can also be fed to the controller via input bus").addInfo("The working speed is fixed for 5s").addInfo("Production Formula: (2 * tier^2 - 2 * tier + 5) * 5 * saw boost").addInfo("When fertilizer is supplied, produces saplings instead of logs").addInfo("Forestry saplings can get increased production").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfoMin("Sterile Farm Casing", 8, false).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addMufflerHatch("Any casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_TEXTURE_ID;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        if (TreeFarmHelper.isValidForGUI(aStack) && GT_MetaGenerated_Tool.getToolDamage((ItemStack)aStack) < GT_MetaGenerated_Tool.getToolMaxDamage((ItemStack)aStack)) {
            return GT_ModHandler.isElectricItem((ItemStack)aStack) ? GT_ModHandler.canUseElectricItem((ItemStack)aStack, (int)32) : true;
        }
        return false;
    }

    public int getSawBoost(TreeFarmHelper.SAWTOOL sawType) {
        int n;
        switch (sawType) {
            case SAW: {
                n = 1;
                break;
            }
            case BUZZSAW: {
                n = 2;
                break;
            }
            case CHAINSAW: {
                n = 4;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.treeGrowthSimulatorFakeRecipes;
    }

    @NotNull
    public CheckRecipeResult checkProcessing() {
        ItemStack[] toOutput;
        int amplifiedOutputAmount;
        ItemStack controllerStack = this.getControllerSlot();
        if (!this.isCorrectMachinePart(controllerStack) && !this.replaceTool()) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_saw");
        }
        if (!this.checkSapling()) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_sapling");
        }
        this.mToolType = TreeFarmHelper.isCorrectMachinePart(controllerStack);
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        int aOutputAmount = (2 * (tTier * tTier) - 2 * tTier + 5) * 5 * this.getSawBoost(this.mToolType);
        int aFert = this.hasLiquidFert();
        if (aFert > 0) {
            if (aFert < aOutputAmount) {
                aOutputAmount /= 10;
            }
            amplifiedOutputAmount = (int)((float)aOutputAmount * this.saplingsModifier);
            toOutput = new ItemStack[]{ItemUtils.getSimpleStack(this.mSapling, amplifiedOutputAmount)};
        } else {
            amplifiedOutputAmount = (int)((float)aOutputAmount * this.heightModifier * (float)this.girthModifier);
            toOutput = new ItemStack[]{ItemUtils.getSimpleStack(this.mWood, amplifiedOutputAmount)};
        }
        VoidProtectionHelper voidProtection = new VoidProtectionHelper().setMachine((IVoidable)this).setItemOutputs(toOutput).build();
        if (voidProtection.isItemFull()) {
            return CheckRecipeResultRegistry.ITEM_OUTPUT_FULL;
        }
        if (aFert > 0 && aFert >= aOutputAmount) {
            this.tryConsumeLiquidFert(aOutputAmount);
        }
        this.mOutputItems = toOutput;
        this.mMaxProgresstime = 100;
        this.lEUt = MaterialUtils.getVoltageForTier(tTier);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.tryDamageTool();
        this.updateSlots();
        return SimpleCheckRecipeResult.ofSuccess((String)"growing_trees");
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 8 && this.checkHatch();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    public IStructureDefinition<GregtechMetaTileEntityTreeFarm> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntityTreeFarm.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy.or((IHatchElement)GregtechMeta_MultiBlockBase.GTPPHatchElement.TTEnergy), GT_HatchElement.Muffler}).casingIndex(CASING_TEXTURE_ID).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)15))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiTreeFarm;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return MathUtils.balance((int)(75L - GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).getMass()), 5, 120);
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private boolean tryDamageTool() {
        GT_ModHandler.damageOrDechargeItem((ItemStack)this.mInventory[1], (int)1, (int)32, null);
        return this.replaceTool();
    }

    public boolean replaceTool() {
        ItemStack invItem = this.mInventory[1];
        if (this.isCorrectMachinePart(invItem)) {
            return true;
        }
        if (invItem != null) {
            this.mInventory[1] = null;
            this.addOutput(invItem);
        }
        for (ItemStack aStack : this.getStoredInputs()) {
            if (!this.isCorrectMachinePart(aStack)) continue;
            this.mInventory[1] = aStack.func_77946_l();
            this.depleteInput(aStack);
            return true;
        }
        return false;
    }

    public boolean checkSapling() {
        for (ItemStack uStack : this.getStoredInputs()) {
            if (uStack == null) continue;
            String registryName = Item.field_150901_e.func_148750_c((Object)uStack.func_77973_b());
            ItemStack aWood = sLogCache.get(registryName + ":" + uStack.func_77960_j());
            if (aWood != null) {
                this.heightModifier = 1.0f;
                this.saplingsModifier = 1.0f;
                this.girthModifier = 1;
                this.mSapling = uStack;
                this.mWood = aWood;
                return true;
            }
            if (!registryName.equals("Forestry:sapling")) continue;
            ITree tree = TreeManager.treeRoot.getMember(uStack);
            this.heightModifier = Math.max(3.0f * (tree.getGenome().getHeight() - 1.0f), 0.0f) + 1.0f;
            this.saplingsModifier = Math.max(tree.getGenome().getFertility() * 20.0f, 1.0f);
            this.girthModifier = tree.getGenome().getGirth();
            boolean fireproof = ((IAlleleBoolean)tree.getGenome().getChromosomes()[EnumTreeChromosome.FIREPROOF.ordinal()].getActiveAllele()).getValue();
            aWood = sLogCache.get(tree.getIdent() + (fireproof ? "fireproof" : ""));
            this.mSapling = uStack;
            this.mWood = aWood;
            return true;
        }
        return false;
    }

    public static void loadMapWoodFromSapling() {
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("GalaxySpace:barnardaCsapling:1", GT_ModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"barnardaClog", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:1", new ItemStack(Blocks.field_150364_r, 1, 1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:2", new ItemStack(Blocks.field_150364_r, 1, 2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:3", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:4", new ItemStack(Blocks.field_150363_s, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:5", new ItemStack(Blocks.field_150363_s, 1, 1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("IC2:blockRubSapling:0", GT_ModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockRubWood", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:0", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"redwood", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:1", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:2", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:3", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:4", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:5", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"bloodwood", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:6", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Dark Tree", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:7", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Dark Tree", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:0", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Tree", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:1", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Tree", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:2", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Tree", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:3", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Tree", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:4", GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"willow", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:0", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:1", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs2", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:2", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs2", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:3", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs3", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:4", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs3", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:5", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs4", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:6", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs4", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:2", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"bamboo", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:3", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs2", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:4", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:5", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs3", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:6", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:7", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs2", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:10", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:12", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:13", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs4", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:14", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs4", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:yellow_flower:0", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs3", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:red_flower:0", GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs3", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("witchery:witchsapling:0", GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchlog", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("witchery:witchsapling:1", GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchlog", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("witchery:witchsapling:2", GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchlog", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TConstruct:slime.sapling:0", GT_ModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"slime.gel", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TaintedMagic:BlockWarpwoodSapling:0", GT_ModHandler.getModItem((String)Mods.TaintedMagic.ID, (String)"BlockWarpwoodLog", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Thaumcraft:blockCustomPlant:0", GT_ModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockMagicalLog", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Thaumcraft:blockCustomPlant:1", GT_ModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockMagicalLog", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("miscutils:blockRainforestOakSapling:0", GT_ModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"blockRainforestOakLog", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("miscutils:blockPineSapling:0", GT_ModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"blockPineLogLog", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pampistachioSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pampapayaSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pammapleSapling:0", GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamMaple", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamappleSapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamdateSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamorangeSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamdragonfruitSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamnutmegSapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pampaperbarkSapling:0", GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamPaperbark", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pammangoSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamavocadoSapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamchestnutSapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pampeppercornSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pampecanSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamcashewSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamfigSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamoliveSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamcinnamonSapling:0", GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamCinnamon", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pampeachSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamlemonSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamvanillabeanSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamalmondSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pambananaSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamdurianSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamplumSapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamlimeSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pampearSapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamgooseberrySapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamcherrySapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pampomegranateSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamwalnutSapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pampersimmonSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamapricotSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamcoconutSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamgrapefruitSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestcraft:pamstarfruitSapling:0", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("harvestthenether:netherSapling:0", GT_ModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"netherLog", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:0", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:1", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:2", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:3", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:4", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:5", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLog", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:6", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLog", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:7", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLog", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:8", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLog", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TwilightForest:tile.TFSapling:9", GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("thaumicbases:goldenOakSapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("thaumicbases:goldenOakSapling:1", GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLogs", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("thaumicbases:goldenOakSapling:2", GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLogs", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("thaumicbases:goldenOakSapling:3", GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLogs", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("ForbiddenMagic:TaintSapling:0", GT_ModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"TaintLog", (long)1L));
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public static void mapSaplingToLog(String aSapling, ItemStack aLog) {
        ItemStack aSaplingStack = ItemUtils.getItemStackFromFQRN(aSapling, 1);
        if (aSaplingStack != null && aLog != null) {
            sLogCache.put(aSapling, aLog);
            GregtechMetaTileEntityTreeFarm.addFakeRecipeToNEI(aSaplingStack, aLog);
        } else {
            Logger.INFO("Unable to add Tree Growth Simulation for " + aSapling);
        }
    }

    public static boolean addFakeRecipeToNEI(@Nonnull ItemStack aSapling, ItemStack aLog) {
        int aRecipes = GTPPRecipeMaps.treeGrowthSimulatorFakeRecipes.getAllRecipes().size();
        Logger.INFO("Adding Tree Growth Simulation for " + aSapling.func_82833_r() + " -> " + (aLog == null ? "NULL" : aLog.func_82833_r()));
        ItemStack[] aOutput = new ItemStack[]{aLog, aSapling};
        String aOutputs = ItemUtils.getArrayStackNames(aOutput);
        Logger.INFO("" + aOutputs);
        ItemStack inputStack = aSapling.func_77946_l();
        inputStack.field_77994_a = 0;
        GTPPRecipeMaps.treeGrowthSimulatorFakeRecipes.addFakeRecipe(false, new ItemStack[]{inputStack}, aOutput, null, new int[]{10000, 1000}, new FluidStack[]{FluidUtils.getFluidStack(ModItems.fluidFertBasic, 1)}, new FluidStack[0], 1, sRecipeID++, 0);
        return GTPPRecipeMaps.treeGrowthSimulatorFakeRecipes.getAllRecipes().size() > aRecipes;
    }

    public int hasLiquidFert() {
        ArrayList aFluids = this.getStoredFluids();
        for (FluidStack aFluid : aFluids) {
            if (!aFluid.getFluid().equals(ModItems.fluidFertBasic)) continue;
            return aFluid.amount;
        }
        return 0;
    }

    public boolean tryConsumeLiquidFert(int aFluidAmount) {
        return this.depleteInput(FluidUtils.getFluidStack(ModItems.fluidFertBasic, aFluidAmount));
    }

    static {
        mCasingName = "Sterile Farm Casing";
        sLogCache = new HashMap();
        STRUCTURE_DEFINITION = null;
        sRecipeID = 0;
    }
}

