/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.ALLOY;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.material.nuclear.FLUORIDES;
import gtPlusPlus.core.material.nuclear.NUCLIDE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoader_LFTR;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoader_NuclearFuelProcessing;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLoader_Nuclear {
    public static void generate() {
        RecipeLoader_Nuclear.createRecipes();
        RecipeLoader_LFTR.generate();
        RecipeLoader_NuclearFuelProcessing.generate();
    }

    private static void createRecipes() {
        RecipeLoader_Nuclear.autoclave();
        RecipeLoader_Nuclear.blastFurnace();
        RecipeLoader_Nuclear.centrifugeRecipes();
        RecipeLoader_Nuclear.chemicalBathRecipes();
        RecipeLoader_Nuclear.chemicalReactorRecipes();
        RecipeLoader_Nuclear.dehydratorRecipes();
        RecipeLoader_Nuclear.electroMagneticSeperator();
        RecipeLoader_Nuclear.fluidExtractorRecipes();
        RecipeLoader_Nuclear.fluidHeater();
        RecipeLoader_Nuclear.fusionChainRecipes();
        RecipeLoader_Nuclear.macerator();
        RecipeLoader_Nuclear.mixerRecipes();
        RecipeLoader_Nuclear.sifter();
    }

    private static void autoclave() {
        GT_Values.RA.addAutoclaveRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 9), FluidUtils.getFluidStack("chlorine", 5184), ItemUtils.getItemStackOfAmountFromOreDict("pelletZirconium", 9), 0, 2400, 30);
    }

    private static void blastFurnace() {
        GT_Values.RA.addBlastRecipe(FLUORIDES.LITHIUM_FLUORIDE.getDust(2), FLUORIDES.BERYLLIUM_FLUORIDE.getDust(1), GT_Values.NF, GT_Values.NF, NUCLIDE.Li2BeF4.getDust(3), null, 1200, 2000, 3000);
        GT_Values.RA.addBlastRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustZrCl4", 1), null, GT_Values.NF, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustCookedZrCl4", 1), null, 1200, 340, 300);
    }

    private static void centrifugeRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getItemStackFromFQRN("IC2:reactorUraniumSimpledepleted", 8), GT_Utility.getIntegratedCircuit((int)20)}).itemOutputs(new ItemStack[]{ItemList.IC2_Fuel_Rod_Empty.get(8L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Uranium, (long)2L), ELEMENT.getInstance().URANIUM232.getSmallDust(1), ELEMENT.getInstance().URANIUM233.getSmallDust(1), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustSmall, (Object)Materials.Uranium235, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Plutonium, (long)1L)}).outputChances(new int[]{10000, 10000, 1000, 1000, 1000, 500}).fluidOutputs(new FluidStack[]{FluidUtils.getFluidStack("krypton", 60)}).duration(5000).eut(TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getItemStackFromFQRN("IC2:reactorMOXSimpledepleted", 8), GT_Utility.getIntegratedCircuit((int)20)}).itemOutputs(new ItemStack[]{ItemList.IC2_Fuel_Rod_Empty.get(8L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Plutonium, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Plutonium241, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Plutonium, (long)1L), ELEMENT.getInstance().PLUTONIUM238.getTinyDust(1), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Plutonium, (long)1L)}).outputChances(new int[]{10000, 10000, 500, 500, 500, 500}).fluidOutputs(new FluidStack[]{FluidUtils.getFluidStack("krypton", 90)}).duration(7500).eut(TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Depleted_Thorium_1.get(8L, new Object[0]), GT_Utility.getIntegratedCircuit((int)20)}).itemOutputs(new ItemStack[]{ItemList.IC2_Fuel_Rod_Empty.get(8L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Thorium, (long)2L), ELEMENT.getInstance().THORIUM232.getDust(1), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustSmall, (Object)Materials.Lutetium, (long)1L), ELEMENT.getInstance().POLONIUM.getSmallDust(1), ELEMENT.getInstance().THALLIUM.getTinyDust(1)}).outputChances(new int[]{10000, 10000, 5000, 5000, 5000, 2500}).fluidOutputs(new FluidStack[]{FluidUtils.getFluidStack("krypton", 30)}).duration(2500).eut(TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
    }

    private static void chemicalBathRecipes() {
        int[] chances = new int[]{9000, 6000, 3000};
        GT_Values.RA.addChemicalBathRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustTin", 12), FluidUtils.getFluidStack("chlorine", 2400), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 3), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 4), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 5), chances, 600, 480);
        chances = new int[]{9000, 3000, 1000};
        GT_Values.RA.addChemicalBathRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustRutile", 5), FluidUtils.getFluidStack("chlorine", 4000), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 3), ItemUtils.getItemStackOfAmountFromOreDict("dustTitanium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustHafnium", 1), chances, 600, 1024);
        GT_Values.RA.addChemicalBathRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumCarbonate", 10), FluidUtils.getFluidStack("hydrofluoricacid", 1440), ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumFluoride", 10), null, null, new int[0], 1800, 500);
    }

    private static void chemicalReactorRecipes() {
        ItemStack aGtHydrofluoricAcid = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cellHydrofluoricAcid_GT5U", 2);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumCarbonate", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustCalciumHydroxide", 5), null, null, ItemUtils.getItemStackOfAmountFromOreDict("dustLi2CO3CaOH2", 10), 12000);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumHydroxide", 5), null, FluidUtils.getFluidStack("hydrofluoricacid", 720), FluidUtils.getFluidStack("water", 720), ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumFluoride", 5), 12000);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustLithium7", 1), null, FluidUtils.getFluidStack("sulfuricacid", 1152), FluidUtils.getFluidStack("sulfuriclithium", 288), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallLithium7", 1), 400);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellOxygen", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustLithium7", 16), FluidUtils.getFluidStack("water", 1000), FluidUtils.getFluidStack("lithiumhydroxide", 2576), CI.emptyCells(1), 6000);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getGregtechCircuit(3), ELEMENT.getInstance().OXYGEN.getCell(1), ELEMENT.getInstance().HYDROGEN.getFluidStack(1000), MISC_MATERIALS.HYDROXIDE.getFluidStack(1000), CI.emptyCells(1), GT_Values.NI, 160, 30);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getGregtechCircuit(3), ELEMENT.getInstance().BERYLLIUM.getDust(7), MISC_MATERIALS.HYDROXIDE.getFluidStack(1000), FLUORIDES.BERYLLIUM_HYDROXIDE.getFluidStack(2000), GT_Values.NI, 160, 30);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getGregtechCircuit(3), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrofluoricAcid", 1), MISC_MATERIALS.AMMONIUM.getFluidStack(1000), FLUORIDES.AMMONIUM_BIFLUORIDE.getFluidStack(2000), CI.emptyCells(1), 400, 30);
        if (aGtHydrofluoricAcid != null) {
            GT_Values.RA.addChemicalRecipe(ItemUtils.getGregtechCircuit(3), aGtHydrofluoricAcid, MISC_MATERIALS.AMMONIUM.getFluidStack(1000), FLUORIDES.AMMONIUM_BIFLUORIDE.getFluidStack(2000), CI.emptyCells(2), 800, 30);
        }
        GT_Values.RA.addChemicalRecipe(ItemUtils.getGregtechCircuit(3), ELEMENT.getInstance().HYDROGEN.getCell(1), MISC_MATERIALS.AMMONIA.getFluidStack(1000), MISC_MATERIALS.AMMONIUM.getFluidStack(2000), CI.emptyCells(1), GT_Values.NI, 400, 30);
        GT_Values.RA.addChemicalRecipe(CI.getNumberedBioCircuit(15), ItemUtils.getItemStackOfAmountFromOreDict("dustSodiumHydroxide", 1), FluidUtils.getFluidStack("hydrofluoricacid", 500), FluidUtils.getWater(1000), FLUORIDES.SODIUM_FLUORIDE.getDust(1), 1200);
        if (FluidUtils.doesFluidExist("hydrofluoricacid_gt5u")) {
            GT_Values.RA.addChemicalRecipe(CI.getNumberedBioCircuit(15), ItemUtils.getItemStackOfAmountFromOreDict("dustSodiumHydroxide", 1), FluidUtils.getFluidStack("hydrofluoricacid_gt5u", 1000), FluidUtils.getWater(1000), FLUORIDES.SODIUM_FLUORIDE.getDust(1), 1200);
        }
    }

    private static void dehydratorRecipes() {
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(14), ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricLithium", 1)}, FluidUtils.getFluidStack("sulfuriclithium", 440), null, new ItemStack[]{CI.emptyCells(1), ItemUtils.getItemStackOfAmountFromOreDict("dustSulfur", 3), ItemUtils.getItemStackOfAmountFromOreDict("dustCopper", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSodium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustCarbon", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustLithium7", 4)}, new int[]{10000, 10000, 10000, 10000, 10000}, 600, 30);
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.emptyCells(12), ItemUtils.getItemStackOfAmountFromOreDict("dustLepidolite", 20)}, FluidUtils.getFluidStack("sulfuricacid", 10000), FluidUtils.getFluidStack("sulfuriclithium", 10000), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustPotassium", 1), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Aluminium, (long)4L), ItemUtils.getItemStackOfAmountFromOreDict("cellOxygen", 10), ItemUtils.getItemStackOfAmountFromOreDict("cellFluorine", 2), ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumCarbonate", 3)}, new int[]{10000, 10000, 10000, 10000, 10000}, 1500, 1000);
        if (ItemUtils.checkForInvalidItems(ItemUtils.getItemStackOfAmountFromOreDict("dustQuicklime", 1))) {
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(20), ItemUtils.getItemStackOfAmountFromOreDict("dustQuicklime", 2)}, FluidUtils.getFluidStack("water", 1000), null, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustCalciumHydroxide", 5)}, new int[]{10000}, 240, 120);
        } else {
            Logger.INFO("[dustCalciumHydroxide] FAILED TO LOAD RECIPE");
            if (!ItemUtils.checkForInvalidItems(ItemUtils.getItemStackOfAmountFromOreDict("dustQuicklime", 1))) {
                Logger.INFO("Could not find dustQuicklime, cannot make dustCalciumHydroxide.");
            }
        }
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(20), ItemUtils.getItemStackOfAmountFromOreDict("dustLi2CO3CaOH2", 5)}, null, null, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumHydroxide", 2), ItemUtils.getItemStackOfAmountFromOreDict("dustCalciumCarbonate", 3)}, new int[]{10000, 10000}, 2400, 1000);
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(22)}, FluidUtils.getFluidStack("lithiumhydroxide", 144), null, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumHydroxide", 1)}, new int[]{10000}, 20, 64);
        FluidStack aHydrogenChloride = new FluidStack(GenericChem.HydrochloricAcid, 9000);
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(11), ItemUtils.getItemStackOfAmountFromOreDict("dustCookedZrCl4", 9)}, FluidUtils.getFluidStack("hydrofluoricacid", 1296), aHydrogenChloride, new ItemStack[]{FLUORIDES.ZIRCONIUM_TETRAFLUORIDE.getDust(9)}, new int[]{10000}, 2400, 500);
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(10), ItemUtils.getItemStackOfAmountFromOreDict("dustCookedZrCl4", 9)}, FluidUtils.getFluidStack("hydrofluoricacid_gt5u", 2592), aHydrogenChloride, new ItemStack[]{FLUORIDES.ZIRCONIUM_TETRAFLUORIDE.getDust(9)}, new int[]{10000}, 4800, 500);
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(6), FLUORIDES.AMMONIUM_BIFLUORIDE.getCell(4)}, FLUORIDES.BERYLLIUM_HYDROXIDE.getFluidStack(2000), FLUORIDES.AMMONIUM_TETRAFLUOROBERYLLATE.getFluidStack(6000), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellWater", 4)}, new int[]{10000}, 640, 64);
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(17), CI.emptyCells(5)}, FLUORIDES.AMMONIUM_TETRAFLUOROBERYLLATE.getFluidStack(5000), null, new ItemStack[]{MISC_MATERIALS.AMMONIA.getCell(2), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrofluoricAcid", 2), FLUORIDES.BERYLLIUM_FLUORIDE.getCell(1)}, new int[]{10000, 10000, 10000}, 6000, 120);
    }

    private static void electroMagneticSeperator() {
        GT_Values.RA.addElectromagneticSeparatorRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedBauxite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustBauxite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallRutile", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetZirconium", 1), new int[]{10000, 2500, 4000}, 400, 24);
        GT_Values.RA.addElectromagneticSeparatorRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedMagnetite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustMagnetite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallZircon", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyZircon", 1), new int[]{10000, 1250, 2500}, 400, 24);
        GT_Values.RA.addElectromagneticSeparatorRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedCassiterite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustCassiterite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallZircon", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyZircon", 1), new int[]{10000, 1250, 2500}, 400, 24);
    }

    private static void fluidExtractorRecipes() {
        CORE.RA.addFluidExtractionRecipe(NUCLIDE.Li2BeF4.getDust(1), NUCLIDE.Li2BeF4.getFluidStack(144), 100, 500);
        CORE.RA.addFluidExtractionRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumFluoride", 1), FLUORIDES.LITHIUM_FLUORIDE.getFluidStack(144), 100, 500);
        CORE.RA.addFluidExtractionRecipe(NUCLIDE.LiFBeF2ZrF4U235.getDust(1), NUCLIDE.LiFBeF2ZrF4U235.getFluidStack(144), 250, 1000);
        CORE.RA.addFluidExtractionRecipe(NUCLIDE.LiFBeF2ZrF4UF4.getDust(1), NUCLIDE.LiFBeF2ZrF4UF4.getFluidStack(144), 150, 1500);
        CORE.RA.addFluidExtractionRecipe(NUCLIDE.LiFBeF2ThF4UF4.getDust(1), NUCLIDE.LiFBeF2ThF4UF4.getFluidStack(144), 150, 2000);
        CORE.RA.addFluidExtractionRecipe(FLUORIDES.ZIRCONIUM_TETRAFLUORIDE.getDust(1), FLUORIDES.ZIRCONIUM_TETRAFLUORIDE.getFluidStack(144), 200, 768);
    }

    private static void fusionChainRecipes() {
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{Materials.Boron.getPlasma(144L), Materials.Calcium.getPlasma(16L)}).fluidOutputs(new FluidStack[]{new FluidStack(ELEMENT.getInstance().NEON.getPlasma(), 1000)}).duration(64).eut(TierEU.RECIPE_LuV).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)100000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{new FluidStack(ELEMENT.getInstance().NEON.getPlasma(), 144), Materials.Bedrockium.getMolten(144L)}).fluidOutputs(new FluidStack[]{new FluidStack(ELEMENT.STANDALONE.FORCE.getPlasma(), 1000)}).duration(64).eut(TierEU.RECIPE_LuV).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)100000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{Materials.Niobium.getPlasma(144L), Materials.Zinc.getPlasma(144L)}).fluidOutputs(new FluidStack[]{new FluidStack(ELEMENT.getInstance().KRYPTON.getPlasma(), 144)}).duration(32).eut(TierEU.RECIPE_ZPM).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)300000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{new FluidStack(ELEMENT.getInstance().KRYPTON.getPlasma(), 144), new FluidStack(ELEMENT.STANDALONE.FORCE.getPlasma(), 1000)}).fluidOutputs(new FluidStack[]{new FluidStack(ELEMENT.STANDALONE.ASTRAL_TITANIUM.getPlasma(), 1000)}).duration(32).eut(TierEU.RECIPE_ZPM).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)300000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{new FluidStack(ELEMENT.STANDALONE.ASTRAL_TITANIUM.getPlasma(), 144), new FluidStack(ALLOY.TITANSTEEL.getFluid(), 8)}).fluidOutputs(new FluidStack[]{new FluidStack(ELEMENT.STANDALONE.RUNITE.getPlasma(), 1000)}).duration(32).eut(TierEU.RECIPE_ZPM).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)300000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{ELEMENT.getInstance().CURIUM.getFluidStack(144), Materials.Americium.getPlasma(144L)}).fluidOutputs(new FluidStack[]{new FluidStack(ELEMENT.getInstance().XENON.getPlasma(), 144)}).duration(16).eut(TierEU.RECIPE_UV).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)500000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{new FluidStack(ELEMENT.getInstance().XENON.getPlasma(), 144), new FluidStack(ELEMENT.STANDALONE.RUNITE.getPlasma(), 1000)}).fluidOutputs(new FluidStack[]{new FluidStack(ELEMENT.STANDALONE.ADVANCED_NITINOL.getPlasma(), 1000)}).duration(16).eut(TierEU.RECIPE_UV).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)500000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{new FluidStack(ELEMENT.STANDALONE.ADVANCED_NITINOL.getPlasma(), 144), Materials.Tartarite.getMolten(2L)}).fluidOutputs(new FluidStack[]{new FluidStack(ELEMENT.STANDALONE.CELESTIAL_TUNGSTEN.getPlasma(), 1000)}).duration(16).eut(TierEU.RECIPE_UV).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)500000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
    }

    private static void macerator() {
        GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("pelletZirconium", 1), (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("dustZrCl4", 1));
    }

    private static void mixerRecipes() {
        GT_Values.RA.addMixerRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustUranium233", 4), ItemUtils.getItemStackOfAmountFromOreDict("dustUranium235", 1), null, null, FluidUtils.getFluidStack("hydrofluoricacid", 5000), FLUORIDES.URANIUM_TETRAFLUORIDE.getFluidStack(5000), null, 3000, 500);
    }

    private static void sifter() {
        GT_Values.RA.addSifterRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedIlmenite", 1), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustIron", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustWroughtIron", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustHafnium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustHafnium", 1)}, new int[]{5000, 278, 1000, 1000, 300, 300}, 600, 500);
        GT_Values.RA.addSifterRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedTin", 1), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustTin", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZinc", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1)}, new int[]{10000, 556, 1500, 1000, 500, 500}, 600, 500);
        GT_Values.RA.addSifterRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedCassiterite", 1), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustCassiterite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTin", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1)}, new int[]{10000, 556, 1500, 1000, 500, 500}, 600, 500);
        GT_Values.RA.addSifterRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedThorium", 1), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustThorium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustLead", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1)}, new int[]{10000, 500, 300, 200, 100, 100}, 600, 500);
        GT_Values.RA.addSifterRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedUranium", 1), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustUranium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustLead", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1)}, new int[]{10000, 556, 1000, 500, 500, 500}, 600, 500);
        GT_Values.RA.addSifterRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedUraninite", 1), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustUraninite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustUranium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1)}, new int[]{10000, 556, 500, 250, 250, 250}, 600, 500);
        GT_Values.RA.addSifterRecipe(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedPitchblende", 1), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustPitchblende", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustLead", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1)}, new int[]{10000, 556, 500, 250, 250, 250}, 600, 500);
    }

    private static void fluidHeater() {
        CORE.RA.addFluidHeaterRecipe(FLUORIDES.SODIUM_FLUORIDE.getDust(1), null, FLUORIDES.SODIUM_FLUORIDE.getFluidStack(144), 600, 500);
    }
}

