/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.DataTools;
import mods.railcraft.common.util.network.IEditableItem;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PacketCurrentItemNBT
extends RailcraftPacket {
    private static final Marker SECURITY_MARKER = MarkerManager.getMarker((String)"SuspiciousPackets");
    private static final Set<String> ALLOWED_TAGS = new HashSet<String>(Arrays.asList("title", "author", "pages", "dest"));
    private final EntityPlayer player;
    private final ItemStack currentItem;

    public PacketCurrentItemNBT(EntityPlayer player, ItemStack stack) {
        this.player = player;
        this.currentItem = stack;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        DataTools.writeItemStack(this.currentItem, data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        try {
            ItemStack stack = DataTools.readItemStack(data);
            if (stack == null || this.currentItem == null) {
                return;
            }
            if (stack.func_77973_b() != this.currentItem.func_77973_b()) {
                return;
            }
            if (!(this.currentItem.func_77973_b() instanceof IEditableItem)) {
                return;
            }
            IEditableItem eItem = (IEditableItem)stack.func_77973_b();
            if (!eItem.canPlayerEdit(this.player, this.currentItem)) {
                Game.LOGGER.warn(SECURITY_MARKER, "Player {} attempted to edit an item he is not allowed to edit {}.", new Object[]{this.player.func_146103_bH(), this.currentItem.func_77973_b().func_77658_a()});
                return;
            }
            if (!eItem.validateNBT(this.currentItem, stack.func_77978_p())) {
                Game.LOGGER.warn(SECURITY_MARKER, "Player {}: Item NBT not valid!", new Object[]{this.player.func_146103_bH()});
                return;
            }
            NBTTagCompound nbt = InvTools.getItemData(stack);
            for (String tag : nbt.func_150296_c()) {
                if (ALLOWED_TAGS.contains(tag)) continue;
                return;
            }
            this.currentItem.func_77982_d(stack.func_77978_p());
        }
        catch (Exception exception) {
            Game.logThrowable("Error reading Item NBT packet", exception, new Object[0]);
        }
    }

    public void sendPacket() {
        PacketDispatcher.sendToServer(this);
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.ITEM_NBT.ordinal();
    }
}

