/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.network.rcon;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import mcp.mobius.opis.events.PlayerTracker;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.packets.client.PacketReqChunks;
import mcp.mobius.opis.network.packets.client.PacketReqData;
import mcp.mobius.opis.network.packets.server.NetDataCommand;
import mcp.mobius.opis.network.packets.server.NetDataList;
import mcp.mobius.opis.network.packets.server.NetDataValue;
import mcp.mobius.opis.network.rcon.nexus.NexusClient;
import mcp.mobius.opis.network.rcon.nexus.NexusInboundHandler;
import mcp.mobius.shadow.io.nettyopis.buffer.ByteBuf;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelFuture;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelFutureListener;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelHandlerContext;
import net.minecraftforge.common.util.FakePlayer;

public class RConHandler {
    public static BiMap<Byte, Class> packetTypes = HashBiMap.create();
    public static BiMap<FakePlayer, ChannelHandlerContext> fakePlayersRcon = HashBiMap.create();
    public static BiMap<FakePlayer, ChannelHandlerContext> fakePlayersNexus = HashBiMap.create();
    public static String lastError = null;
    public static WeakReference<ChannelHandlerContext> lastContext = null;

    public static void sendToAllNexus(PacketBase packet) {
        for (FakePlayer player : fakePlayersNexus.keySet()) {
            RConHandler.sendToPlayerNexus(packet, player);
        }
    }

    public static void sendToAllRCon(PacketBase packet) {
        for (FakePlayer player : fakePlayersRcon.keySet()) {
            RConHandler.sendToPlayerRCon(packet, player);
        }
    }

    public static void sendToPlayerNexus(PacketBase packet, FakePlayer player) {
        ChannelHandlerContext ctx = (ChannelHandlerContext)fakePlayersNexus.get((Object)player);
        NexusInboundHandler hnd = ctx.pipeline().get(NexusInboundHandler.class);
        if (hnd != null && hnd.timers.isDone(packet.msg)) {
            RConHandler.sendToContext(packet, ctx);
        }
    }

    public static void sendToPlayerRCon(PacketBase packet, FakePlayer player) {
        ChannelHandlerContext ctx = (ChannelHandlerContext)fakePlayersRcon.get((Object)player);
        RConHandler.sendToContext(packet, ctx);
    }

    public static void sendToContext(PacketBase packet, final ChannelHandlerContext ctx) {
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        packet.encode(output);
        byte[] data = output.toByteArray();
        ByteBuf buf = ctx.alloc().buffer(data.length + 4 + 1);
        buf.writeInt(data.length);
        buf.writeByte(((Byte)packetTypes.inverse().get(packet.getClass())).byteValue());
        buf.writeBytes(data);
        ChannelFuture f = ctx.writeAndFlush(buf);
        f.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture arg0) throws Exception {
                if (arg0.cause() != null) {
                    RConHandler.exceptionCaught(ctx, arg0.cause());
                }
            }
        });
    }

    public static boolean isPriviledge(FakePlayer player) {
        return fakePlayersRcon.containsKey((Object)player) || fakePlayersNexus.containsKey((Object)player);
    }

    public static void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause.getMessage().equals(lastError) && ctx.equals(lastContext.get())) {
            return;
        }
        lastError = cause.getMessage();
        lastContext = new WeakReference<ChannelHandlerContext>(ctx);
        if (cause instanceof IOException && cause.getMessage().contains("Connection reset by peer")) {
            modOpis.log.warn("HydraOpis : Connection reset by peer");
        } else if (cause instanceof ConnectException && cause.getMessage().contains("Connection refused")) {
            modOpis.log.warn("HydraOpis : Connection refused by remote server. Server is down ?");
        } else {
            modOpis.log.info(String.format("%s | %s", cause.getClass().getCanonicalName(), cause.getMessage()));
            cause.printStackTrace();
        }
        FakePlayer fakePlayer = null;
        if (fakePlayersNexus.inverse().containsKey((Object)ctx)) {
            fakePlayer = (FakePlayer)fakePlayersNexus.inverse().get((Object)ctx);
            fakePlayersNexus.remove((Object)fakePlayer);
        }
        if (fakePlayersRcon.inverse().containsKey((Object)ctx)) {
            fakePlayer = (FakePlayer)fakePlayersRcon.inverse().get((Object)ctx);
            fakePlayersRcon.remove((Object)fakePlayer);
        }
        if (fakePlayer != null) {
            PlayerTracker.INSTANCE.playersSwing.remove(fakePlayer);
            modOpis.log.info(String.format("Lost connection from %s", fakePlayer.getDisplayName()));
        } else {
            modOpis.log.info(String.format("Lost connection", new Object[0]));
        }
        if (((ChannelHandlerContext)NexusClient.instance.ctx.get()).equals(ctx)) {
            NexusClient.instance.reconnect = true;
        }
        ctx.close();
    }

    static {
        packetTypes.put((Object)0, PacketReqChunks.class);
        packetTypes.put((Object)1, PacketReqData.class);
        packetTypes.put((Object)2, NetDataCommand.class);
        packetTypes.put((Object)3, NetDataList.class);
        packetTypes.put((Object)4, NetDataValue.class);
    }
}

