/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels;

import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.client.DataCache;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.basetypes.SerialInt;
import mcp.mobius.opis.data.holders.basetypes.SerialLong;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTick;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.data.holders.newtypes.DataTimingMillisecond;
import mcp.mobius.opis.data.holders.newtypes.NexusData;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionRunOpis;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.shadow.net.miginfocom.swing.MigLayout;
import mcp.mobius.shadow.org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import mcp.mobius.shadow.org.jfree.chart.ChartFactory;
import mcp.mobius.shadow.org.jfree.chart.ChartPanel;
import mcp.mobius.shadow.org.jfree.chart.JFreeChart;
import mcp.mobius.shadow.org.jfree.chart.axis.NumberAxis;
import mcp.mobius.shadow.org.jfree.chart.plot.PlotOrientation;
import mcp.mobius.shadow.org.jfree.chart.plot.ValueMarker;
import mcp.mobius.shadow.org.jfree.chart.plot.XYPlot;
import mcp.mobius.shadow.org.jfree.data.xy.XYSeries;
import mcp.mobius.shadow.org.jfree.data.xy.XYSeriesCollection;
import net.minecraft.util.MathHelper;

public class PanelSummary
extends JPanelMsgHandler
implements ITabPanel {
    private JLabel lblTimingWorldTick;
    private JLabel lblTimingTileEnts;
    private JLabel lblTimingEntities;
    private JLabel lblTimingTotal;
    private JLabel lblTickTime;
    private JLabel lblAmountTileEnts;
    private JLabel lblAmountEntities;
    private JLabel lblAmountUpload;
    private JLabel lblAmountDownload;
    private JLabel lblAmountForced;
    private JLabel lblAmountLoaded;
    private JButtonAccess btnRun;
    private JProgressBar progressBarRun;
    private JLabel lblTimeStamp;
    private JTabbedPane tabGraphs;
    private DescriptiveStatistics pingData = new DescriptiveStatistics(5);
    private long nPings = 0L;
    private DataTimingMillisecond timingWorldTickTotal = new DataTimingMillisecond();
    private DataTimingMillisecond timingHandlersTotal = new DataTimingMillisecond();
    private DataTimingMillisecond timingTileEntsTotal = new DataTimingMillisecond();
    private DataTimingMillisecond timingEntitiesTotal = new DataTimingMillisecond();
    private DataTimingMillisecond timingNetworkTotal = new DataTimingMillisecond();
    ArrayList<Double> datapointsTick = new ArrayList();
    ArrayList<Double> datapointsPing = new ArrayList();
    XYSeries xydataTick = new XYSeries((Comparable)((Object)"Update time"));
    XYSeries xydataPing = new XYSeries((Comparable)((Object)"Ping"));
    XYSeriesCollection datasetTick = new XYSeriesCollection();
    XYSeriesCollection datasetPing = new XYSeriesCollection();
    XYPlot xyPlotTick;
    XYPlot xyPlotPing;
    private JLabel lblTimingNetwork;
    private JLabel lblTimingPing;

    public PanelSummary() {
        this.setLayout(new MigLayout("", "[20px:20px:20px,grow][][20px:20px:20px][60px:60px:60px][][20px:20px:20px][50px:50px:50px][20px:20px:20px][][20px:20px:20px][50px:50px:50px][][20px:20px:20px][grow][]", "[20px:20px:20px][][][][][][][][][20px:20px:20px][][grow]"));
        JLabel lblNewLabel_5 = new JLabel("Update time");
        this.add((Component)lblNewLabel_5, "cell 3 1 2 1,alignx right");
        JLabel lblNewLabel_16 = new JLabel("Amount");
        this.add((Component)lblNewLabel_16, "cell 6 1,alignx right");
        JLabel lblNewLabel_24 = new JLabel("Amount");
        this.add((Component)lblNewLabel_24, "cell 10 1 2 1,alignx right");
        this.btnRun = new JButtonAccess("Run Opis", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnRun, "cell 14 1,alignx right");
        this.btnRun.addActionListener(new ActionRunOpis());
        JLabel lblNewLabel = new JLabel("World tick");
        this.add((Component)lblNewLabel, "cell 1 2");
        this.lblTimingWorldTick = new JLabel("0");
        this.add((Component)this.lblTimingWorldTick, "cell 3 2 2 1,alignx right");
        JLabel lblNewLabel_20 = new JLabel("Upload");
        this.add((Component)lblNewLabel_20, "cell 8 2");
        this.lblAmountUpload = new JLabel("0");
        this.add((Component)this.lblAmountUpload, "cell 10 2,alignx right");
        JLabel lblNewLabel_30 = new JLabel("kB/s");
        this.add((Component)lblNewLabel_30, "cell 11 2,alignx right");
        this.progressBarRun = new JProgressBar();
        this.add((Component)this.progressBarRun, "cell 13 2 2 1,growx");
        JLabel lblNewLabel_1 = new JLabel("TileEntities");
        this.add((Component)lblNewLabel_1, "cell 1 3");
        this.lblTimingTileEnts = new JLabel("0");
        this.add((Component)this.lblTimingTileEnts, "cell 3 3 2 1,alignx right");
        this.lblAmountTileEnts = new JLabel("0");
        this.add((Component)this.lblAmountTileEnts, "cell 6 3,alignx right");
        JLabel lblNewLabel_21 = new JLabel("Download");
        this.add((Component)lblNewLabel_21, "cell 8 3");
        this.lblAmountDownload = new JLabel("0");
        this.add((Component)this.lblAmountDownload, "cell 10 3,alignx right");
        JLabel lblNewLabel_29 = new JLabel("kB/s");
        this.add((Component)lblNewLabel_29, "cell 11 3,alignx right");
        this.lblTimeStamp = new JLabel("Last run : Never");
        this.add((Component)this.lblTimeStamp, "cell 13 3 2 1,alignx right");
        JLabel lblNewLabel_2 = new JLabel("Entities");
        this.add((Component)lblNewLabel_2, "cell 1 4");
        this.lblTimingEntities = new JLabel("0");
        this.add((Component)this.lblTimingEntities, "cell 3 4 2 1,alignx right");
        this.lblAmountEntities = new JLabel("0");
        this.add((Component)this.lblAmountEntities, "cell 6 4,alignx right");
        JLabel lblNewLabel_6 = new JLabel("Ping");
        this.add((Component)lblNewLabel_6, "cell 8 4");
        this.lblTimingPing = new JLabel("0");
        this.add((Component)this.lblTimingPing, "cell 10 4 2 1,alignx right");
        JLabel lblNewLabel_22 = new JLabel("Forced chunks");
        this.add((Component)lblNewLabel_22, "cell 8 6");
        this.lblAmountForced = new JLabel("0");
        this.add((Component)this.lblAmountForced, "cell 10 6 2 1,alignx right");
        JLabel lblNewLabel_23 = new JLabel("Loaded chunks");
        this.add((Component)lblNewLabel_23, "cell 8 7");
        this.lblAmountLoaded = new JLabel("0");
        this.add((Component)this.lblAmountLoaded, "cell 10 7 2 1,alignx right");
        JLabel lblNewLabel_4 = new JLabel("Total");
        this.add((Component)lblNewLabel_4, "cell 1 6");
        this.lblTimingTotal = new JLabel("0");
        this.add((Component)this.lblTimingTotal, "cell 3 6 2 1,alignx right");
        JLabel lblNewLabel_31 = new JLabel("Tick Time");
        this.add((Component)lblNewLabel_31, "cell 1 10");
        this.lblTickTime = new JLabel("0");
        this.add((Component)this.lblTickTime, "cell 3 10 2 1,alignx right");
        this.tabGraphs = new JTabbedPane();
        this.add((Component)this.tabGraphs, "cell 0 11 15 1,grow");
        JPanel panelTick = this.createTickGraph();
        this.tabGraphs.addTab("Tick time", panelTick);
        JPanel panelPing = this.createPingGraph();
        this.tabGraphs.addTab("Ping", panelPing);
    }

    public JLabel getLblTimingWorldTick() {
        return this.lblTimingWorldTick;
    }

    public JLabel getLblTimingTileEnts() {
        return this.lblTimingTileEnts;
    }

    public JLabel getLblTimingEntities() {
        return this.lblTimingEntities;
    }

    public JLabel getLblTimingTotal() {
        return this.lblTimingTotal;
    }

    public JLabel getLblTickTime() {
        return this.lblTickTime;
    }

    public JLabel getLblAmountTileEnts() {
        return this.lblAmountTileEnts;
    }

    public JLabel getLblAmountEntities() {
        return this.lblAmountEntities;
    }

    public JLabel getLblAmountUpload() {
        return this.lblAmountUpload;
    }

    public JLabel getLblAmountDownload() {
        return this.lblAmountDownload;
    }

    public JLabel getLblAmountForced() {
        return this.lblAmountForced;
    }

    public JLabel getLblAmountLoaded() {
        return this.lblAmountLoaded;
    }

    public JButton getBtnRun() {
        return this.btnRun;
    }

    public JProgressBar getProgressBarRun() {
        return this.progressBarRun;
    }

    public JLabel getLblTimeStamp() {
        return this.lblTimeStamp;
    }

    public void setProgressBar(int min, int max, int value) {
        if (min != -1) {
            this.getProgressBarRun().setMinimum(min);
        }
        if (max != -1) {
            this.getProgressBarRun().setMaximum(max);
        }
        if (value != -1) {
            this.getProgressBarRun().setValue(value);
        }
    }

    public void setTimingEntUpdateTotal(double value) {
    }

    private JPanel createTickGraph() {
        JFreeChart chart = ChartFactory.createXYAreaChart("", "Seconds", "Update Time [ms]", this.datasetTick, PlotOrientation.VERTICAL, false, false, false);
        chart.setBackgroundPaint(new Color(255, 255, 255, 0));
        this.xyPlotTick = chart.getXYPlot();
        this.xyPlotTick.getRendererForDataset(this.datasetTick).setSeriesPaint(0, Color.BLUE);
        for (double y = 25.0; y < 500.0; y += 25.0) {
            ValueMarker marker = new ValueMarker(y);
            marker.setPaint(Color.black);
            this.xyPlotTick.addRangeMarker(marker);
        }
        return new ChartPanel(chart);
    }

    private JPanel createPingGraph() {
        JFreeChart chart = ChartFactory.createXYAreaChart("", "Seconds", "Ping Time [ms]", this.datasetPing, PlotOrientation.VERTICAL, false, false, false);
        chart.setBackgroundPaint(new Color(255, 255, 255, 0));
        this.xyPlotPing = chart.getXYPlot();
        this.xyPlotPing.getRendererForDataset(this.datasetPing).setSeriesPaint(0, Color.BLUE);
        for (double y = 200.0; y < 10000.0; y += 200.0) {
            ValueMarker marker = new ValueMarker(y);
            marker.setPaint(Color.black);
            this.xyPlotPing.addRangeMarker(marker);
        }
        return new ChartPanel(chart);
    }

    public void setTimingTick(ISerializable tickStat) {
        DataTimingMillisecond ticktime = ((DataTiming)tickStat).asMillisecond();
        this.getLblTickTime().setText(ticktime.toString());
        this.datapointsTick.add(ticktime.timing / 1000.0 / 1000.0);
        if (this.datapointsTick.size() > 101) {
            this.datapointsTick.remove(0);
        }
        this.xydataTick.clear();
        for (int i = 0; i < this.datapointsTick.size(); ++i) {
            this.xydataTick.add((double)i, (Number)this.datapointsTick.get(i));
        }
        this.datasetTick.removeAllSeries();
        this.datasetTick.addSeries(this.xydataTick);
        double verticalScale = 50.0 * (double)(MathHelper.func_76128_c((double)(this.xydataTick.getMaxY() / 50.0)) + 1);
        ((NumberAxis)this.xyPlotTick.getRangeAxis()).setRange(0.0, verticalScale);
        ((NumberAxis)this.xyPlotTick.getDomainAxis()).setRange(0.0, 100.0);
    }

    public void setTimingPing(ISerializable pingStat) {
        DataTimingMillisecond pingtime = ((DataTiming)pingStat).asMillisecond();
        this.datapointsPing.add(pingtime.timing / 1000.0 / 1000.0);
        if (this.datapointsPing.size() > 101) {
            this.datapointsPing.remove(0);
        }
        this.xydataPing.clear();
        for (int i = 0; i < this.datapointsPing.size(); ++i) {
            this.xydataPing.add((double)i, (Number)this.datapointsPing.get(i));
        }
        this.datasetPing.removeAllSeries();
        this.datasetPing.addSeries(this.xydataPing);
        double verticalScale = 500.0 * (double)(MathHelper.func_76128_c((double)(this.xydataPing.getMaxY() / 500.0)) + 1);
        ((NumberAxis)this.xyPlotPing.getRangeAxis()).setRange(0.0, verticalScale);
        ((NumberAxis)this.xyPlotPing.getDomainAxis()).setRange(0.0, 100.0);
    }

    private DataTimingMillisecond getProfiledTickTotalTime() {
        return new DataTimingMillisecond(this.timingWorldTickTotal.timing + this.timingTileEntsTotal.timing + this.timingEntitiesTotal.timing + this.timingHandlersTotal.timing);
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case NEXUS_DATA: {
                NexusData data = (NexusData)rawdata.value;
                SwingUtilities.invokeLater(() -> {
                    this.getLblAmountTileEnts().setText(String.valueOf(data.amountTileEnts.value));
                    this.getLblAmountEntities().setText(String.valueOf(data.amountEntities.value));
                    double uploadKB = (double)data.packetOutbound.value / 1024.0;
                    this.getLblAmountUpload().setText(String.format("%.3f", uploadKB));
                    double downloadKB = (double)data.packetInbound.value / 1024.0;
                    this.getLblAmountDownload().setText(String.format("%.3f", downloadKB));
                    this.setTimingTick(data.timingTick);
                    this.getLblAmountForced().setText(String.valueOf(data.chunkForced.value));
                    this.getLblAmountLoaded().setText(String.valueOf(data.chunkLoaded.value));
                });
                break;
            }
            case VALUE_TIMING_NETWORK: {
                break;
            }
            case VALUE_TIMING_TILEENTS: {
                SwingUtilities.invokeLater(() -> {
                    this.timingTileEntsTotal = ((DataTiming)rawdata.value).asMillisecond();
                    this.getLblTimingTileEnts().setText(this.timingTileEntsTotal.toString());
                    this.getLblTimingTotal().setText(String.format("%s", this.getProfiledTickTotalTime().toString()));
                });
                break;
            }
            case VALUE_TIMING_ENTITIES: {
                SwingUtilities.invokeLater(() -> {
                    this.timingEntitiesTotal = ((DataTiming)rawdata.value).asMillisecond();
                    this.getLblTimingEntities().setText(this.timingEntitiesTotal.toString());
                    this.getLblTimingTotal().setText(String.format("%s", this.getProfiledTickTotalTime().toString()));
                });
                break;
            }
            case VALUE_TIMING_WORLDTICK: {
                SwingUtilities.invokeLater(() -> {
                    this.timingWorldTickTotal = ((DataBlockTick)rawdata.value).total.asMillisecond();
                    this.getLblTimingWorldTick().setText(this.timingWorldTickTotal.toString());
                    this.getLblTimingTotal().setText(String.format("%s", this.getProfiledTickTotalTime().toString()));
                    String tooltip = "<html><font face=\"monospace\"><pre>";
                    for (Integer indim : ((DataBlockTick)rawdata.value).perdim.keySet()) {
                        tooltip = tooltip + String.format("[ %4d ] %s<br>", indim, ((DataBlockTick)rawdata.value).perdim.get(indim).asMillisecond().toString());
                    }
                    tooltip = tooltip + "</pre></html>";
                    this.getLblTimingWorldTick().setToolTipText(tooltip);
                });
                break;
            }
            case STATUS_START: {
                SwingUtilities.invokeLater(() -> {
                    this.getBtnRun().setText("Running...");
                    this.setProgressBar(0, ((SerialInt)rawdata.value).value, 0);
                });
                break;
            }
            case STATUS_STOP: {
                SwingUtilities.invokeLater(() -> {
                    this.getBtnRun().setText("Run Opis");
                    this.setProgressBar(0, ((SerialInt)rawdata.value).value, ((SerialInt)rawdata.value).value);
                });
                break;
            }
            case STATUS_RUN_UPDATE: {
                SwingUtilities.invokeLater(() -> this.setProgressBar(-1, -1, ((SerialInt)rawdata.value).value));
                break;
            }
            case STATUS_RUNNING: {
                SwingUtilities.invokeLater(() -> {
                    this.getBtnRun().setText("Running...");
                    this.setProgressBar(-1, -1, ((SerialInt)rawdata.value).value);
                });
                break;
            }
            case STATUS_TIME_LAST_RUN: {
                SwingUtilities.invokeLater(() -> {
                    long serverLastRun = ((SerialLong)rawdata.value).value;
                    if (serverLastRun == 0L) {
                        this.getLblTimeStamp().setText("Last run : <Never>");
                    } else {
                        long clientLastRun = serverLastRun + DataCache.instance().getClockScrew();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date resultdate = new Date(clientLastRun);
                        this.getLblTimeStamp().setText(String.format("Last run : %s", sdf.format(resultdate)));
                    }
                });
                break;
            }
            case VALUE_TIMING_ENTUPDATE: {
                break;
            }
            case STATUS_PING: {
                SwingUtilities.invokeLater(() -> {
                    this.pingData.addValue(System.nanoTime() - ((SerialLong)rawdata.value).value);
                    ++this.nPings;
                    DataTiming timing = new DataTiming(this.pingData.getGeometricMean());
                    this.setTimingPing(timing);
                    this.getLblTimingPing().setText(timing.asMillisecond().toString());
                });
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public JLabel getLblTimingNetwork() {
        return this.lblTimingNetwork;
    }

    public JLabel getLblTimingPing() {
        return this.lblTimingPing;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.SUMMARY;
    }

    @Override
    public boolean refreshOnString() {
        return false;
    }
}

