/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.util.ArrayList;
import java.util.List;
import net.malisis.core.util.Point;
import net.malisis.core.util.Vector;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class Ray {
    public Point origin;
    public Vector direction;

    public Ray(Point p, Vector v) {
        this.origin = p;
        this.direction = v;
    }

    public Ray(Ray r) {
        this.origin = new Point(r.origin);
        this.direction = new Vector(r.direction);
    }

    public Ray(Vec3 src, Vec3 dest) {
        this.origin = new Point(src);
        this.direction = new Vector(this.origin, new Point(dest));
    }

    public Point getPointAt(double t) {
        if (Double.isNaN(t)) {
            return null;
        }
        return new Point(this.origin.x + t * this.direction.x, this.origin.y + t * this.direction.y, this.origin.z + t * this.direction.z);
    }

    public double intersectX(double x) {
        if (this.direction.x == 0.0) {
            return Double.NaN;
        }
        return (x - this.origin.x) / this.direction.x;
    }

    public double intersectY(double y) {
        if (this.direction.y == 0.0) {
            return Double.NaN;
        }
        return (y - this.origin.y) / this.direction.y;
    }

    public double intersectZ(double z) {
        if (this.direction.z == 0.0) {
            return Double.NaN;
        }
        return (z - this.origin.z) / this.direction.z;
    }

    public List<Pair<ForgeDirection, Point>> intersect(AxisAlignedBB aabb) {
        double ix = this.intersectX(aabb.field_72340_a);
        double iX = this.intersectX(aabb.field_72336_d);
        double iy = this.intersectY(aabb.field_72338_b);
        double iY = this.intersectY(aabb.field_72337_e);
        double iz = this.intersectZ(aabb.field_72339_c);
        double iZ = this.intersectZ(aabb.field_72334_f);
        Point interx = ix >= 0.0 ? this.getPointAt(ix) : null;
        Point interX = iX >= 0.0 ? this.getPointAt(iX) : null;
        Point intery = iy >= 0.0 ? this.getPointAt(iy) : null;
        Point interY = iY >= 0.0 ? this.getPointAt(iY) : null;
        Point interz = iz >= 0.0 ? this.getPointAt(iz) : null;
        Point interZ = iZ >= 0.0 ? this.getPointAt(iZ) : null;
        ArrayList<Pair<ForgeDirection, Point>> list = new ArrayList<Pair<ForgeDirection, Point>>();
        if (interx != null && interx.isInside(aabb)) {
            list.add(Pair.of((Object)ForgeDirection.WEST, (Object)interx));
        }
        if (interX != null && interX.isInside(aabb)) {
            list.add(Pair.of((Object)ForgeDirection.EAST, (Object)interX));
        }
        if (intery != null && intery.isInside(aabb)) {
            list.add((Pair<ForgeDirection, Point>)Pair.of((Object)ForgeDirection.DOWN, (Object)intery));
        }
        if (interY != null && interY.isInside(aabb)) {
            list.add((Pair<ForgeDirection, Point>)Pair.of((Object)ForgeDirection.UP, (Object)interY));
        }
        if (interz != null && interz.isInside(aabb)) {
            list.add((Pair<ForgeDirection, Point>)Pair.of((Object)ForgeDirection.NORTH, (Object)interz));
        }
        if (interZ != null && interZ.isInside(aabb)) {
            list.add((Pair<ForgeDirection, Point>)Pair.of((Object)ForgeDirection.SOUTH, (Object)interZ));
        }
        return list;
    }
}

