/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.GTpp.loader;

import com.github.bartimaeusnek.bartworks.API.IRadMaterial;
import com.github.bartimaeusnek.bartworks.util.log.DebugLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryNamespaced;
import net.minecraftforge.oredict.OreDictionary;

public class RadioHatchCompat {
    private static Class<?> intf;
    private static Class<?> materialClass;
    private static Class<?> enu;
    private static Class<?> materialStackClass;
    private static Field isRadioactive;
    private static Field f;
    private static Field componentType;
    private static Field radlevel;
    private static Field protons;
    private static Field vMaterialInput;
    private static Field stackMaterial;
    private static Field RGBA;
    private static Field localizedName;
    private static Field unlocalizedName;
    private static Object rod;
    private static Object longRod;
    public static HashSet<String> TranslateSet;

    public static void run() {
        DebugLog.log("Starting Generation of missing GT++ rods/longrods");
        try {
            Class<?> rodclass = Class.forName("gtPlusPlus.core.item.base.rods.BaseItemRod");
            Class<?> longrodclass = Class.forName("gtPlusPlus.core.item.base.rods.BaseItemRodLong");
            Constructor<?> c1 = rodclass.getConstructor(materialClass);
            Constructor<?> c2 = longrodclass.getConstructor(materialClass);
            Field cOwners = GameData.class.getDeclaredField("customOwners");
            cOwners.setAccessible(true);
            Field map = RegistryNamespaced.class.getDeclaredField("field_148758_b");
            map.setAccessible(true);
            Map UniqueIdentifierMap = (Map)map.get(GameData.getItemRegistry());
            Map ownerItems = (Map)cOwners.get(null);
            ModContainer gtpp = null;
            ModContainer bartworks = null;
            for (ModContainer container : Loader.instance().getModList()) {
                if (gtpp != null && bartworks != null) break;
                if ("bartworkscrossmod".equalsIgnoreCase(container.getModId())) {
                    bartworks = container;
                    continue;
                }
                if (!container.getModId().equalsIgnoreCase(Mods.GTPlusPlus.ID)) continue;
                gtpp = container;
            }
            for (Object mats : (Set)materialClass.getField("mMaterialMap").get(null)) {
                if (!isRadioactive.getBoolean(mats)) continue;
                if (OreDictionary.getOres((String)("stick" + unlocalizedName.get(mats))).isEmpty()) {
                    Item it = (Item)c1.newInstance(mats);
                    UniqueIdentifierMap.replace(it, "miscutils:" + it.func_77658_a());
                    GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)it);
                    ownerItems.replace(ui, bartworks, gtpp);
                    String tanslate = it.func_77658_a() + ".name=" + localizedName.get(mats) + " Rod";
                    TranslateSet.add(tanslate);
                    DebugLog.log(tanslate);
                    DebugLog.log("Generate: " + rod + unlocalizedName.get(mats));
                }
                if (!OreDictionary.getOres((String)("stickLong" + unlocalizedName.get(mats))).isEmpty()) continue;
                Item it2 = (Item)c2.newInstance(mats);
                UniqueIdentifierMap.replace(it2, "miscutils:" + it2.func_77658_a());
                GameRegistry.UniqueIdentifier ui2 = GameRegistry.findUniqueIdentifierFor((Item)it2);
                ownerItems.replace(ui2, bartworks, gtpp);
                DebugLog.log("Generate: " + longRod + unlocalizedName.get(mats));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static IRadMaterial GTppRadChecker(ItemStack lStack) {
        try {
            if (intf.isAssignableFrom(lStack.func_77973_b().getClass())) {
                int amount;
                if (!isRadioactive.getBoolean(f.get(lStack.func_77973_b()))) {
                    return null;
                }
                int n = componentType.get(lStack.func_77973_b()).equals(rod) ? 1 : (amount = componentType.get(lStack.func_77973_b()).equals(longRod) ? 2 : 0);
                if (amount == 0) {
                    return null;
                }
                return new GTPPRadAdapter(amount, f.get(lStack.func_77973_b()));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        TranslateSet = new HashSet();
        try {
            ?[] arr;
            intf = Class.forName("gtPlusPlus.core.item.base.BaseItemComponent");
            enu = Class.forName("gtPlusPlus.core.item.base.BaseItemComponent$ComponentTypes");
            materialClass = Class.forName("gtPlusPlus.core.material.Material");
            materialStackClass = Class.forName("gtPlusPlus.core.material.MaterialStack");
            f = intf.getField("componentMaterial");
            isRadioactive = materialClass.getField("isRadioactive");
            componentType = intf.getDeclaredField("componentType");
            radlevel = materialClass.getField("vRadiationLevel");
            vMaterialInput = materialClass.getDeclaredField("vMaterialInput");
            stackMaterial = materialStackClass.getDeclaredField("stackMaterial");
            protons = materialClass.getDeclaredField("vProtons");
            RGBA = materialClass.getDeclaredField("RGBA");
            localizedName = materialClass.getDeclaredField("localizedName");
            unlocalizedName = materialClass.getDeclaredField("unlocalizedName");
            vMaterialInput.setAccessible(true);
            stackMaterial.setAccessible(true);
            protons.setAccessible(true);
            RGBA.setAccessible(true);
            localizedName.setAccessible(true);
            unlocalizedName.setAccessible(true);
            for (Object o : arr = enu.getEnumConstants()) {
                if (rod == null || longRod == null) {
                    if ("ROD".equalsIgnoreCase(o.toString())) {
                        rod = o;
                        continue;
                    }
                    if (!"RODLONG".equalsIgnoreCase(o.toString())) continue;
                    longRod = o;
                    continue;
                }
                break;
            }
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    static class GTPPRadAdapter
    implements IRadMaterial {
        static final HashMap<Object, Integer> BUFFER = new HashMap();
        byte amount;
        final Object m;

        GTPPRadAdapter(Object m) {
            this.m = m;
        }

        GTPPRadAdapter(int amount, Object m) {
            this.amount = (byte)amount;
            this.m = m;
        }

        private static ArrayList<?> getMaterialInput(Object GTPPMaterial) throws IllegalAccessException {
            Object ret = vMaterialInput.get(GTPPMaterial);
            return ret instanceof ArrayList ? (ArrayList)ret : new ArrayList();
        }

        private static boolean isElement(Object GTPPMaterial) throws IllegalAccessException {
            return GTPPRadAdapter.getMaterialInput(GTPPMaterial).isEmpty();
        }

        private static List<?> getElemets(Object GTPPMaterial) throws IllegalAccessException {
            ArrayList<Object> elements = new ArrayList<Object>();
            LinkedList<Object> toCheck = new LinkedList<Object>();
            ArrayList<?> materialInputs = GTPPRadAdapter.getMaterialInput(GTPPMaterial);
            if (materialInputs.isEmpty()) {
                return Collections.singletonList(GTPPMaterial);
            }
            for (Object materialStack : materialInputs) {
                if (!GTPPRadAdapter.isElement(stackMaterial.get(materialStack))) {
                    toCheck.add(stackMaterial.get(materialStack));
                    continue;
                }
                elements.add(stackMaterial.get(materialStack));
            }
            while (!toCheck.isEmpty()) {
                elements.addAll(GTPPRadAdapter.getElemets(toCheck.poll()));
            }
            return elements;
        }

        private static Integer calulateRad(Object m) {
            int ret = 0;
            try {
                List<?> pureElements = GTPPRadAdapter.getElemets(m);
                for (Object materialObj : pureElements) {
                    if (isRadioactive.getBoolean(materialObj)) {
                        ret = (int)((long)ret + ((long)radlevel.getByte(m) + GTPPRadAdapter.clampToZero(protons.getLong(materialObj))));
                        continue;
                    }
                    ret += radlevel.getByte(m);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return ret;
        }

        @Override
        public int getRadiationLevel(ItemStack aStack) {
            return BUFFER.computeIfAbsent(this.m, radlvl -> GTPPRadAdapter.calulateRad(this.m));
        }

        private static long clampToZero(long number) {
            return number > 0L ? number : 0L;
        }

        @Override
        public byte getAmountOfMaterial(ItemStack aStack) {
            return this.amount;
        }

        @Override
        public short[] getColorForGUI(ItemStack aStack) {
            short[] rgba = new short[]{0, 0, 0, 0};
            try {
                rgba = (short[])RGBA.get(this.m);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return rgba;
        }

        @Override
        public String getNameForGUI(ItemStack aStack) {
            String ret = "";
            try {
                ret = (String)localizedName.get(this.m);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return ret;
        }
    }
}

