/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.render;

import com.gtnewhorizons.gtnhintergalactic.block.BlockSpaceElevatorCable;
import com.gtnewhorizons.gtnhintergalactic.config.Config;
import com.gtnewhorizons.gtnhintergalactic.tile.TileEntitySpaceElevatorCable;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.apache.logging.log4j.Level;
import org.joml.Math;
import org.joml.Matrix4fStack;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class RenderSpaceElevatorCable
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    private static final ResourceLocation climberTexture = new ResourceLocation("gtnhintergalactic", "textures/models/climber.png");
    private static IModelCustom modelCustom;
    private static final int CLIMBER_OFFSET = 50;
    private static final int MIN_CLIMBER_HEIGHT = 100;
    boolean isInitialized = false;
    private static final float LONG_DISTANCE;
    private static final float SHORT_DISTANCE = 0.18518518f;
    private static final double CABLE_HEIGHT = 512.0;
    private static final float[] edgeX;
    private static final float[] edgeZ;
    private static int cableProgram;
    private static int uModelProjectionMatrix;
    private static int uBlockTex;
    private static int uSectionHeight;
    private static int uTime;
    private static int uBaseY;
    private static int uGlowU;
    private static int uGlowV;
    private static int uUV;
    private static int aVertexID;
    private static int vertexIDBuffer;
    private static final FloatBuffer bufModelViewProjection;
    private static final Matrix4fStack modelProjection;
    private static final float SIDE = 0.37037036f;
    private static final float SECTION_HEIGHT = 2.9629629f;
    private static final int SECTIONS;
    private static final int VERTEX_COUNT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String filename) throws Exception {
        StringBuilder source;
        block28: {
            source = new StringBuilder();
            InputStream in = RenderSpaceElevatorCable.class.getResourceAsStream(filename);
            Exception exception = null;
            if (in == null) {
                return "";
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                Exception innerExc = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        source.append(line).append('\n');
                    }
                }
                catch (Exception exc) {
                    exception = exc;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exc) {
                        if (innerExc == null) {
                            innerExc = exc;
                        }
                        exc.printStackTrace(System.err);
                    }
                }
                if (innerExc != null) {
                    throw innerExc;
                }
            }
            catch (Exception exc) {
                exception = exc;
                return exception;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exc) {
                    if (exception == null) {
                        exception = exc;
                    }
                    exc.printStackTrace(System.err);
                }
                if (exception == null) break block28;
                throw exception;
            }
        }
        return source.toString();
    }

    private static String getLogInfo(int obj) {
        return GL20.glGetShaderInfoLog((int)obj, (int)GL20.glGetShaderi((int)obj, (int)35716));
    }

    private static int createProgram(String vert, String frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = RenderSpaceElevatorCable.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = RenderSpaceElevatorCable.createShader(frag, 35632);
        }
        if ((program = GL20.glCreateProgram()) == 0) {
            return 0;
        }
        if (vert != null) {
            GL20.glAttachShader((int)program, (int)vertId);
        }
        if (frag != null) {
            GL20.glAttachShader((int)program, (int)fragId);
        }
        GL20.glLinkProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            FMLLog.log((Level)Level.ERROR, (String)RenderSpaceElevatorCable.getLogInfo(program), (Object[])new Object[0]);
            return 0;
        }
        GL20.glValidateProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            FMLLog.log((Level)Level.ERROR, (String)RenderSpaceElevatorCable.getLogInfo(program), (Object[])new Object[0]);
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = GL20.glCreateShader((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            GL20.glShaderSource((int)shader, (CharSequence)RenderSpaceElevatorCable.readFileAsString(filename));
            GL20.glCompileShader((int)shader);
            if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + RenderSpaceElevatorCable.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            GL20.glDeleteProgram((int)shader);
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public RenderSpaceElevatorCable() {
        modelCustom = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("gtnhintergalactic", "models/climber.obj"));
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (!Config.isCableRenderingEnabled) {
            return;
        }
        if (!(tile instanceof TileEntitySpaceElevatorCable)) {
            return;
        }
        TileEntitySpaceElevatorCable cableTile = (TileEntitySpaceElevatorCable)tile;
        if (!cableTile.shouldRender()) {
            return;
        }
        this.renderCable(tile, x, y, z, timeSinceLastTick);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5 + (double)cableTile.getClimberHeight() + (double)(50 + cableTile.field_145848_d < 100 ? 100 : 50)), (double)(z + 0.5));
        GL11.glRotated((double)cableTile.getClimberRotation(), (double)0.0, (double)1.0, (double)0.0);
        this.renderClimber();
        GL11.glPopMatrix();
    }

    private void renderClimber() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_147499_a(climberTexture);
        GL11.glScaled((double)4.0, (double)4.0, (double)4.0);
        modelCustom.renderAll();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
    }

    private void renderCable(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        GL13.glActiveTexture((int)33984);
        this.func_147499_a(TextureMap.field_110575_b);
        if (!this.isInitialized) {
            float minU = BlockSpaceElevatorCable.textures[0].func_94209_e();
            float maxU = BlockSpaceElevatorCable.textures[0].func_94212_f();
            float minV = BlockSpaceElevatorCable.textures[0].func_94206_g();
            float maxV = BlockSpaceElevatorCable.textures[0].func_94210_h();
            float glowMinU = Math.lerp((float)minU, (float)maxU, (float)0.4375f);
            float glowMaxU = Math.lerp((float)minU, (float)maxU, (float)0.5625f);
            float glowMinV = Math.lerp((float)minV, (float)maxV, (float)0.4375f);
            float glowMaxV = Math.lerp((float)minV, (float)maxV, (float)0.5625f);
            cableProgram = RenderSpaceElevatorCable.createProgram("/assets/gtnhintergalactic/shaders/spacecable.vert.glsl", "/assets/gtnhintergalactic/shaders/spacecable.frag.glsl");
            GL20.glUseProgram((int)cableProgram);
            aVertexID = GL20.glGetAttribLocation((int)cableProgram, (CharSequence)"vertexId");
            uModelProjectionMatrix = GL20.glGetUniformLocation((int)cableProgram, (CharSequence)"u_ModelProjection");
            uBlockTex = GL20.glGetUniformLocation((int)cableProgram, (CharSequence)"u_BlockTex");
            uSectionHeight = GL20.glGetUniformLocation((int)cableProgram, (CharSequence)"u_SectionHeight");
            uTime = GL20.glGetUniformLocation((int)cableProgram, (CharSequence)"u_Time");
            uBaseY = GL20.glGetUniformLocation((int)cableProgram, (CharSequence)"u_BaseY");
            uGlowU = GL20.glGetUniformLocation((int)cableProgram, (CharSequence)"u_GlowU");
            uGlowV = GL20.glGetUniformLocation((int)cableProgram, (CharSequence)"u_GlowV");
            uUV = GL20.glGetUniformLocation((int)cableProgram, (CharSequence)"u_UV");
            vertexIDBuffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vertexIDBuffer);
            ByteBuffer vertexIDData = BufferUtils.createByteBuffer((int)(VERTEX_COUNT * 4 * 3));
            for (int i = 0; i < VERTEX_COUNT * 3; ++i) {
                vertexIDData.putFloat(i * 4, i);
            }
            GL15.glBufferData((int)34962, (ByteBuffer)vertexIDData, (int)35044);
            GL15.glBindBuffer((int)34962, (int)0);
            FloatBuffer uvBuffer = BufferUtils.createFloatBuffer((int)4);
            uvBuffer.put(0, minU);
            uvBuffer.put(1, minV);
            uvBuffer.put(2, maxU);
            uvBuffer.put(3, maxV);
            GL20.glUniform1f((int)uSectionHeight, (float)2.9629629f);
            GL20.glUniform1i((int)uBlockTex, (int)(OpenGlHelper.field_77478_a - 33984));
            GL20.glUniform2f((int)uGlowU, (float)glowMinU, (float)glowMaxU);
            GL20.glUniform2f((int)uGlowV, (float)glowMinV, (float)glowMaxV);
            GL20.glUniform2((int)uUV, (FloatBuffer)uvBuffer);
            GL20.glUseProgram((int)0);
            this.isInitialized = true;
        }
        GL20.glUseProgram((int)cableProgram);
        GL20.glUniform1f((int)uTime, (float)(((float)(tile.func_145831_w().func_72912_H().func_82573_f() % 60L) + timeSinceLastTick) / 60.0f));
        GL20.glUniform1i((int)uBaseY, (int)((int)y - 23));
        modelProjection.identity();
        modelProjection.translate((float)x, (float)(y - 23.0), (float)z);
        GL11.glDisable((int)2884);
        modelProjection.get(0, bufModelViewProjection);
        GL20.glUniformMatrix4((int)uModelProjectionMatrix, (boolean)false, (FloatBuffer)bufModelViewProjection);
        GL15.glBindBuffer((int)34962, (int)vertexIDBuffer);
        GL20.glVertexAttribPointer((int)aVertexID, (int)1, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)aVertexID);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        GL11.glEnableClientState((int)32884);
        GL11.glDrawArrays((int)4, (int)0, (int)VERTEX_COUNT);
        GL11.glDisableClientState((int)32884);
        GL20.glDisableVertexAttribArray((int)aVertexID);
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glEnable((int)2884);
        GL20.glUseProgram((int)0);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glPushMatrix();
        IIcon side = BlockSpaceElevatorCable.textures[0];
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        tes.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntitySpaceElevatorCable && !((TileEntitySpaceElevatorCable)te).shouldRender()) {
            GL11.glPushMatrix();
            IIcon side = BlockSpaceElevatorCable.textures[0];
            float minU = side.func_94209_e();
            float maxU = side.func_94212_f();
            float minV = side.func_94206_g();
            float maxV = side.func_94210_h();
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78374_a((double)x, (double)y, (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)z, (double)maxU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)minU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)z, (double)minU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)maxU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)(z + 1), (double)minU, (double)maxV);
            tes.func_78374_a((double)x, (double)y, (double)(z + 1), (double)maxU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)z, (double)minU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)z, (double)minU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)maxU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)minU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)z, (double)minU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)minU, (double)maxV);
            GL11.glPopMatrix();
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockSpaceElevatorCable.getRenderID();
    }

    static {
        LONG_DISTANCE = (1.0f + Math.sqrt((float)2.0f)) / 5.4f;
        edgeX = new float[]{LONG_DISTANCE, LONG_DISTANCE, 0.18518518f, -0.18518518f, -LONG_DISTANCE, -LONG_DISTANCE, -0.18518518f, 0.18518518f};
        edgeZ = new float[]{0.18518518f, -0.18518518f, -LONG_DISTANCE, -LONG_DISTANCE, -0.18518518f, 0.18518518f, LONG_DISTANCE, LONG_DISTANCE};
        aVertexID = -1;
        vertexIDBuffer = -1;
        bufModelViewProjection = BufferUtils.createFloatBuffer((int)16);
        modelProjection = new Matrix4fStack(2);
        SECTIONS = (int)Math.ceil((double)172.80000566482562);
        VERTEX_COUNT = 192 * SECTIONS;
    }
}

