/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.ic2;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorChamberElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorRedstonePort;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class DriverReactorRedstonePort
extends DriverSidedTileEntity {
    @Override
    public Class<?> getTileEntityClass() {
        return TileEntityReactorRedstonePort.class;
    }

    @Override
    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
        return new Environment((TileEntityReactorRedstonePort)world.func_147438_o(x, y, z));
    }

    public static final class Environment
    extends ManagedTileEntityEnvironment<TileEntityReactorRedstonePort>
    implements NamedBlock {
        public Environment(TileEntityReactorRedstonePort tileEntity) {
            super(tileEntity, "reactor_redstone_port");
        }

        @Override
        public String preferredName() {
            return "reactor_redstone_port";
        }

        @Override
        public int priority() {
            return 0;
        }

        private IReactor getReactor() {
            TileEntity reactorInventory = ((TileEntityReactorRedstonePort)this.tileEntity).getReactor();
            if (reactorInventory instanceof IReactor) {
                return (IReactor)reactorInventory;
            }
            return ((IReactorChamber)reactorInventory).getReactor();
        }

        @Callback(doc="function(active:boolean): boolean -- activate or deactivate the reactor")
        public Object[] setActive(Context context, Arguments args) {
            TileEntityReactorChamberElectric reactorChamberElectric = (TileEntityReactorChamberElectric)((TileEntityReactorRedstonePort)this.tileEntity).getReactor();
            TileEntityNuclearReactorElectric reactor = reactorChamberElectric.getReactor();
            if (reactor != null) {
                reactor.setRedstoneSignal(args.optBoolean(0, false));
                return new Object[]{reactor.receiveredstone()};
            }
            return new Object[]{false};
        }

        @Callback(doc="function():number -- Get the reactor's heat.")
        public Object[] getHeat(Context context, Arguments args) {
            IReactor reactor = this.getReactor();
            if (reactor != null) {
                return new Object[]{reactor.getHeat()};
            }
            return new Object[]{0};
        }

        @Callback(doc="function():number -- Get the reactor's maximum heat before exploding.")
        public Object[] getMaxHeat(Context context, Arguments args) {
            IReactor reactor = this.getReactor();
            if (reactor != null) {
                return new Object[]{reactor.getMaxHeat()};
            }
            return new Object[]{0};
        }

        @Callback(doc="function():number -- Get the reactor's energy output. Not multiplied with the base EU/t value.")
        public Object[] getReactorEnergyOutput(Context context, Arguments args) {
            IReactor reactor = this.getReactor();
            if (reactor != null) {
                return new Object[]{Float.valueOf(reactor.getReactorEnergyOutput())};
            }
            return new Object[]{0};
        }

        @Callback(doc="function():number -- Get the reactor's base EU/t value.")
        public Object[] getReactorEUOutput(Context context, Arguments args) {
            return new Object[]{this.getReactor().getReactorEUEnergyOutput()};
        }

        @Callback(doc="function():boolean -- Get whether the reactor is active and supposed to produce energy.")
        public Object[] producesEnergy(Context context, Arguments args) {
            IReactor reactor = this.getReactor();
            if (reactor != null) {
                return new Object[]{reactor.produceEnergy()};
            }
            return new Object[]{false};
        }
    }
}

