/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.google.common.math.LongMath;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.InventoryType;
import gregtech.api.enums.Textures;
import gregtech.api.fluid.FluidTankGT;
import gregtech.api.gui.GUIHost;
import gregtech.api.gui.GUIProvider;
import gregtech.api.interfaces.ITexture;
import gregtech.api.logic.FluidInventoryLogic;
import gregtech.api.logic.ItemInventoryLogic;
import gregtech.api.logic.NullPowerLogic;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.base.NonTickableMultiTileEntity;
import gregtech.api.multitileentity.enums.MultiTileCasingPurpose;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.interfaces.IMultiBlockPart;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.covers.CoverInfo;
import gregtech.common.gui.PartGUIProvider;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class MultiBlockPart
extends NonTickableMultiTileEntity
implements IMultiBlockPart,
IMultiTileEntity.IMTE_HasModes,
PowerLogicHost,
IMultiTileEntity.IMTE_AddToolTips,
GUIHost {
    public static final int NOTHING = 0;
    public static final int ENERGY_IN = GT_Values.B[0];
    public static final int ENERGY_OUT = GT_Values.B[1];
    public static final int FLUID_IN = GT_Values.B[2];
    public static final int FLUID_OUT = GT_Values.B[3];
    public static final int ITEM_IN = GT_Values.B[4];
    public static final int ITEM_OUT = GT_Values.B[5];
    protected final List<Integer> BASIC_MODES = new ArrayList<Integer>(Arrays.asList(0, ENERGY_IN, ENERGY_OUT, FLUID_IN, FLUID_OUT, ITEM_IN, ITEM_OUT));
    protected Set<MultiTileCasingPurpose> registeredPurposes = new HashSet<MultiTileCasingPurpose>();
    protected ChunkCoordinates targetPosition = null;
    protected int allowedModes = 0;
    protected int mode = 0;
    protected UUID lockedInventory;
    protected int mLockedInventoryIndex = 0;
    protected FluidTankGT configurationTank = new FluidTankGT();
    @Nonnull
    protected final GUIProvider<?> guiProvider = this.createGUIProvider();

    public int getPartTier() {
        return 1;
    }

    @Override
    public UUID getLockedInventory() {
        return this.lockedInventory;
    }

    public void setTarget(IMultiBlockController newTarget, int aAllowedModes) {
        IMultiBlockController currentTarget = this.getTarget(false);
        if (currentTarget != null && currentTarget != newTarget) {
            for (MultiTileCasingPurpose purpose : this.registeredPurposes) {
                this.unregisterPurpose(purpose);
            }
        }
        this.targetPosition = newTarget == null ? null : newTarget.getCoords();
        this.allowedModes = aAllowedModes;
        if (newTarget != null) {
            this.registerCovers(newTarget);
            this.registerPurposes();
        }
    }

    protected void registerPurpose(MultiTileCasingPurpose purpose) {
        IMultiBlockController target = this.getTarget(false);
        if (target != null) {
            target.registerCaseWithPurpose(purpose, this);
            this.registeredPurposes.add(purpose);
        }
    }

    protected void unregisterPurpose(MultiTileCasingPurpose purpose) {
        IMultiBlockController target = this.getTarget(false);
        if (target != null) {
            target.unregisterCaseWithPurpose(purpose, this);
        }
        this.registeredPurposes.remove((Object)purpose);
    }

    @Override
    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
        IMultiBlockController controller = this.getTarget(false);
        if (controller != null) {
            tList.add("Has controller");
        } else {
            tList.add("No Controller");
        }
        tList.add("Casing Mode: " + this.getModeName(this.mode));
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        currentTip.add(String.format("Mode: %s", this.getModeName(this.mode)));
        if (this.modeSelected(FLUID_OUT)) {
            if (this.configurationTank != null && this.configurationTank.get() != null) {
                currentTip.add(String.format("Locked to: %s", this.configurationTank.get().getLocalizedName()));
            } else {
                currentTip.add("Locked to: Nothing");
            }
        }
    }

    public IMultiBlockController getTarget(boolean aCheckValidity) {
        IMultiBlockController targetFound;
        if (this.targetPosition == null) {
            return null;
        }
        if (!this.field_145850_b.func_72899_e(this.targetPosition.field_71574_a, this.targetPosition.field_71572_b, this.targetPosition.field_71573_c)) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.targetPosition.field_71574_a, this.targetPosition.field_71572_b, this.targetPosition.field_71573_c);
        IMultiBlockController target = null;
        if (!(te instanceof IMultiBlockController)) {
            this.targetPosition = null;
            return null;
        }
        target = targetFound = (IMultiBlockController)te;
        if (aCheckValidity) {
            return target != null && target.checkStructure(false) ? target : null;
        }
        return target;
    }

    public void registerCovers(IMultiBlockController controller) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(side);
            if (!coverInfo.isValid() || coverInfo.getTickRate() <= 0) continue;
            controller.registerCoveredPartOnSide(side, this);
        }
    }

    protected void registerPurposes() {
        for (MultiTileCasingPurpose purpose : this.registeredPurposes) {
            this.registerPurpose(purpose);
        }
    }

    @Override
    public void setCoverItemAtSide(ForgeDirection side, ItemStack aCover) {
        super.setCoverItemAtSide(side, aCover);
        IMultiBlockController tTarget = this.getTarget(true);
        if (tTarget == null) {
            return;
        }
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (coverInfo.isValid() && coverInfo.getTickRate() > 0) {
            tTarget.registerCoveredPartOnSide(side, this);
        }
    }

    public void unregisterCovers(IMultiBlockController controller) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.getCoverInfoAtSide(side).isValid()) continue;
            controller.unregisterCoveredPartOnSide(side, this);
        }
    }

    @Override
    public boolean dropCover(ForgeDirection side, ForgeDirection droppedSide, boolean aForced) {
        boolean res = super.dropCover(side, droppedSide, aForced);
        IMultiBlockController tTarget = this.getTarget(true);
        if (tTarget != null) {
            tTarget.unregisterCoveredPartOnSide(side, this);
        }
        return res;
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("gt.amode")) {
            this.allowedModes = aNBT.func_74762_e("gt.amode");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.setMode(aNBT.func_74771_c("gt.mode"));
        }
        if (aNBT.func_74764_b("gt.target")) {
            this.targetPosition = new ChunkCoordinates(aNBT.func_74762_e("gt.target.x"), (int)aNBT.func_74765_d("gt.target.y"), aNBT.func_74762_e("gt.target.z"));
        }
        if (aNBT.func_74764_b("gt.locked.inv")) {
            this.lockedInventory = UUID.fromString(aNBT.func_74779_i("gt.locked.inv"));
        }
        if (aNBT.func_74764_b("gt.locked.inv.index")) {
            this.mLockedInventoryIndex = aNBT.func_74762_e("gt.locked.inv.index");
        }
        if (aNBT.func_74764_b("gt.locked.fluid")) {
            this.configurationTank.readFromNBT(aNBT, "gt.locked.fluid");
        }
        if (this.modeSelected(ITEM_OUT)) {
            this.registeredPurposes.add(MultiTileCasingPurpose.ItemOutput);
        }
        if (this.modeSelected(FLUID_OUT)) {
            this.registeredPurposes.add(MultiTileCasingPurpose.FluidOutput);
        }
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound aNBT) {
        if (this.allowedModes != 0) {
            aNBT.func_74768_a("gt.amode", this.allowedModes);
        }
        if (this.mode != 0) {
            aNBT.func_74768_a("gt.mode", this.mode);
        }
        if (this.targetPosition != null) {
            aNBT.func_74757_a("gt.target", true);
            aNBT.func_74768_a("gt.target.x", this.targetPosition.field_71574_a);
            aNBT.func_74777_a("gt.target.y", (short)this.targetPosition.field_71572_b);
            aNBT.func_74768_a("gt.target.z", this.targetPosition.field_71573_c);
        }
        if (this.lockedInventory != null) {
            aNBT.func_74778_a("gt.locked.inv", this.lockedInventory.toString());
        }
        if (this.mLockedInventoryIndex != 0) {
            aNBT.func_74768_a("gt.locked.inv.index", this.mLockedInventoryIndex);
        }
        this.configurationTank.writeToNBT(aNBT, "gt.locked.fluid");
    }

    @Override
    public void setLockedInventoryIndex(int aIndex) {
        this.mLockedInventoryIndex = aIndex;
    }

    @Override
    public int getLockedInventoryIndex() {
        return this.mLockedInventoryIndex;
    }

    @Override
    public void setTargetPos(ChunkCoordinates aTargetPos) {
        this.targetPosition = aTargetPos;
        IMultiBlockController target = this.getTarget(false);
        this.setTarget(target, this.allowedModes);
    }

    @Override
    public ChunkCoordinates getTargetPos() {
        return this.targetPosition;
    }

    @Override
    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        if (this.modeSelected(FLUID_OUT)) {
            this.unregisterPurpose(MultiTileCasingPurpose.FluidOutput);
        }
        if (this.modeSelected(ITEM_OUT)) {
            this.unregisterPurpose(MultiTileCasingPurpose.ItemOutput);
        }
        this.mode = mode;
        if (this.modeSelected(FLUID_OUT)) {
            this.registerPurpose(MultiTileCasingPurpose.FluidOutput);
        }
        if (this.modeSelected(ITEM_OUT)) {
            this.registerPurpose(MultiTileCasingPurpose.ItemOutput);
        }
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public int getAllowedModes() {
        return this.allowedModes;
    }

    @Override
    public void setAllowedModes(int aAllowedModes) {
        this.allowedModes = aAllowedModes;
    }

    public boolean hasMode(int aMode) {
        return (this.allowedModes & aMode) != 0;
    }

    public boolean modeSelected(int ... aModes) {
        for (int aMode : aModes) {
            if (!this.hasMode(aMode) || this.mode != this.getModeOrdinal(aMode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean breakBlock() {
        IMultiBlockController tTarget = this.getTarget(false);
        if (tTarget != null) {
            this.unregisterCovers(tTarget);
            tTarget.onStructureChange();
        }
        return false;
    }

    @Override
    public void onBlockAdded() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.getTileEntityAtSide(side);
            if (te instanceof MultiBlockPart) {
                MultiBlockPart part = (MultiBlockPart)te;
                IMultiBlockController tController = part.getTarget(false);
                if (tController == null) continue;
                tController.onStructureChange();
                continue;
            }
            if (!(te instanceof IMultiBlockController)) continue;
            IMultiBlockController controller = (IMultiBlockController)te;
            controller.onStructureChange();
        }
    }

    @Override
    public ITexture getTexture(ForgeDirection side) {
        ITexture texture = super.getTexture(side);
        if (this.mode != 0 && side == this.facing) {
            if (this.mode == this.getModeOrdinal(ITEM_IN)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(ITEM_OUT)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.ITEM_OUT_SIGN), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(FLUID_IN)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of(Textures.BlockIcons.FLUID_IN_SIGN), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(FLUID_OUT)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.FLUID_OUT_SIGN), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(ENERGY_IN)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ENERGY_IN_MULTI), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(ENERGY_OUT)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ENERGY_OUT_MULTI), this.getCoverTexture(side));
            }
        }
        return TextureFactory.of(texture, this.getCoverTexture(side));
    }

    protected String getModeName(int aMode) {
        if (aMode == 0) {
            return "Nothing";
        }
        if (aMode == this.getModeOrdinal(ITEM_IN)) {
            return "Item Input";
        }
        if (aMode == this.getModeOrdinal(ITEM_OUT)) {
            return "Item Output";
        }
        if (aMode == this.getModeOrdinal(FLUID_IN)) {
            return "Fluid Input";
        }
        if (aMode == this.getModeOrdinal(FLUID_OUT)) {
            return "Fluid Output";
        }
        if (aMode == this.getModeOrdinal(ENERGY_IN)) {
            return "Energy Input";
        }
        if (aMode == this.getModeOrdinal(ENERGY_OUT)) {
            return "Energy Output";
        }
        return "Unknown";
    }

    protected byte getModeOrdinal(int aMode) {
        return (byte)(LongMath.log2((long)aMode, (RoundingMode)RoundingMode.UNNECESSARY) + 1);
    }

    protected byte getNextAllowedMode(List<Integer> allowedModes) {
        if (this.allowedModes == 0) {
            return 0;
        }
        int numModes = allowedModes.size();
        for (int i = 1; i <= numModes; i = (int)((byte)(i + 1))) {
            byte curMode = (byte)((this.mode + i) % numModes);
            if (curMode != 0 && !this.hasMode(1 << curMode - 1)) continue;
            return curMode;
        }
        return 0;
    }

    @Override
    public boolean onMalletRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        if (this.allowedModes == 0) {
            return true;
        }
        if (this.mode == 0) {
            this.facing = wrenchSide;
        }
        this.setMode(this.getNextAllowedMode(this.BASIC_MODES));
        if (aPlayer.func_70093_af()) {
            this.facing = wrenchSide;
        }
        GT_Utility.sendChatToPlayer(aPlayer, "Mode set to `" + this.getModeName(this.mode) + "' (" + this.mode + ")");
        this.sendClientData((EntityPlayerMP)aPlayer);
        return true;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.part";
    }

    @Override
    public boolean shouldTick(long tickTimer) {
        return this.modeSelected(ITEM_OUT, FLUID_OUT);
    }

    @Override
    @Nullable
    public FluidInventoryLogic getFluidLogic(@Nonnull ForgeDirection side, @Nonnull InventoryType type) {
        if (side != this.facing && side != ForgeDirection.UNKNOWN) {
            return null;
        }
        if (!this.modeSelected(FLUID_IN, FLUID_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return null;
        }
        return controller.getFluidLogic(this.modeSelected(FLUID_IN) ? InventoryType.Input : InventoryType.Output, this.lockedInventory);
    }

    @Override
    @Nonnull
    public PowerLogic getPowerLogic(@Nonnull ForgeDirection side) {
        if (side != this.facing && side != ForgeDirection.UNKNOWN) {
            return new NullPowerLogic();
        }
        if (!this.modeSelected(ENERGY_IN, ENERGY_OUT)) {
            return new NullPowerLogic();
        }
        IMultiBlockController controller = this.getTarget(true);
        if (controller == null) {
            return new NullPowerLogic();
        }
        return controller.getPowerLogic();
    }

    @Override
    public boolean isEnetInput() {
        return this.modeSelected(ENERGY_IN);
    }

    @Override
    public boolean isEnetOutput() {
        return this.modeSelected(ENERGY_OUT);
    }

    @Override
    @Nullable
    public ItemInventoryLogic getItemLogic(@Nonnull ForgeDirection side, @Nonnull InventoryType unused) {
        if (side != this.facing && side != ForgeDirection.UNKNOWN) {
            return null;
        }
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return null;
        }
        return controller.getItemLogic(this.modeSelected(ITEM_IN) ? InventoryType.Input : InventoryType.Output, this.lockedInventory);
    }

    @Override
    @Nullable
    public InventoryType getItemInventoryType() {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return InventoryType.Both;
        }
        return this.modeSelected(ITEM_IN) ? InventoryType.Input : InventoryType.Output;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public String getLocalName() {
        if (this.modeSelected(ITEM_IN)) {
            return "Input Inventory";
        }
        if (this.modeSelected(ITEM_OUT)) {
            return "Output Inventory";
        }
        if (this.modeSelected(FLUID_IN)) {
            return "Fluid Input Hatch";
        }
        if (this.modeSelected(FLUID_OUT)) {
            return "Fluid Output Hatch";
        }
        return "Unknown";
    }

    @Override
    public boolean hasGui(ForgeDirection side) {
        if (this.modeSelected(ENERGY_IN, ENERGY_OUT) && this.facing == side) {
            return false;
        }
        return this.getTarget(true) != null;
    }

    protected boolean isWrongFluid(Fluid fluid) {
        if (fluid == null) {
            return true;
        }
        Fluid lockedFluid = this.getLockedFluid();
        if (lockedFluid != null) {
            return !fluid.equals(lockedFluid);
        }
        return false;
    }

    protected Fluid getLockedFluid() {
        if (this.configurationTank.get() != null && this.configurationTank.get().getFluid() != null) {
            return this.configurationTank.get().getFluid();
        }
        return null;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return;
        }
        if (this.modeSelected(ITEM_IN, ITEM_OUT)) {
            builder.widget(controller.getItemLogic(this.modeSelected(ITEM_IN) ? InventoryType.Input : InventoryType.Output, this.lockedInventory).getGuiPart().setSize(76, 90).setPos(52, 7));
        }
        if (this.modeSelected(FLUID_IN, FLUID_OUT)) {
            builder.widget(controller.getFluidLogic(this.modeSelected(FLUID_IN) ? InventoryType.Input : InventoryType.Output, this.lockedInventory).getGuiPart().setSize(76, 90).setPos(52, 7));
        }
    }

    protected boolean canOpenControllerGui() {
        return true;
    }

    @Override
    protected int getGUIHeight() {
        return super.getGUIHeight() + 20;
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        if (this.modeSelected(ITEM_IN, ITEM_OUT)) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 74));
        } else if (this.modeSelected(FLUID_IN, FLUID_OUT)) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 82));
        } else {
            super.addGregTechLogo(builder);
        }
    }

    @Override
    public void addToolTips(List<String> list, ItemStack stack, boolean f3_h) {
        list.add("A MultiTileEntity Casing");
    }

    @Override
    public String func_145825_b() {
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return "";
        }
        if (this.modeSelected(ITEM_IN, ITEM_OUT)) {
            InventoryType type = this.modeSelected(ITEM_IN) ? InventoryType.Input : InventoryType.Output;
            ItemInventoryLogic itemLogic = controller.getItemLogic(type, this.lockedInventory);
            return itemLogic.getDisplayName();
        }
        if (this.modeSelected(FLUID_IN, FLUID_OUT)) {
            InventoryType type = this.modeSelected(FLUID_IN) ? InventoryType.Input : InventoryType.Output;
            FluidInventoryLogic fluidLogic = controller.getFluidLogic(type, this.lockedInventory);
            return fluidLogic.getDisplayName();
        }
        return "";
    }

    @Override
    @Nonnull
    public ForgeDirection getPowerOutputSide() {
        if (!this.modeSelected(ENERGY_OUT)) {
            return ForgeDirection.UNKNOWN;
        }
        return this.facing;
    }

    @Nonnull
    protected GUIProvider<?> createGUIProvider() {
        return new PartGUIProvider<MultiBlockPart>(this);
    }

    @Override
    @Nonnull
    public GUIProvider<?> getGUI(@Nonnull UIBuildContext uiContext) {
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return this.guiProvider;
        }
        if (!this.modeSelected(0, ENERGY_IN, ENERGY_OUT)) {
            return this.guiProvider;
        }
        if (!this.canOpenControllerGui()) {
            return this.guiProvider;
        }
        if (uiContext.getPlayer().func_70093_af()) {
            return this.guiProvider;
        }
        GUIProvider controllerGUI = controller.getGUI(uiContext);
        return controllerGUI;
    }

    @Override
    public ItemStack getAsItem() {
        return MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID()).getItem(this.getMultiTileEntityID());
    }

    @Override
    public String getMachineName() {
        return StatCollector.func_74838_a((String)this.getAsItem().func_77977_a());
    }
}

