/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.util.GT_Log;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class GT_Util {
    public static final ThreadLocal<TileEntity> LAST_BROKEN_TILEENTITY = new ThreadLocal();

    public static Tuple tuple(String key, Object value) {
        return new Tuple((Object)key, value);
    }

    public static NBTTagCompound fuseNBT(NBTTagCompound aNBT1, NBTTagCompound aNBT2) {
        if (aNBT1 == null) {
            return aNBT2 == null ? new NBTTagCompound() : (NBTTagCompound)aNBT2.func_74737_b();
        }
        NBTTagCompound rNBT = (NBTTagCompound)aNBT1.func_74737_b();
        if (aNBT2 == null) {
            return rNBT;
        }
        for (Object tKey : aNBT2.func_150296_c()) {
            if (rNBT.func_74764_b(tKey.toString())) continue;
            rNBT.func_74782_a(tKey.toString(), aNBT2.func_74781_a(tKey.toString()));
        }
        return rNBT;
    }

    public static NBTTagCompound makeNBT(Tuple ... aTags) {
        NBTTagCompound rNBT = new NBTTagCompound();
        for (Tuple t : aTags) {
            if (t.func_76340_b() == null) continue;
            if (t.func_76340_b() instanceof Boolean) {
                rNBT.func_74757_a(t.func_76341_a().toString(), ((Boolean)t.func_76340_b()).booleanValue());
                continue;
            }
            if (t.func_76340_b() instanceof Byte) {
                rNBT.func_74774_a(t.func_76341_a().toString(), ((Byte)t.func_76340_b()).byteValue());
                continue;
            }
            if (t.func_76340_b() instanceof Short) {
                rNBT.func_74777_a(t.func_76341_a().toString(), ((Short)t.func_76340_b()).shortValue());
                continue;
            }
            if (t.func_76340_b() instanceof Integer) {
                rNBT.func_74768_a(t.func_76341_a().toString(), ((Integer)t.func_76340_b()).intValue());
                continue;
            }
            if (t.func_76340_b() instanceof Long) {
                rNBT.func_74772_a(t.func_76341_a().toString(), ((Long)t.func_76340_b()).longValue());
                continue;
            }
            if (t.func_76340_b() instanceof Float) {
                rNBT.func_74776_a(t.func_76341_a().toString(), ((Float)t.func_76340_b()).floatValue());
                continue;
            }
            if (t.func_76340_b() instanceof Double) {
                rNBT.func_74780_a(t.func_76341_a().toString(), ((Double)t.func_76340_b()).doubleValue());
                continue;
            }
            if (t.func_76340_b() instanceof String) {
                rNBT.func_74778_a(t.func_76341_a().toString(), (String)t.func_76340_b());
                continue;
            }
            if (t.func_76340_b() instanceof NBTBase) {
                rNBT.func_74782_a(t.func_76341_a().toString(), (NBTBase)t.func_76340_b());
                continue;
            }
            rNBT.func_74778_a(t.func_76341_a().toString(), t.func_76340_b().toString());
        }
        return rNBT;
    }

    public static TileEntity getTileEntity(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        if (aLoadUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ)) {
            TileEntity rTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (rTileEntity instanceof IMultiTileEntity && ((IMultiTileEntity)rTileEntity).isDead()) {
                return null;
            }
            if (rTileEntity != null) {
                return rTileEntity;
            }
            rTileEntity = LAST_BROKEN_TILEENTITY.get();
            if (rTileEntity != null && rTileEntity.field_145851_c == aX && rTileEntity.field_145848_d == aY && rTileEntity.field_145849_e == aZ) {
                return rTileEntity;
            }
        }
        return null;
    }

    public static TileEntity setTileEntity(World aWorld, int aX, int aY, int aZ, TileEntity aTileEntity, boolean aCauseTileEntityUpdates) {
        if (aCauseTileEntityUpdates) {
            aWorld.func_147455_a(aX, aY, aZ, aTileEntity);
        } else {
            Chunk tChunk = aWorld.func_72964_e(aX >> 4, aZ >> 4);
            if (tChunk != null) {
                aWorld.addTileEntity(aTileEntity);
                tChunk.func_150812_a(aX & 0xF, aY, aZ & 0xF, aTileEntity);
                tChunk.func_76630_e();
            }
        }
        return aTileEntity;
    }

    public static boolean setTileEntity(World aWorld, int aX, int aY, int aZ, Block aBlock, short aMeta, long aFlags, boolean aRemoveGrassBelow) {
        Block tBlock;
        if (aRemoveGrassBelow && ((tBlock = aWorld.func_147439_a(aX, aY - 1, aZ)) == Blocks.field_150349_c || tBlock == Blocks.field_150391_bh)) {
            aWorld.func_147465_d(aX, aY - 1, aZ, Blocks.field_150346_d, 0, (int)((byte)aFlags));
        }
        return aWorld.func_147465_d(aX, aY, aZ, aBlock, (int)aMeta, (int)((byte)aFlags));
    }

    public static TileEntity getTileEntity(World aWorld, ChunkCoordinates aCoords, boolean aLoadUnloadedChunks) {
        return GT_Util.getTileEntity(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, aLoadUnloadedChunks);
    }

    public static boolean markChunkDirty(World aWorld, int aX, int aZ) {
        if (aWorld == null || aWorld.field_72995_K) {
            return false;
        }
        Chunk aChunk = aWorld.func_72938_d(aX, aZ);
        if (aChunk == null) {
            aWorld.func_72805_g(aX, 0, aZ);
            aChunk = aWorld.func_72938_d(aX, aZ);
            if (aChunk == null) {
                GT_Log.err.println("Some important Chunk does not exist for some reason at Coordinates X: " + aX + " and Z: " + aZ);
                return false;
            }
        }
        aChunk.func_76630_e();
        return true;
    }

    public static boolean markChunkDirty(Object aTileEntity) {
        return aTileEntity instanceof TileEntity && GT_Util.markChunkDirty(((TileEntity)aTileEntity).func_145831_w(), ((TileEntity)aTileEntity).field_145851_c, ((TileEntity)aTileEntity).field_145849_e);
    }

    public static int mixRGBInt(int aRGB1, int aRGB2) {
        return GT_Util.getRGBInt(new short[]{(short)(GT_Util.getR(aRGB1) + GT_Util.getR(aRGB2) >> 1), (short)(GT_Util.getG(aRGB1) + GT_Util.getG(aRGB2) >> 1), (short)(GT_Util.getB(aRGB1) + GT_Util.getB(aRGB2) >> 1)});
    }

    public static int getRGBInt(short[] aColors) {
        return aColors == null ? 0xFFFFFF : aColors[0] << 16 | aColors[1] << 8 | aColors[2];
    }

    public static int getRGBaInt(short[] aColors) {
        return aColors == null ? 0xFFFFFF : aColors[0] << 16 | aColors[1] << 8 | aColors[2] | aColors[3] << 24;
    }

    public static String toHexString(short[] aColors) {
        return aColors == null ? "FFFFFF" : Integer.toHexString(aColors[0] << 16 | aColors[1] << 8 | aColors[2]);
    }

    public static int getRGBInt(short aR, short aG, short aB) {
        return aR << 16 | aG << 8 | aB;
    }

    public static int getRGBaInt(short aR, short aG, short aB, short aA) {
        return aR << 16 | aG << 8 | aB | aA << 24;
    }

    public static short[] getRGBaArray(int aColors) {
        return new short[]{(short)(aColors >>> 16 & 0xFF), (short)(aColors >>> 8 & 0xFF), (short)(aColors & 0xFF), (short)(aColors >>> 24 & 0xFF)};
    }

    public static short getR(int aColors) {
        return (short)(aColors >>> 16 & 0xFF);
    }

    public static short getG(int aColors) {
        return (short)(aColors >>> 8 & 0xFF);
    }

    public static short getB(int aColors) {
        return (short)(aColors & 0xFF);
    }

    public static short getA(int aColors) {
        return (short)(aColors >>> 24 & 0xFF);
    }
}

