/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.spaceprojects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.enums.SolarSystem;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceBody;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.tuple.Pair;

public class SpaceProjectWorldSavedData
extends WorldSavedData {
    public static SpaceProjectWorldSavedData INSTANCE;
    private static final Gson GSON_SPACE_PROJECT;
    private static final Gson GSON_TEAMS;
    private static final String DATA_NAME = "GT_SpaceProjectData";
    private static final String SPACE_TEAM_PROJECTS_JSON = "spaceTeamProject.json";
    private static final String SPACE_TEAMS_JSON = "spaceTeams.json";
    private static File spaceTeamsFile;
    private static File teamProjectsFile;

    public SpaceProjectWorldSavedData() {
        super(DATA_NAME);
    }

    public SpaceProjectWorldSavedData(String aData) {
        super(aData);
    }

    public void func_76184_a(NBTTagCompound aNBT) {
        JsonReader reader;
        try {
            reader = new JsonReader((Reader)new FileReader(teamProjectsFile));
            try {
                SpaceProjectManager.spaceTeamProjects = (Map)GSON_SPACE_PROJECT.fromJson(reader, SpaceProjectManager.spaceTeamProjects.getClass());
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            System.out.print("FAILED TO LOAD: spaceTeamProject.json");
            e.printStackTrace();
        }
        try {
            reader = new JsonReader((Reader)new FileReader(spaceTeamsFile));
            try {
                HashMap jsonMap = (HashMap)GSON_TEAMS.fromJson(reader, SpaceProjectManager.spaceTeams.getClass());
                for (UUID member : jsonMap.keySet()) {
                    SpaceProjectManager.spaceTeams.put(member, (UUID)jsonMap.get(member));
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            System.out.print("FAILED TO LOAD: spaceTeams.json");
            e.printStackTrace();
        }
        if (SpaceProjectManager.spaceTeamProjects == null) {
            SpaceProjectManager.spaceTeamProjects = new HashMap<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>>();
        }
        if (SpaceProjectManager.spaceTeams == null) {
            SpaceProjectManager.spaceTeams = new HashMap<UUID, UUID>();
        }
    }

    public void func_76187_b(NBTTagCompound aNBT) {
        JsonWriter writer;
        if (SpaceProjectManager.spaceTeamProjects != null) {
            try {
                writer = new JsonWriter((Writer)new FileWriter(teamProjectsFile));
                try {
                    GSON_SPACE_PROJECT.toJson(SpaceProjectManager.spaceTeamProjects, SpaceProjectManager.spaceTeamProjects.getClass(), writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (Exception ex) {
                System.out.print("FAILED TO SAVE: spaceTeamProject.json");
                ex.printStackTrace();
            }
        }
        if (SpaceProjectManager.spaceTeams != null) {
            try {
                writer = new JsonWriter((Writer)new FileWriter(spaceTeamsFile));
                try {
                    GSON_TEAMS.toJson(SpaceProjectManager.spaceTeams, SpaceProjectManager.spaceTeams.getClass(), writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (Exception ex) {
                System.out.print("FAILED TO SAVE: spaceTeams.json");
                ex.printStackTrace();
            }
        }
    }

    private static void loadInstance(World aWorld) {
        if (SpaceProjectManager.spaceTeamProjects != null) {
            SpaceProjectManager.spaceTeamProjects.clear();
        } else {
            SpaceProjectManager.spaceTeamProjects = new HashMap<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>>();
        }
        if (SpaceProjectManager.spaceTeams != null) {
            SpaceProjectManager.spaceTeams.clear();
        } else {
            SpaceProjectManager.spaceTeams = new HashMap<UUID, UUID>();
        }
        spaceTeamsFile = new File(aWorld.func_72860_G().func_75765_b(), SPACE_TEAMS_JSON);
        teamProjectsFile = new File(aWorld.func_72860_G().func_75765_b(), SPACE_TEAM_PROJECTS_JSON);
        MapStorage tStorage = aWorld.field_72988_C;
        INSTANCE = (SpaceProjectWorldSavedData)tStorage.func_75742_a(SpaceProjectWorldSavedData.class, DATA_NAME);
        if (INSTANCE == null) {
            INSTANCE = new SpaceProjectWorldSavedData();
            tStorage.func_75745_a(DATA_NAME, (WorldSavedData)INSTANCE);
        }
        INSTANCE.func_76185_a();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load aEvent) {
        if (!aEvent.world.field_72995_K && aEvent.world.field_73011_w.field_76574_g == 0) {
            SpaceProjectWorldSavedData.loadInstance(aEvent.world);
        }
    }

    static {
        GSON_SPACE_PROJECT = new GsonBuilder().serializeNulls().enableComplexMapKeySerialization().registerTypeAdapter(SpaceProjectManager.spaceTeamProjects.getClass(), (Object)new SpaceTeamProjectsMapAdapter()).registerTypeAdapter(Map.class, (Object)new SpaceTeamProjectsMapAdapter()).registerTypeAdapter(Pair.of((Object)SolarSystem.Ariel, (Object)"").getClass(), (Object)new PairAdapter()).registerTypeAdapter(Pair.class, (Object)new PairAdapter()).registerTypeAdapter(ISpaceProject.class, (Object)new SpaceProjectAdapter()).registerTypeAdapter(ISpaceProject.ISP_Upgrade.class, (Object)new SP_UpgradeAdapter()).registerTypeHierarchyAdapter(ISpaceProject.class, (Object)new SpaceProjectAdapter()).registerTypeHierarchyAdapter(ISpaceProject.ISP_Upgrade.class, (Object)new SP_UpgradeAdapter()).create();
        GSON_TEAMS = new GsonBuilder().serializeNulls().create();
    }

    private static class SpaceTeamProjectsMapAdapter
    implements JsonSerializer<Map<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>>>,
    JsonDeserializer<Map<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>>> {
        private SpaceTeamProjectsMapAdapter() {
        }

        public JsonElement serialize(Map<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray map = new JsonArray();
            for (Map.Entry<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>> firstEntry : src.entrySet()) {
                JsonObject teamMap = new JsonObject();
                teamMap.add("mapUUID", context.serialize((Object)firstEntry.getKey()));
                JsonArray teamProjectMap = new JsonArray();
                for (Map.Entry<Pair<ISpaceBody, String>, ISpaceProject> secondEntry : firstEntry.getValue().entrySet()) {
                    JsonObject projectMap = new JsonObject();
                    projectMap.add("mapPair", context.serialize(secondEntry.getKey()));
                    projectMap.add("mapProject", context.serialize((Object)secondEntry.getValue()));
                    teamProjectMap.add((JsonElement)projectMap);
                }
                teamMap.add("mapMap", (JsonElement)teamProjectMap);
                map.add((JsonElement)teamMap);
            }
            return map;
        }

        public Map<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray mapArray = json.getAsJsonArray();
            HashMap<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>> map = new HashMap<UUID, Map<Pair<ISpaceBody, String>, ISpaceProject>>();
            for (JsonElement teamMapElement : mapArray) {
                JsonObject teamMap = teamMapElement.getAsJsonObject();
                UUID uuid = (UUID)context.deserialize(teamMap.get("mapUUID"), UUID.class);
                HashMap<Pair, ISpaceProject> projectMap = new HashMap<Pair, ISpaceProject>();
                for (JsonElement teamProjectMapElement : teamMap.get("mapMap").getAsJsonArray()) {
                    JsonObject teamProjectMap = teamProjectMapElement.getAsJsonObject();
                    Pair pair = (Pair)context.deserialize(teamProjectMap.get("mapPair"), Pair.class);
                    ISpaceProject project = (ISpaceProject)context.deserialize(teamProjectMap.get("mapProject"), ISpaceProject.class);
                    projectMap.put(pair, project);
                }
                map.put(uuid, projectMap);
            }
            return map;
        }
    }

    private static class PairAdapter
    implements JsonSerializer<Pair<ISpaceBody, String>>,
    JsonDeserializer<Pair<ISpaceBody, String>> {
        private PairAdapter() {
        }

        public JsonElement serialize(Pair<ISpaceBody, String> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject pair = new JsonObject();
            pair.addProperty("pairLeft", ((ISpaceBody)src.getLeft()).getName());
            pair.addProperty("pairRight", (String)src.getRight());
            return pair;
        }

        public Pair<ISpaceBody, String> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Pair pair = null;
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                pair = Pair.of((Object)SpaceProjectManager.getLocation(obj.get("pairLeft").getAsString()), (Object)obj.get("pairRight").getAsString());
            }
            return pair;
        }
    }

    private static class SpaceProjectAdapter
    implements JsonSerializer<ISpaceProject>,
    JsonDeserializer<ISpaceProject> {
        private SpaceProjectAdapter() {
        }

        public JsonElement serialize(ISpaceProject src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("projectName", src.getProjectName());
            obj.addProperty("projectCurrentStage", (Number)src.getCurrentStage());
            obj.addProperty("projectLocation", src.getProjectLocation().getName());
            obj.add("projectCurrentUpgrade", context.serialize((Object)src.getUpgradeBeingBuilt()));
            obj.add("projectUpgradesBuilt", context.serialize(src.getAllBuiltUpgrades()));
            return obj;
        }

        public ISpaceProject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject obj = json.getAsJsonObject();
            String projectName = obj.get("projectName").getAsString();
            ISpaceProject project = SpaceProjectManager.getProject(projectName);
            int projectCurrentStage = obj.get("projectCurrentStage").getAsInt();
            ISpaceProject.ISP_Upgrade[] projectUpgradesBuilt = new ISpaceProject.ISP_Upgrade[]{};
            projectUpgradesBuilt = (ISpaceProject.ISP_Upgrade[])context.deserialize(obj.get("projectUpgradesBuilt"), projectUpgradesBuilt.getClass());
            ISpaceProject.ISP_Upgrade projectCurrentUpgrade = (ISpaceProject.ISP_Upgrade)context.deserialize(obj.get("projectCurrentUpgrade"), ISpaceProject.ISP_Upgrade.class);
            ISpaceBody projectLocation = SpaceProjectManager.getLocation(obj.get("projectLocation").getAsString());
            project.setBuiltUpgrade(projectUpgradesBuilt);
            project.setProjectLocation(projectLocation);
            project.setProjectCurrentStage(projectCurrentStage);
            project.setCurrentUpgradeBeingBuilt(projectCurrentUpgrade);
            return project;
        }
    }

    private static class SP_UpgradeAdapter
    implements JsonSerializer<ISpaceProject.ISP_Upgrade>,
    JsonDeserializer<ISpaceProject.ISP_Upgrade> {
        private SP_UpgradeAdapter() {
        }

        public JsonElement serialize(ISpaceProject.ISP_Upgrade src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("upgradeName", src.getUpgradeName());
            obj.addProperty("upgradeProjectParent", src.getParentProject().getProjectName());
            obj.addProperty("upgradeCurrentStage", (Number)src.getCurrentStage());
            return obj;
        }

        public ISpaceProject.ISP_Upgrade deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject obj = json.getAsJsonObject();
            String projectName = obj.get("upgradeProjectParent").getAsString();
            ISpaceProject project = SpaceProjectManager.getProject(projectName);
            ISpaceProject.ISP_Upgrade upgrade = project.getUpgrade(obj.get("upgradeName").getAsString());
            if (upgrade == null) {
                return null;
            }
            upgrade = upgrade.copy();
            upgrade.setUpgradeCurrentStage(obj.get("upgradeCurrentStage").getAsInt());
            return upgrade;
        }
    }
}

