/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.interfaces.ITexture;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.common.covers.GT_Cover_Lens;
import net.minecraft.item.ItemStack;

public class ProcessingLens
implements IOreRecipeRegistrator {
    public ProcessingLens() {
        OrePrefixes.lens.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aMaterial.mName) {
            case "Diamond": 
            case "Glass": {
                GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L)).duration(1200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.latheRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.lens, aMaterial, 3L), GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).duration(2400).eut(16).addTo(RecipeMaps.latheRecipes);
                break;
            }
            case "ChromaticGlass": {
                GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 16L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L)).duration(12000).eut(TierEU.RECIPE_UHV).addTo(RecipeMaps.compressorRecipes);
                break;
            }
            default: {
                GT_RecipeBuilder recipeBuilder;
                if (GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                    recipeBuilder = GT_Values.RA.stdBuilder();
                    recipeBuilder.itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L));
                    if (GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L) == null) {
                        recipeBuilder.itemOutputs(GT_OreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L));
                    } else {
                        recipeBuilder.itemOutputs(GT_OreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L));
                    }
                    recipeBuilder.duration(1200).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.latheRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L) != null) {
                    recipeBuilder = GT_Values.RA.stdBuilder();
                    recipeBuilder.itemInputs(GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L));
                    if (GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L) == null) {
                        recipeBuilder.itemOutputs(GT_OreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L));
                    } else {
                        recipeBuilder.itemOutputs(GT_OreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 2L));
                    }
                    recipeBuilder.duration(2400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.latheRecipes);
                }
                ITexture lensCoverTexture = TextureFactory.of(Textures.BlockIcons.OVERLAY_LENS, aMaterial.mRGBa, false);
                GregTech_API.registerCover(aStack, TextureFactory.of(Textures.BlockIcons.MACHINE_CASINGS[2][0], lensCoverTexture), (GT_CoverBehavior)new GT_Cover_Lens(aMaterial.mColor.mIndex, lensCoverTexture));
            }
        }
    }
}

