/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import makamys.coretweaks.util.WrappedList;

public class WrappedAddListenableList<T>
extends WrappedList<T> {
    private final List<AdditionEventListener<T>> listeners = new ArrayList<AdditionEventListener<T>>();

    public WrappedAddListenableList(List<T> original) {
        super(original);
    }

    public void addListener(AdditionEventListener<T> l) {
        this.listeners.add(l);
    }

    public void removeListener(AdditionEventListener<T> l) {
        this.listeners.remove(l);
    }

    @Override
    public void add(int index, T element) {
        AdditionEvent event = new AdditionEvent();
        event.list = this.o;
        event.element = element;
        event.index = index;
        for (AdditionEventListener l : this.listeners) {
            l.onAdd(event);
        }
        if (!event.isCanceled) {
            super.add(event.index, event.element);
        }
    }

    @Override
    public boolean add(T element) {
        AdditionEvent event = new AdditionEvent();
        event.list = this.o;
        event.element = element;
        event.index = -1;
        for (AdditionEventListener l : this.listeners) {
            l.onAdd(event);
        }
        if (!event.isCanceled) {
            return super.add(event.element);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    public static interface AdditionEventListener<T> {
        public void onAdd(AdditionEvent<T> var1);
    }

    public static class AdditionEvent<T> {
        public T element;
        public List<T> list;
        public int index;
        boolean isCanceled;
    }
}

