/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import tconstruct.TConstruct;
import tconstruct.library.tools.ToolCore;

public class FlexibleToolRenderer
implements IItemRenderer {
    public float depth = 0.03125f;
    private static final int toolIcons = 10;

    public void setDepth(float d) {
        this.depth = d;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (!item.func_77942_o()) {
            return false;
        }
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
            default: {
                TConstruct.logger.warn("[TCon] Unhandled render case!");
            }
            case FIRST_PERSON_MAP: 
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return this.handleRenderType(item, type) & helper.ordinal() < IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK.ordinal();
    }

    protected void specialAnimation(IItemRenderer.ItemRenderType type, ItemStack item) {
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        float h;
        int k;
        int e;
        float d;
        float m;
        int i;
        float iconPos;
        int i2;
        if (item == null || item.func_77973_b() == null || !(item.func_77973_b() instanceof ToolCore)) {
            return;
        }
        Entity ent = null;
        if (data.length > 1) {
            ent = (Entity)data[1];
        }
        IIcon[] parts = new IIcon[10];
        int iconParts = this.getIcons(item, type, ent, parts);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderInventory(iconParts, parts, item);
            return;
        }
        Tessellator tess = Tessellator.field_78398_a;
        float[] xMax = new float[iconParts];
        float[] yMin = new float[iconParts];
        float[] xMin = new float[iconParts];
        float[] yMax = new float[iconParts];
        float[] width = new float[iconParts];
        float[] height = new float[iconParts];
        float[] xDiff = new float[iconParts];
        float[] yDiff = new float[iconParts];
        float[] xSub = new float[iconParts];
        float[] ySub = new float[iconParts];
        for (int i3 = 0; i3 < iconParts; ++i3) {
            IIcon icon = parts[i3];
            xMin[i3] = icon.func_94209_e();
            xMax[i3] = icon.func_94212_f();
            yMin[i3] = icon.func_94206_g();
            yMax[i3] = icon.func_94210_h();
            width[i3] = icon.func_94211_a();
            height[i3] = icon.func_94216_b();
            xDiff[i3] = xMin[i3] - xMax[i3];
            yDiff[i3] = yMin[i3] - yMax[i3];
            xSub[i3] = 0.5f * (xMax[i3] - xMin[i3]) / width[i3];
            ySub[i3] = 0.5f * (yMax[i3] - yMin[i3]) / height[i3];
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        if (type != IItemRenderer.ItemRenderType.ENTITY) {
            this.specialAnimation(type, item);
        } else {
            GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)0.0f);
        }
        int[] color = new int[iconParts];
        for (i2 = 0; i2 < iconParts; ++i2) {
            color[i2] = item.func_77973_b().func_82790_a(item, i2);
        }
        tess.func_78382_b();
        tess.func_78375_b(0.0f, 0.0f, 1.0f);
        for (i2 = 0; i2 < iconParts; ++i2) {
            tess.func_78378_d(color[i2]);
            tess.func_78374_a(0.0, 0.0, (double)this.depth, (double)xMax[i2], (double)yMax[i2]);
            tess.func_78374_a(1.0, 0.0, (double)this.depth, (double)xMin[i2], (double)yMax[i2]);
            tess.func_78374_a(1.0, 1.0, (double)this.depth, (double)xMin[i2], (double)yMin[i2]);
            tess.func_78374_a(0.0, 1.0, (double)this.depth, (double)xMax[i2], (double)yMin[i2]);
        }
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78375_b(0.0f, 0.0f, -1.0f);
        for (i2 = 0; i2 < iconParts; ++i2) {
            tess.func_78378_d(color[i2]);
            tess.func_78374_a(0.0, 1.0, (double)(-this.depth), (double)xMax[i2], (double)yMin[i2]);
            tess.func_78374_a(1.0, 1.0, (double)(-this.depth), (double)xMin[i2], (double)yMin[i2]);
            tess.func_78374_a(1.0, 0.0, (double)(-this.depth), (double)xMin[i2], (double)yMax[i2]);
            tess.func_78374_a(0.0, 0.0, (double)(-this.depth), (double)xMax[i2], (double)yMax[i2]);
        }
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78375_b(-1.0f, 0.0f, 0.0f);
        for (int i4 = 0; i4 < iconParts; ++i4) {
            tess.func_78378_d(color[i4]);
            float w = width[i4];
            float m2 = xMax[i4];
            float d2 = xDiff[i4];
            float s = xSub[i4];
            int e2 = (int)w;
            for (int k2 = 0; k2 < e2; ++k2) {
                float pos = (float)k2 / w;
                iconPos = m2 + d2 * pos - s;
                tess.func_78374_a((double)pos, 0.0, (double)(-this.depth), (double)iconPos, (double)yMax[i4]);
                tess.func_78374_a((double)pos, 0.0, (double)this.depth, (double)iconPos, (double)yMax[i4]);
                tess.func_78374_a((double)pos, 1.0, (double)this.depth, (double)iconPos, (double)yMin[i4]);
                tess.func_78374_a((double)pos, 1.0, (double)(-this.depth), (double)iconPos, (double)yMin[i4]);
            }
        }
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78375_b(1.0f, 0.0f, 0.0f);
        for (i = 0; i < iconParts; ++i) {
            tess.func_78378_d(color[i]);
            float w = width[i];
            m = xMax[i];
            d = xDiff[i];
            float s = xSub[i];
            float d2 = 1.0f / w;
            e = (int)w;
            for (k = 0; k < e; ++k) {
                float pos = (float)k / w;
                iconPos = m + d * pos - s;
                float posEnd = pos + d2;
                tess.func_78374_a((double)posEnd, 1.0, (double)(-this.depth), (double)iconPos, (double)yMin[i]);
                tess.func_78374_a((double)posEnd, 1.0, (double)this.depth, (double)iconPos, (double)yMin[i]);
                tess.func_78374_a((double)posEnd, 0.0, (double)this.depth, (double)iconPos, (double)yMax[i]);
                tess.func_78374_a((double)posEnd, 0.0, (double)(-this.depth), (double)iconPos, (double)yMax[i]);
            }
        }
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78375_b(0.0f, 1.0f, 0.0f);
        for (i = 0; i < iconParts; ++i) {
            tess.func_78378_d(color[i]);
            h = height[i];
            m = yMax[i];
            d = yDiff[i];
            float s = ySub[i];
            float d2 = 1.0f / h;
            e = (int)h;
            for (k = 0; k < e; ++k) {
                float pos = (float)k / h;
                iconPos = m + d * pos - s;
                float posEnd = pos + d2;
                tess.func_78374_a(0.0, (double)posEnd, (double)this.depth, (double)xMax[i], (double)iconPos);
                tess.func_78374_a(1.0, (double)posEnd, (double)this.depth, (double)xMin[i], (double)iconPos);
                tess.func_78374_a(1.0, (double)posEnd, (double)(-this.depth), (double)xMin[i], (double)iconPos);
                tess.func_78374_a(0.0, (double)posEnd, (double)(-this.depth), (double)xMax[i], (double)iconPos);
            }
        }
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78375_b(0.0f, -1.0f, 0.0f);
        for (i = 0; i < iconParts; ++i) {
            tess.func_78378_d(color[i]);
            h = height[i];
            m = yMax[i];
            d = yDiff[i];
            float s = ySub[i];
            int e3 = (int)h;
            for (int k3 = 0; k3 < e3; ++k3) {
                float pos = (float)k3 / h;
                iconPos = m + d * pos - s;
                tess.func_78374_a(1.0, (double)pos, (double)this.depth, (double)xMin[i], (double)iconPos);
                tess.func_78374_a(0.0, (double)pos, (double)this.depth, (double)xMax[i], (double)iconPos);
                tess.func_78374_a(0.0, (double)pos, (double)(-this.depth), (double)xMax[i], (double)iconPos);
                tess.func_78374_a(1.0, (double)pos, (double)(-this.depth), (double)xMin[i], (double)iconPos);
            }
        }
        tess.func_78381_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void renderInventory(int count, IIcon[] icons, ItemStack item) {
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.5f);
        tess.func_78382_b();
        for (int i = 0; i < count; ++i) {
            tess.func_78378_d(item.func_77973_b().func_82790_a(item, i));
            IIcon icon = icons[i];
            float xmin = icon.func_94209_e();
            float xmax = icon.func_94212_f();
            float ymin = icon.func_94206_g();
            float ymax = icon.func_94210_h();
            tess.func_78374_a(0.0, 16.0, 0.0, (double)xmin, (double)ymax);
            tess.func_78374_a(16.0, 16.0, 0.0, (double)xmax, (double)ymax);
            tess.func_78374_a(16.0, 0.0, 0.0, (double)xmax, (double)ymin);
            tess.func_78374_a(0.0, 0.0, 0.0, (double)xmin, (double)ymin);
        }
        tess.func_78381_a();
        GL11.glDisable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public int getIcons(ItemStack item, IItemRenderer.ItemRenderType type, Entity ent, IIcon[] parts) {
        EntityPlayer player;
        ItemStack itemInUse;
        int iconParts = 10;
        boolean isInventory = type == IItemRenderer.ItemRenderType.INVENTORY;
        ToolCore tool = (ToolCore)item.func_77973_b();
        IIcon[] tempParts = new IIcon[iconParts];
        if (!isInventory && ent instanceof EntityPlayer && (itemInUse = (player = (EntityPlayer)ent).func_71011_bu()) != null) {
            int useCount = player.func_71052_bv();
            int i = iconParts;
            while (i-- > 0) {
                tempParts[i] = tool.getIcon(item, i, player, itemInUse, useCount);
            }
        } else {
            int i = iconParts;
            while (i-- > 0) {
                tempParts[i] = tool.getIcon(item, i);
            }
        }
        int count = 0;
        for (int i = 0; i < iconParts; ++i) {
            IIcon part = tempParts[i];
            if (part == null || part == ToolCore.blankSprite || part == ToolCore.emptyIcon) {
                ++count;
                continue;
            }
            parts[i - count] = part;
        }
        if ((iconParts -= count) <= 0) {
            iconParts = 1;
            parts[0] = ToolCore.blankSprite;
        }
        return iconParts;
    }
}

