/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GT_Recipe;
import gttweaker.GTTweaker;
import gttweaker.mods.gregtech.GTRecipeMap;
import java.util.Arrays;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.RecipeRemover")
@ModOnly(value={"gregtech"})
public class RecipeRemover {
    @ZenMethod
    public static void remove(String map, IIngredient[] inputs, IIngredient[] fluidInputs) {
        RecipeMap<?> recipeMap = GTRecipeMap.getRecipeMap(map);
        if (recipeMap == null) {
            MineTweakerAPI.logError((String)("Could not find recipe map named \"" + map + "\""));
            return;
        }
        GT_Recipe recipe = recipeMap.findRecipe(null, false, true, Long.MAX_VALUE, (FluidStack[])Arrays.stream(fluidInputs).map(GTTweaker::getFluidStackOrNull).filter(Objects::nonNull).toArray(FluidStack[]::new), (ItemStack[])Arrays.stream(inputs).map(GTTweaker::getItemStackOrNull).filter(Objects::nonNull).toArray(ItemStack[]::new));
        if (recipe == null) {
            MineTweakerAPI.logWarning((String)"Could not find recipe to remove!");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RecipeRemoveAction(recipe, recipeMap));
    }

    public static class RecipeRemoveAction
    implements IUndoableAction {
        GT_Recipe recipe;
        RecipeMap<?> map;

        public RecipeRemoveAction(GT_Recipe recipe, RecipeMap<?> map) {
            this.recipe = recipe;
            this.map = map;
        }

        public void apply() {
            this.map.getBackend().removeRecipe(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.map.add(this.recipe);
        }

        public String describe() {
            return "Remove recipe from GT Machine";
        }

        public String describeUndo() {
            return "Re-add recipe to GT Machine";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

