/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CraftingMaterialLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.screw)) {
            int tVoltageMultiplier = werkstoff.getStats().getMeltingPoint() >= 2800 ? 60 : 15;
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.hasItemType(OrePrefixes.gem) ? werkstoff.get(OrePrefixes.gem) : werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Bolt.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.bolt, 8)}).duration((int)Math.max(werkstoff.getStats().getMass() * 2L, 1L)).eut(8 * tVoltageMultiplier).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.stick)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.bolt, 4)}).duration((int)Math.max(werkstoff.getStats().getMass() * 2L, 1L)).eut(4).addTo((IRecipeMap)RecipeMaps.cutterRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.bolt)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny, 1)}).duration(2).eut(8).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.bolt)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.screw)}).duration((int)Math.max(werkstoff.getStats().getMass() / 8L, 1L)).eut(4).addTo((IRecipeMap)RecipeMaps.latheRecipes);
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.screw), (long)GT_Proxy.tBits, (Object[])new Object[]{"fX", "X ", Character.valueOf('X'), werkstoff.get(OrePrefixes.bolt)});
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.screw)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny, 1)}).duration(2).eut(8).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
            if (werkstoff.hasItemType(OrePrefixes.gem)) {
                return;
            }
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Ring.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.ring, 4)}).duration((int)Math.max(werkstoff.getStats().getMass() * 2L, 1L)).eut(6 * tVoltageMultiplier).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.ring), (long)GT_Proxy.tBits, (Object[])new Object[]{"h ", "fX", Character.valueOf('X'), werkstoff.get(OrePrefixes.stick)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gearGt), (long)GT_Proxy.tBits, (Object[])new Object[]{"SPS", "PwP", "SPS", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('S'), werkstoff.get(OrePrefixes.stick)});
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot, 4), ItemList.Shape_Extruder_Gear.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.gearGt)}).duration((int)Math.max(werkstoff.getStats().getMass() * 5L, 1L)).eut(8 * tVoltageMultiplier).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Wire.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.wireFine, 8)}).duration((int)Math.max((float)werkstoff.getStats().getMass() * 1.5f, 1.0f)).eut(8 * tVoltageMultiplier).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot), GT_Utility.getIntegratedCircuit((int)3)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.wireFine, 8)}).duration((int)Math.max(werkstoff.getStats().getMass(), 1L)).eut(8 * tVoltageMultiplier).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.stick), GT_Utility.getIntegratedCircuit((int)3)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.wireFine, 4)}).duration((int)Math.max((float)werkstoff.getStats().getMass() * 0.5f, 1.0f)).eut(8 * tVoltageMultiplier).addTo((IRecipeMap)RecipeMaps.wiremillRecipes);
            if (WerkstoffLoader.smallGearShape != null) {
                GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot), WerkstoffLoader.smallGearShape.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.gearGtSmall)}).duration((int)werkstoff.getStats().getMass()).eut(8 * tVoltageMultiplier).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
            }
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gearGtSmall), (long)GT_Proxy.tBits, (Object[])new Object[]{" S ", "hPx", " S ", Character.valueOf('S'), werkstoff.get(OrePrefixes.stick), Character.valueOf('P'), werkstoff.get(OrePrefixes.plate)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.rotor), (long)GT_Proxy.tBits, (Object[])new Object[]{"PhP", "SRf", "PdP", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('R'), werkstoff.get(OrePrefixes.ring), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw)});
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.rotor)}).fluidInputs(new FluidStack[]{Materials.Tin.getMolten(32L)}).duration(240).eut(24).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.rotor)}).fluidInputs(new FluidStack[]{Materials.Lead.getMolten(48L)}).duration(240).eut(24).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.rotor)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten(16L)}).duration(240).eut(24).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            if (WerkstoffLoader.rotorShape != null) {
                GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot, 5), WerkstoffLoader.rotorShape.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.rotor)}).duration(200).eut(60).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
            }
            if (werkstoff.hasItemType(OrePrefixes.cellMolten)) {
                // empty if block
            }
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.gearGt)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust, 4)}).duration(2).eut(8).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.gearGtSmall)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust, 1)}).duration(2).eut(8).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.rotor)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust, 4), werkstoff.get(OrePrefixes.dustSmall)}).duration(2).eut(8).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ring)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustSmall, 1)}).duration(2).eut(8).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
        }
    }
}

