/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.enhancedlootbags.server;

import eu.usrv.enhancedlootbags.EnhancedLootBags;
import eu.usrv.enhancedlootbags.core.serializer.LootGroups;
import eu.usrv.enhancedlootbags.core.serializer.LootGroupsFactory;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class LootBagCommand
implements ICommand {
    private List aliases = new ArrayList();

    public LootBagCommand() {
        this.aliases.add("lbag");
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public String func_71517_b() {
        return "lootbags";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "Check the readme for usage";
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender pCmdSender, String[] pArgs) {
        try {
            if (pArgs.length < 1) {
                this.SendHelpToPlayer(pCmdSender);
                return;
            }
            String tSubCommand = pArgs[0];
            if (tSubCommand.equalsIgnoreCase("reload")) {
                if (EnhancedLootBags.LootGroupHandler.reload()) {
                    PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)String.format("Reload successful", new Object[0]));
                } else {
                    PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)String.format("Reload successful", new Object[0]));
                }
                return;
            }
            LootGroupsFactory tLGF = new LootGroupsFactory();
            if (!this.InGame(pCmdSender)) {
                PlayerChatHelper.SendPlain((ICommandSender)pCmdSender, (String)"You have to execute this command ingame");
                return;
            }
            EntityPlayer tEp = (EntityPlayer)pCmdSender;
            ItemStack inHand = null;
            if (tEp != null && (inHand = tEp.func_71045_bC()) == null) {
                PlayerChatHelper.SendPlain((ICommandSender)pCmdSender, (String)"Pickup an item first");
                return;
            }
            if (tSubCommand.equalsIgnoreCase("addloot") || tSubCommand.equalsIgnoreCase("addinventory")) {
                int tGroupID = Integer.parseInt(pArgs[1]);
                int tAmount = 1;
                int tChance = 100;
                int tLimitedDropCount = 0;
                int tRandomAmount = 0;
                boolean tFlagsOK = true;
                if (tGroupID < 0 || tGroupID > Short.MAX_VALUE) {
                    tFlagsOK = false;
                }
                if (pArgs.length == 6) {
                    tAmount = Integer.parseInt(pArgs[2]);
                    tChance = Integer.parseInt(pArgs[3]);
                    tLimitedDropCount = Integer.parseInt(pArgs[4]);
                    tRandomAmount = Integer.parseInt(pArgs[5]);
                    if (tAmount < 1 || tAmount > 64) {
                        tFlagsOK = false;
                    }
                    if (tChance < 1 || tChance > 255) {
                        tFlagsOK = false;
                    }
                    if (tLimitedDropCount < 0 || tChance > 255) {
                        tFlagsOK = false;
                    }
                    if (tRandomAmount < 0 || tRandomAmount > 1) {
                        tFlagsOK = false;
                    }
                }
                if (tFlagsOK) {
                    LootGroups.LootGroup tGrp = EnhancedLootBags.LootGroupHandler.getGroupByID(tGroupID);
                    if (tGrp != null) {
                        ArrayList<ItemStack> tStacksToAdd = new ArrayList<ItemStack>();
                        if (tSubCommand.equalsIgnoreCase("addloot")) {
                            tStacksToAdd.add(inHand.func_77946_l());
                        } else if (tSubCommand.equalsIgnoreCase("addinventory")) {
                            for (ItemStack is : tEp.field_71071_by.field_70462_a) {
                                if (is == null) continue;
                                tStacksToAdd.add(is.func_77946_l());
                            }
                        }
                        for (ItemStack tis : tStacksToAdd) {
                            String tItemID = ItemDescriptor.fromStack((ItemStack)tis).toString();
                            if (tItemID.isEmpty()) continue;
                            String tItemNBT = "";
                            if (tis.field_77990_d != null) {
                                tItemNBT = tis.field_77990_d.toString();
                            }
                            LootGroups.LootGroup.Drop dr = tLGF.createDrop(tItemID, UUID.randomUUID().toString(), tItemNBT, tAmount, tRandomAmount == 1, tChance, tLimitedDropCount, "");
                            tGrp.getDrops().add(dr);
                            EnhancedLootBags.LootGroupHandler.SaveLootGroups();
                            PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)String.format("Item %s added to LootGroup ID %d ", tItemID, tGrp.getGroupID()));
                        }
                    } else {
                        PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)String.format("LootGroup ID %d is unknown", tGroupID));
                    }
                } else {
                    PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)String.format("Some flags are wrong. Make sure to read the readme", new Object[0]));
                }
            } else if (tSubCommand.equalsIgnoreCase("addgroup")) {
                int tGroupID = Integer.parseInt(pArgs[1]);
                String tGroupName = String.format("Unnamed group %d", tGroupID);
                EnumRarity tRarity = EnumRarity.common;
                int tMinItems = 1;
                int tMaxItems = 1;
                boolean tFlagsOK = true;
                if (tGroupID < 0 || tGroupID > Short.MAX_VALUE) {
                    tFlagsOK = false;
                }
                if (pArgs.length == 5) {
                    int tIntRarity = Integer.parseInt(pArgs[2]);
                    tMinItems = Integer.parseInt(pArgs[3]);
                    if (tMinItems > (tMaxItems = Integer.parseInt(pArgs[4]))) {
                        tFlagsOK = false;
                    }
                    if (tMinItems < 1 || tMaxItems < 1) {
                        tFlagsOK = false;
                    }
                    if (tIntRarity < 0 || tIntRarity >= EnumRarity.values().length) {
                        tFlagsOK = false;
                    } else {
                        tRarity = EnumRarity.values()[tIntRarity];
                    }
                }
                if (tFlagsOK) {
                    LootGroups.LootGroup tGrp = EnhancedLootBags.LootGroupHandler.getGroupByID(tGroupID);
                    if (tGrp == null) {
                        LootGroups.LootGroup tNewGroup = tLGF.createLootGroup(tGroupID, tGroupName, tRarity, tMinItems, tMaxItems, true);
                        EnhancedLootBags.LootGroupHandler.getLootGroups().getLootTable().add(tNewGroup);
                        EnhancedLootBags.LootGroupHandler.SaveLootGroups();
                        PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)String.format("New group added (ID: %d Name: %s)", tGroupID, tGroupName));
                    } else {
                        PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)String.format("LootGroup ID %d is already in use", tGroupID));
                    }
                } else {
                    PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)String.format("Some flags are wrong. Make sure to read the readme", new Object[0]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PlayerChatHelper.SendError((ICommandSender)pCmdSender, (String)"Unknown error occoured");
        }
    }

    private boolean InGame(ICommandSender pCmdSender) {
        return pCmdSender instanceof EntityPlayer;
    }

    private void SendHelpToPlayer(ICommandSender pCmdSender) {
        if (!this.InGame(pCmdSender)) {
            PlayerChatHelper.SendPlain((ICommandSender)pCmdSender, (String)"Command can only be executed ingame");
        } else {
            PlayerChatHelper.SendInfo((ICommandSender)pCmdSender, (String)"Check the readme for usage");
        }
    }

    public boolean func_71519_b(ICommandSender pCommandSender) {
        if (pCommandSender instanceof EntityPlayerMP) {
            EntityPlayerMP tEP = (EntityPlayerMP)pCommandSender;
            boolean tPlayerOpped = MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(tEP.func_146103_bH());
            boolean tIncreative = tEP.field_71075_bZ.field_75098_d;
            return tPlayerOpped && tIncreative;
        }
        return pCommandSender instanceof MinecraftServer;
    }

    public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        return null;
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }
}

