/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.inventory.AEFluidInventory;
import com.glodblock.github.inventory.IAEFluidInventory;
import com.glodblock.github.inventory.IAEFluidTank;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFluidBuffer
extends AENetworkTile
implements IAEFluidInventory,
IFluidHandler,
IPowerChannelState {
    private final AEFluidInventory invFluids = new AEFluidInventory(this, 1, Integer.MAX_VALUE);
    private final BaseActionSource source;
    private boolean isPowered;

    public TileFluidBuffer() {
        this.getProxy().setIdlePowerUsage(2.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.source = new MachineSource((IActionHost)this);
    }

    public boolean setFluid(FluidStack fs) {
        if (fs == null) {
            this.invFluids.setFluidInSlot(0, null);
            return false;
        }
        try {
            IAEFluidStack ias = (IAEFluidStack)this.getProxy().getStorage().getFluidInventory().getStorageList().findPrecise((IAEStack)AEFluidStack.create((Object)fs));
            this.invFluids.setFluidInSlot(0, ias);
            if (ias != null) {
                return true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return false;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean b) {
        IAEFluidStack ifs = this.getAEFluidStack();
        if (ifs != null && ifs.getFluid() == fluidStack.getFluid()) {
            try {
                IAEFluidStack notInserted = (IAEFluidStack)this.getProxy().getStorage().getFluidInventory().injectItems((IAEStack)AEFluidStack.create((Object)fluidStack), b ? Actionable.MODULATE : Actionable.SIMULATE, this.source);
                if (notInserted != null) {
                    fluidStack.amount = (int)((long)fluidStack.amount - notInserted.getStackSize());
                    return fluidStack.amount;
                }
                return fluidStack.amount;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean b) {
        FluidStack fs = this.getFluidStack();
        if (fs != null && fs.getFluid() == fluidStack.getFluid()) {
            return this.drainFluid(fluidStack, b ? Actionable.MODULATE : Actionable.SIMULATE);
        }
        return null;
    }

    public FluidStack drainFluid(FluidStack fs, Actionable actionable) {
        if (fs == null || fs.amount <= 0) {
            return null;
        }
        try {
            AEFluidStack ias = AEFluidStack.create((Object)fs);
            IAEFluidStack extracted = (IAEFluidStack)this.getProxy().getStorage().getFluidInventory().extractItems((IAEStack)ias, actionable, this.source);
            if (extracted == null) {
                return null;
            }
            return extracted.getFluidStack();
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    public FluidStack drain(ForgeDirection forgeDirection, int maxDrain, boolean b) {
        FluidStack fs = this.getFluidStack();
        if (maxDrain == 0 || fs == null) {
            return null;
        }
        FluidStack tmp = fs.copy();
        tmp.amount = maxDrain;
        return this.drainFluid(tmp, b ? Actionable.MODULATE : Actionable.SIMULATE);
    }

    public IAEFluidStack getAEStoreFluidStack() {
        try {
            return (IAEFluidStack)this.getProxy().getStorage().getFluidInventory().getStorageList().findPrecise((IAEStack)this.getAEFluidStack());
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    public FluidStack getFluidStack() {
        return this.getInternalFluid().getFluidStackInSlot(0);
    }

    public IAEFluidStack getAEFluidStack() {
        return this.getInternalFluid().getFluidInSlot(0);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        FluidStack fs = this.getFluidStack();
        return fs != null && fs.getFluid() == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getInternalFluid().canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] tmp;
        FluidTankInfo[] FluidTankInfos = this.getInternalFluid().getTankInfo(from);
        for (FluidTankInfo ft : tmp = (FluidTankInfo[])FluidTankInfos.clone()) {
            if (ft.fluid == null) continue;
            ft.fluid.amount = 0;
        }
        return tmp;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBTEvent(NBTTagCompound data) {
        this.invFluids.writeToNBT(data, "FluidInv");
        return data;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        this.invFluids.readFromNBT(data, "FluidInv");
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream(ByteBuf data) {
        data.writeBoolean(this.isActive());
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        this.saveChanges();
        this.markForUpdate();
    }

    @Override
    public AEFluidInventory getInternalFluid() {
        return this.invFluids;
    }

    public void updateFluidStore() {
        IAEFluidStack iaf = this.getAEStoreFluidStack();
        if (iaf != null) {
            this.invFluids.setFluidInSlot(0, iaf);
        }
    }
}

