/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import client.gui.KT_UITextures;
import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoTunnel;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyTunnel;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import common.Blocks;
import common.itemBlocks.IB_LapotronicEnergyUnit;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.IGT_HatchAdder;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import util.Util;

public class GTMTE_LapotronicSuperCapacitor
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GTMTE_LapotronicSuperCapacitor>
implements ISurvivalConstructable {
    private boolean canUseWireless = false;
    private boolean wireless_mode = false;
    private boolean not_processed_lsc = true;
    private int counter = 1;
    private final Queue<Long> energyInputValues = new LinkedList<Long>();
    private final Queue<Long> energyOutputValues = new LinkedList<Long>();
    private final long max_passive_drain_eu_per_tick_per_uhv_cap = 1000000L;
    private final long max_passive_drain_eu_per_tick_per_uev_cap = 100000000L;
    private final long max_passive_drain_eu_per_tick_per_uiv_cap = (long)Math.pow(10.0, 10.0);
    private final long max_passive_drain_eu_per_tick_per_umv_cap = (long)Math.pow(10.0, 12.0);
    private static final String STRUCTURE_PIECE_BASE = "base";
    private static final String STRUCTURE_PIECE_LAYER = "slice";
    private static final String STRUCTURE_PIECE_TOP = "top";
    private static final String STRUCTURE_PIECE_MID = "mid";
    private static final int GLASS_TIER_UNSET = -2;
    private static final Block LSC_PART = Blocks.lscLapotronicEnergyUnit;
    private static final Item LSC_PART_ITEM = Item.func_150898_a((Block)LSC_PART);
    private static final int CASING_META = 0;
    private static final int CASING_TEXTURE_ID = 5503;
    private static final int DURATION_AVERAGE_TICKS = 100;
    private static final IStructureDefinition<GTMTE_LapotronicSuperCapacitor> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("base", StructureUtility.transpose((String[][])new String[][]{{"bbbbb", "bbbbb", "bbbbb", "bbbbb", "bbbbb"}, {"bb~bb", "bbbbb", "bbbbb", "bbbbb", "bbbbb"}})).addShape("slice", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "gcccg", "gcccg", "gcccg", "ggggg"}})).addShape("top", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "ggggg", "ggggg", "ggggg", "ggggg"}})).addShape("mid", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "gCCCg", "gCCCg", "gCCCg", "ggggg"}})).addElement('b', (IStructureElement)GT_StructureUtility.buildHatchAdder(GTMTE_LapotronicSuperCapacitor.class).atLeast(new IHatchElement[]{LSCHatchElement.Energy, LSCHatchElement.Dynamo, GT_HatchElement.Maintenance}).hatchItemFilterAnd((t, h) -> ChannelDataAccessor.getChannelData((ItemStack)h, (String)"glass") < 6 ? GT_StructureUtility.filterByMTEClass((List)ImmutableList.of(GT_MetaTileEntity_Hatch_EnergyTunnel.class, GT_MetaTileEntity_Hatch_DynamoTunnel.class)).negate() : s -> true).casingIndex(5503).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(te -> ++te.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)LSC_PART, (int)0))})).addElement('g', StructureUtility.withChannel((String)"glass", (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)-2, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier))).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onlyIf(te -> te.topState != TopState.NotTop, (IStructureElement)StructureUtility.onElementPass(te -> {
        te.topState = TopState.Top;
    }, (IStructureElement)StructureUtility.withChannel((String)"glass", (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)-2, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)))), StructureUtility.onlyIf(te -> te.topState != TopState.Top, (IStructureElement)StructureUtility.onElementPass(te -> {
        te.topState = TopState.NotTop;
    }, (IStructureElement)new IStructureElement<GTMTE_LapotronicSuperCapacitor>(){

        public boolean check(GTMTE_LapotronicSuperCapacitor t, World world, int x, int y, int z) {
            Block worldBlock = world.func_147439_a(x, y, z);
            int meta = worldBlock.func_149643_k(world, x, y, z);
            if (LSC_PART != worldBlock || meta == 0) {
                return false;
            }
            int[] nArray = t.capacitors;
            int n = meta - 1;
            nArray[n] = nArray[n] + 1;
            return true;
        }

        private int getHint(ItemStack stack) {
            return Capacitor.VALUES_BY_TIER[Math.min(Capacitor.VALUES_BY_TIER.length, ChannelDataAccessor.getChannelData((ItemStack)stack, (String)"capacitor")) - 1].getMinimalGlassTier() + 1;
        }

        public boolean spawnHint(GTMTE_LapotronicSuperCapacitor t, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)LSC_PART, (int)this.getHint(trigger));
            return true;
        }

        public boolean placeBlock(GTMTE_LapotronicSuperCapacitor t, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147465_d(x, y, z, LSC_PART, this.getHint(trigger), 3);
            return true;
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(GTMTE_LapotronicSuperCapacitor t, World world, int x, int y, int z, ItemStack trigger, IItemSource source, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
            if (this.check(t, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            int glassTier = ChannelDataAccessor.getChannelData((ItemStack)trigger, (String)"glass") + 2;
            ItemStack targetStack = source.takeOne(s -> s != null && s.field_77994_a >= 0 && s.func_77973_b() == LSC_PART_ITEM && Capacitor.VALUES[Math.min(s.func_77960_j(), Capacitor.VALUES.length) - 1].getMinimalGlassTier() > glassTier, true);
            if (targetStack == null) {
                return IStructureElement.PlaceResult.REJECT;
            }
            return StructureUtility.survivalPlaceBlock((ItemStack)targetStack, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.EXACT, (NBTTagCompound)targetStack.field_77990_d, (boolean)true, (World)world, (int)x, (int)y, (int)z, (IItemSource)source, (EntityPlayerMP)actor, chatter);
        }
    }))})).addElement('C', StructureUtility.ofBlock((Block)LSC_PART, (int)1)).build();
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private final Set<GT_MetaTileEntity_Hatch_EnergyMulti> mEnergyHatchesTT = new HashSet<GT_MetaTileEntity_Hatch_EnergyMulti>();
    private final Set<GT_MetaTileEntity_Hatch_DynamoMulti> mDynamoHatchesTT = new HashSet<GT_MetaTileEntity_Hatch_DynamoMulti>();
    private final Set<GT_MetaTileEntity_Hatch_EnergyTunnel> mEnergyTunnelsTT = new HashSet<GT_MetaTileEntity_Hatch_EnergyTunnel>();
    private final Set<GT_MetaTileEntity_Hatch_DynamoTunnel> mDynamoTunnelsTT = new HashSet<GT_MetaTileEntity_Hatch_DynamoTunnel>();
    private final int[] capacitors = new int[10];
    private BigInteger capacity = BigInteger.ZERO;
    private BigInteger stored = BigInteger.ZERO;
    private long passiveDischargeAmount = 0L;
    private long inputLastTick = 0L;
    private long outputLastTick = 0L;
    private int repairStatusCache = 0;
    private byte glassTier = (byte)-1;
    private int casingAmount = 0;
    private TopState topState = TopState.MayBeTop;
    private long mMaxEUIn = 0L;
    private long mMaxEUOut = 0L;
    private UUID global_energy_user_uuid;

    public GTMTE_LapotronicSuperCapacitor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTMTE_LapotronicSuperCapacitor(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new GTMTE_LapotronicSuperCapacitor(this.mName);
    }

    public IStructureDefinition<GTMTE_LapotronicSuperCapacitor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void processInputHatch(GT_MetaTileEntity_Hatch aHatch, int aBaseCasingIndex) {
        this.mMaxEUIn += aHatch.maxEUInput() * aHatch.maxAmperesIn();
        aHatch.updateTexture(aBaseCasingIndex);
    }

    private void processOutputHatch(GT_MetaTileEntity_Hatch aHatch, int aBaseCasingIndex) {
        this.mMaxEUOut += aHatch.maxEUOutput() * aHatch.maxAmperesOut();
        aHatch.updateTexture(aBaseCasingIndex);
    }

    private boolean addBottomHatches(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null || aTileEntity.isDead()) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch)) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            GT_MetaTileEntity_Hatch_Energy tHatch = (GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity;
            this.processInputHatch((GT_MetaTileEntity_Hatch)tHatch, aBaseCasingIndex);
            return this.mEnergyHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyTunnel) {
            GT_MetaTileEntity_Hatch_EnergyTunnel tHatch = (GT_MetaTileEntity_Hatch_EnergyTunnel)aMetaTileEntity;
            this.processInputHatch((GT_MetaTileEntity_Hatch)tHatch, aBaseCasingIndex);
            return this.mEnergyTunnelsTT.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            GT_MetaTileEntity_Hatch_EnergyMulti tHatch = (GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity;
            this.processInputHatch((GT_MetaTileEntity_Hatch)tHatch, aBaseCasingIndex);
            return this.mEnergyHatchesTT.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            GT_MetaTileEntity_Hatch_Dynamo tDynamo = (GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity;
            this.processOutputHatch((GT_MetaTileEntity_Hatch)tDynamo, aBaseCasingIndex);
            return this.mDynamoHatches.add(tDynamo);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoTunnel) {
            GT_MetaTileEntity_Hatch_DynamoTunnel tDynamo = (GT_MetaTileEntity_Hatch_DynamoTunnel)aMetaTileEntity;
            this.processOutputHatch((GT_MetaTileEntity_Hatch)tDynamo, aBaseCasingIndex);
            return this.mDynamoTunnelsTT.add(tDynamo);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
            GT_MetaTileEntity_Hatch_DynamoMulti tDynamo = (GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity;
            this.processOutputHatch((GT_MetaTileEntity_Hatch)tDynamo, aBaseCasingIndex);
            return this.mDynamoHatchesTT.add(tDynamo);
        }
        return false;
    }

    private int getUHVCapacitorCount() {
        return this.capacitors[4];
    }

    private int getUEVCapacitorCount() {
        return this.capacitors[7];
    }

    private int getUIVCapacitorCount() {
        return this.capacitors[8];
    }

    private int getUMVCapacitorCount() {
        return this.capacitors[9];
    }

    private int wirelessCapableCapacitors() {
        return this.capacitors[4] + this.capacitors[7] + this.capacitors[8] + this.capacitors[9];
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Energy Storage").addInfo("Loses energy equal to 1% of the total capacity every 24 hours.").addInfo("Capped at " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)1000000L) + EnumChatFormatting.GRAY + " EU/t passive loss per " + GT_Values.TIER_COLORS[9] + GT_Values.VN[9] + EnumChatFormatting.GRAY + " capacitor.").addInfo("The passive loss increases " + EnumChatFormatting.DARK_RED + "100" + EnumChatFormatting.GRAY + "-fold for every capacitor tier above.").addInfo("Passive loss is multiplied by the number of maintenance issues present.").addSeparator().addInfo("Glass shell has to be Tier - 3 of the highest capacitor tier.").addInfo(GT_Values.TIER_COLORS[8] + GT_Values.VN[8] + EnumChatFormatting.GRAY + "-tier glass required for " + EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.GRAY + " Laser Hatches.").addInfo("Add more or better capacitors to increase capacity.").addSeparator().addInfo("Wireless mode can be enabled by right clicking with a screwdriver.").addInfo("This mode can only be enabled if you have a " + GT_Values.TIER_COLORS[9] + GT_Values.VN[9] + EnumChatFormatting.GRAY + "+ capacitor in the multiblock.").addInfo("When enabled every " + EnumChatFormatting.BLUE + GT_Utility.formatNumbers((long)IB_LapotronicEnergyUnit.LSC_time_between_wireless_rebalance_in_ticks) + EnumChatFormatting.GRAY + " ticks the LSC will attempt to re-balance against your").addInfo("wireless EU network.").addInfo("If there is less than " + EnumChatFormatting.RED + GT_Utility.formatNumbers((BigInteger)IB_LapotronicEnergyUnit.LSC_wireless_eu_cap) + EnumChatFormatting.GRAY + "(" + GT_Values.TIER_COLORS[9] + GT_Values.VN[9] + EnumChatFormatting.GRAY + ") EU in the LSC").addInfo("it will withdraw from the network and add to the LSC.").addInfo("If there is more it will add the EU to the network and remove it from the LSC.").addInfo("The threshold increases " + EnumChatFormatting.DARK_RED + "100" + EnumChatFormatting.GRAY + "-fold for every capacitor tier above.").addSeparator().beginVariableStructureBlock(5, 5, 4, 50, 5, 5, false).addStructureInfo("Modular height of 4-50 blocks.").addController("Front center bottom").addOtherStructurePart("Lapotronic Super Capacitor Casing", "5x2x5 base (at least 17x)").addOtherStructurePart("Lapotronic Capacitor (" + GT_Values.TIER_COLORS[4] + GT_Values.VN[4] + EnumChatFormatting.GRAY + "-" + GT_Values.TIER_COLORS[8] + GT_Values.VN[8] + EnumChatFormatting.GRAY + "), Ultimate Capacitor (" + GT_Values.TIER_COLORS[9] + GT_Values.VN[9] + EnumChatFormatting.GRAY + "-" + GT_Values.TIER_COLORS[12] + GT_Values.VN[12] + EnumChatFormatting.GRAY + ")", "Center 3x(1-47)x3 above base (9-423 blocks)").addStructureInfo("You can also use the Empty Capacitor to save materials if you use it for less than half the blocks").addOtherStructurePart("Borosilicate Glass (any)", "41-777x, Encase capacitor pillar").addEnergyHatch("Any casing").addDynamoHatch("Any casing").addOtherStructurePart("Laser Target/Source Hatches", "Any casing, must be using " + GT_Values.TIER_COLORS[8] + GT_Values.VN[8] + EnumChatFormatting.GRAY + "-tier glass").addStructureInfo("You can have several I/O Hatches").addSubChannelUsage("glass", "Borosilicate Glass Tier").addSubChannelUsage("capacitor", "Maximum Capacitor Tier").addSubChannelUsage("height", "Height of structure").addMaintenanceHatch("Any casing").toolTipFinisher("KekzTech");
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection forgeDirectionacing, int colorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] sTexture = new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, (short[])Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
        if (side == forgeDirectionacing && aActive) {
            sTexture = new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW, (short[])Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
        }
        return sTexture;
    }

    public void onPreTick(IGregTechTileEntity tileEntity, long aTick) {
        super.onPreTick(tileEntity, aTick);
        if (this.not_processed_lsc && tileEntity.isServerSide()) {
            WirelessNetworkManager.strongCheckOrAddUser((UUID)tileEntity.getOwnerUuid());
            this.global_energy_user_uuid = tileEntity.getOwnerUuid();
            this.not_processed_lsc = false;
        }
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    public boolean checkRecipe(ItemStack stack) {
        this.mProgresstime = 1;
        this.mMaxProgresstime = 1;
        this.mEUt = 0;
        this.mEfficiencyIncrease = 10000;
        return true;
    }

    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        block8: {
            WirelessNetworkManager.strongCheckOrAddUser((UUID)thisController.getOwnerUuid());
            Arrays.fill(this.capacitors, 0);
            this.mEnergyHatchesTT.clear();
            this.mDynamoHatchesTT.clear();
            this.mEnergyTunnelsTT.clear();
            this.mDynamoTunnelsTT.clear();
            this.mMaxEUIn = 0L;
            this.mMaxEUOut = 0L;
            this.glassTier = (byte)-2;
            this.casingAmount = 0;
            if (!this.checkPiece(STRUCTURE_PIECE_BASE, 2, 1, 0)) {
                return false;
            }
            if (this.casingAmount < 17) {
                return false;
            }
            this.topState = TopState.NotTop;
            int layer = 2;
            do {
                if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 2, layer, 0)) {
                    return false;
                }
                ++layer;
                if (this.topState == TopState.Top) break block8;
                this.topState = TopState.MayBeTop;
            } while (layer <= 50);
            return false;
        }
        for (int highestGlassTier = this.capacitors.length - 1; highestGlassTier >= 0; --highestGlassTier) {
            int highestCapacitor = Capacitor.getIndexFromGlassTier(highestGlassTier);
            if (this.capacitors[highestCapacitor] <= 0) continue;
            if (Capacitor.VALUES[highestCapacitor].getMinimalGlassTier() <= this.glassTier) break;
            return false;
        }
        if (this.glassTier < 8 && (this.mEnergyTunnelsTT.size() > 0 || this.mDynamoTunnelsTT.size() > 0)) {
            return false;
        }
        if (this.capacitors[5] > this.capacitors[0] + this.capacitors[1] + this.capacitors[2] + this.capacitors[3] + this.getUHVCapacitorCount() + this.capacitors[6] + this.getUEVCapacitorCount() + this.getUIVCapacitorCount() + this.getUMVCapacitorCount()) {
            return false;
        }
        this.capacity = BigInteger.ZERO;
        for (int i = 0; i < this.capacitors.length; ++i) {
            int count = this.capacitors[i];
            this.capacity = this.capacity.add(Capacitor.VALUES[i].getProvidedCapacity().multiply(BigInteger.valueOf(count)));
        }
        this.passiveDischargeAmount = this.recalculateLossWithMaintenance(this.getRepairStatus());
        return this.mMaintenanceHatches.size() == 1;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int layer = Math.min(stackSize.field_77994_a + 3, 50);
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 2, 1, 0);
        for (int i = 2; i < layer - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_MID, stackSize, hintsOnly, 2, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP, stackSize, hintsOnly, 2, layer - 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int layer = Math.min(ChannelDataAccessor.getChannelData((ItemStack)stackSize, (String)"height") + 3, 50);
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 2, 1, 0, elementBudget, source, actor, false, true);
        if (built >= 0) {
            return built;
        }
        for (int i = 2; i < layer - 1; ++i) {
            built = this.survivialBuildPiece(STRUCTURE_PIECE_MID, stackSize, 2, i, 0, elementBudget, source, actor, false, true);
        }
        if (built >= 0) {
            return built;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_TOP, stackSize, 2, layer - 1, 0, elementBudget, source, actor, false, true);
    }

    public boolean onRunningTick(ItemStack stack) {
        long power;
        long ttLaserWattage;
        long power2;
        this.inputLastTick = 0L;
        this.outputLastTick = 0L;
        long temp_stored = 0L;
        for (GT_MetaTileEntity_Hatch_Energy gT_MetaTileEntity_Hatch_Energy : this.mEnergyHatches) {
            if (gT_MetaTileEntity_Hatch_Energy == null || !gT_MetaTileEntity_Hatch_Energy.isValid()) continue;
            long power22 = this.getPowerToDraw(gT_MetaTileEntity_Hatch_Energy.maxEUInput() * gT_MetaTileEntity_Hatch_Energy.maxAmperesIn());
            if (gT_MetaTileEntity_Hatch_Energy.getEUVar() < power22) continue;
            gT_MetaTileEntity_Hatch_Energy.setEUVar(gT_MetaTileEntity_Hatch_Energy.getEUVar() - power22);
            temp_stored += power22;
            this.inputLastTick += power22;
        }
        for (GT_MetaTileEntity_Hatch_Dynamo gT_MetaTileEntity_Hatch_Dynamo : this.mDynamoHatches) {
            if (gT_MetaTileEntity_Hatch_Dynamo == null || !gT_MetaTileEntity_Hatch_Dynamo.isValid() || (power2 = this.getPowerToPush(gT_MetaTileEntity_Hatch_Dynamo.maxEUOutput() * gT_MetaTileEntity_Hatch_Dynamo.maxAmperesOut())) > gT_MetaTileEntity_Hatch_Dynamo.maxEUStore() - gT_MetaTileEntity_Hatch_Dynamo.getEUVar()) continue;
            gT_MetaTileEntity_Hatch_Dynamo.setEUVar(gT_MetaTileEntity_Hatch_Dynamo.getEUVar() + power2);
            temp_stored -= power2;
            this.outputLastTick += power2;
        }
        for (GT_MetaTileEntity_Hatch_EnergyMulti gT_MetaTileEntity_Hatch_EnergyMulti : this.mEnergyHatchesTT) {
            if (gT_MetaTileEntity_Hatch_EnergyMulti == null || !gT_MetaTileEntity_Hatch_EnergyMulti.isValid()) continue;
            power2 = this.getPowerToDraw(gT_MetaTileEntity_Hatch_EnergyMulti.maxEUInput() * gT_MetaTileEntity_Hatch_EnergyMulti.maxAmperesIn());
            if (gT_MetaTileEntity_Hatch_EnergyMulti.getEUVar() < power2) continue;
            gT_MetaTileEntity_Hatch_EnergyMulti.setEUVar(gT_MetaTileEntity_Hatch_EnergyMulti.getEUVar() - power2);
            temp_stored += power2;
            this.inputLastTick += power2;
        }
        for (GT_MetaTileEntity_Hatch_DynamoMulti gT_MetaTileEntity_Hatch_DynamoMulti : this.mDynamoHatchesTT) {
            if (gT_MetaTileEntity_Hatch_DynamoMulti == null || !gT_MetaTileEntity_Hatch_DynamoMulti.isValid() || (power2 = this.getPowerToPush(gT_MetaTileEntity_Hatch_DynamoMulti.maxEUOutput() * gT_MetaTileEntity_Hatch_DynamoMulti.maxAmperesOut())) > gT_MetaTileEntity_Hatch_DynamoMulti.maxEUStore() - gT_MetaTileEntity_Hatch_DynamoMulti.getEUVar()) continue;
            gT_MetaTileEntity_Hatch_DynamoMulti.setEUVar(gT_MetaTileEntity_Hatch_DynamoMulti.getEUVar() + power2);
            temp_stored -= power2;
            this.outputLastTick += power2;
        }
        for (GT_MetaTileEntity_Hatch_EnergyTunnel gT_MetaTileEntity_Hatch_EnergyTunnel : this.mEnergyTunnelsTT) {
            if (gT_MetaTileEntity_Hatch_EnergyTunnel == null || !gT_MetaTileEntity_Hatch_EnergyTunnel.isValid()) continue;
            ttLaserWattage = gT_MetaTileEntity_Hatch_EnergyTunnel.maxEUInput() * (long)gT_MetaTileEntity_Hatch_EnergyTunnel.Amperes - (long)(gT_MetaTileEntity_Hatch_EnergyTunnel.Amperes / 20);
            power = this.getPowerToDraw(ttLaserWattage);
            if (gT_MetaTileEntity_Hatch_EnergyTunnel.getEUVar() < power) continue;
            gT_MetaTileEntity_Hatch_EnergyTunnel.setEUVar(gT_MetaTileEntity_Hatch_EnergyTunnel.getEUVar() - power);
            temp_stored += power;
            this.inputLastTick += power;
        }
        for (GT_MetaTileEntity_Hatch_DynamoTunnel gT_MetaTileEntity_Hatch_DynamoTunnel : this.mDynamoTunnelsTT) {
            if (gT_MetaTileEntity_Hatch_DynamoTunnel == null || !gT_MetaTileEntity_Hatch_DynamoTunnel.isValid() || (power = this.getPowerToPush(ttLaserWattage = gT_MetaTileEntity_Hatch_DynamoTunnel.maxEUOutput() * (long)gT_MetaTileEntity_Hatch_DynamoTunnel.Amperes - (long)(gT_MetaTileEntity_Hatch_DynamoTunnel.Amperes / 20))) > gT_MetaTileEntity_Hatch_DynamoTunnel.maxEUStore() - gT_MetaTileEntity_Hatch_DynamoTunnel.getEUVar()) continue;
            gT_MetaTileEntity_Hatch_DynamoTunnel.setEUVar(gT_MetaTileEntity_Hatch_DynamoTunnel.getEUVar() + power);
            temp_stored -= power;
            this.outputLastTick += power;
        }
        if (this.wirelessCapableCapacitors() <= 0) {
            this.wireless_mode = false;
        }
        ++this.counter;
        if (this.wireless_mode && (long)this.counter >= IB_LapotronicEnergyUnit.LSC_time_between_wireless_rebalance_in_ticks) {
            this.counter = 1;
            BigInteger transferred_eu = this.stored.subtract(IB_LapotronicEnergyUnit.LSC_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUHVCapacitorCount())).add(IB_LapotronicEnergyUnit.UEV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUEVCapacitorCount()))).add(IB_LapotronicEnergyUnit.UIV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUIVCapacitorCount()))).add(IB_LapotronicEnergyUnit.UMV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUMVCapacitorCount()))));
            if (transferred_eu.signum() == 1) {
                this.inputLastTick += transferred_eu.longValue();
            } else {
                this.outputLastTick += transferred_eu.longValue();
            }
            if (WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.global_energy_user_uuid, (BigInteger)transferred_eu)) {
                this.stored = IB_LapotronicEnergyUnit.LSC_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUHVCapacitorCount())).add(IB_LapotronicEnergyUnit.UEV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUEVCapacitorCount())).add(IB_LapotronicEnergyUnit.UIV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUIVCapacitorCount()))).add(IB_LapotronicEnergyUnit.UMV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUMVCapacitorCount()))));
            }
        }
        if (super.getRepairStatus() != this.repairStatusCache) {
            this.passiveDischargeAmount = this.recalculateLossWithMaintenance(super.getRepairStatus());
        }
        this.stored = this.stored.add(BigInteger.valueOf(temp_stored -= this.passiveDischargeAmount));
        this.stored = this.stored.compareTo(BigInteger.ZERO) <= 0 ? BigInteger.ZERO : this.stored;
        IGregTechTileEntity tBMTE = this.getBaseMetaTileEntity();
        tBMTE.injectEnergyUnits(ForgeDirection.UNKNOWN, this.inputLastTick, 1L);
        tBMTE.drainEnergyUnits(ForgeDirection.UNKNOWN, this.outputLastTick, 1L);
        if (this.energyInputValues.size() > 100) {
            this.energyInputValues.remove();
        }
        this.energyInputValues.offer(this.inputLastTick);
        if (this.energyOutputValues.size() > 100) {
            this.energyOutputValues.remove();
        }
        this.energyOutputValues.offer(this.outputLastTick);
        return true;
    }

    private long recalculateLossWithMaintenance(int repairStatus) {
        this.repairStatusCache = repairStatus;
        long temp_capacity_divided = 0L;
        if (this.wirelessCapableCapacitors() == 0) {
            temp_capacity_divided = this.capacity.divide(BigInteger.valueOf(172800000L)).longValue();
        }
        if (this.wirelessCapableCapacitors() != 0) {
            temp_capacity_divided = (long)this.getUHVCapacitorCount() * 1000000L + (long)this.getUEVCapacitorCount() * 100000000L + (long)this.getUIVCapacitorCount() * this.max_passive_drain_eu_per_tick_per_uiv_cap + (long)this.getUMVCapacitorCount() * this.max_passive_drain_eu_per_tick_per_umv_cap;
        }
        long total_passive_loss = temp_capacity_divided * (long)(this.getIdealStatus() - repairStatus + 1);
        return total_passive_loss;
    }

    private long getPowerToDraw(long hatchWatts) {
        BigInteger remcapActual = this.capacity.subtract(this.stored);
        BigInteger recampLimited = MAX_LONG.compareTo(remcapActual) > 0 ? remcapActual : MAX_LONG;
        return Math.min(hatchWatts, recampLimited.longValue());
    }

    private long getPowerToPush(long hatchWatts) {
        BigInteger remStoredLimited = MAX_LONG.compareTo(this.stored) > 0 ? this.stored : MAX_LONG;
        return Math.min(hatchWatts, remStoredLimited.longValue());
    }

    private long getAvgIn() {
        long sum = 0L;
        Iterator iterator = this.energyInputValues.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            sum += l;
        }
        return sum / (long)Math.max(this.energyInputValues.size(), 1);
    }

    private long getAvgOut() {
        long sum = 0L;
        Iterator iterator = this.energyOutputValues.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            sum += l;
        }
        return sum / (long)Math.max(this.energyOutputValues.size(), 1);
    }

    public String[] getInfoData() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        int secInterval = 5;
        double avgIn = this.getAvgIn();
        double avgOut = this.getAvgOut();
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(EnumChatFormatting.YELLOW + "Operational Data:" + EnumChatFormatting.RESET);
        ll.add("EU Stored: " + nf.format(this.stored) + "EU");
        ll.add("EU Stored: " + Util.toStandardForm(this.stored) + "EU");
        ll.add("Used Capacity: " + Util.toPercentageFrom(this.stored, this.capacity));
        ll.add("Total Capacity: " + nf.format(this.capacity) + "EU");
        ll.add("Total Capacity: " + Util.toStandardForm(this.capacity) + "EU");
        ll.add("Passive Loss: " + nf.format(this.passiveDischargeAmount) + "EU/t");
        ll.add("EU IN: " + GT_Utility.formatNumbers((long)this.inputLastTick) + "EU/t");
        ll.add("EU OUT: " + GT_Utility.formatNumbers((long)this.outputLastTick) + "EU/t");
        ll.add("Avg EU IN: " + nf.format(avgIn) + " (last " + secInterval + " seconds)");
        ll.add("Avg EU OUT: " + nf.format(avgOut) + " (last " + secInterval + " seconds)");
        if (avgIn > avgOut) {
            if (avgIn != 0.0) {
                double timeToFull = (double)(this.capacity.longValue() - this.stored.longValue()) / avgIn / 20.0;
                String timeToFullString = this.formatTime(timeToFull);
                ll.add("Time to Full: " + timeToFullString);
            }
        } else if (avgOut != 0.0) {
            double timeToEmpty = (double)this.stored.longValue() / avgOut / 20.0;
            String timeToEmptyString = this.formatTime(timeToEmpty);
            ll.add("Time to Empty: " + timeToEmptyString);
        }
        ll.add("Maintenance Status: " + (super.getRepairStatus() == super.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has Problems" + EnumChatFormatting.RESET));
        ll.add("Wireless mode: " + (this.wireless_mode ? EnumChatFormatting.GREEN + "enabled" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "disabled" + EnumChatFormatting.RESET));
        ll.add(GT_Values.TIER_COLORS[9] + GT_Values.VN[9] + EnumChatFormatting.RESET + " Capacitors detected: " + this.getUHVCapacitorCount());
        ll.add(GT_Values.TIER_COLORS[10] + GT_Values.VN[10] + EnumChatFormatting.RESET + " Capacitors detected: " + this.getUEVCapacitorCount());
        ll.add(GT_Values.TIER_COLORS[11] + GT_Values.VN[11] + EnumChatFormatting.RESET + " Capacitors detected: " + this.getUIVCapacitorCount());
        ll.add(GT_Values.TIER_COLORS[12] + GT_Values.VN[12] + EnumChatFormatting.RESET + " Capacitors detected: " + this.getUMVCapacitorCount());
        ll.add("Total wireless EU: " + EnumChatFormatting.RED + nf.format(WirelessNetworkManager.getUserEU((UUID)this.global_energy_user_uuid)));
        ll.add("Total wireless EU: " + EnumChatFormatting.RED + Util.toStandardForm(WirelessNetworkManager.getUserEU((UUID)this.global_energy_user_uuid)));
        ll.add("---------------------------------------------");
        String[] a = new String[ll.size()];
        return ll.toArray(a);
    }

    private String formatTime(double time) {
        if (time < 1.0) {
            return "Completely " + (time < 0.0 ? "empty" : "full");
        }
        if (time < 60.0) {
            return String.format("%.2f seconds", time);
        }
        if (time < 3600.0) {
            return String.format("%.2f minutes", time / 60.0);
        }
        if (time < 86400.0) {
            return String.format("%.2f hours", time / 3600.0);
        }
        if (time < 3.1536E7) {
            return String.format("%.2f days", time / 86400.0);
        }
        return String.format("%.2f years", time / 3.1536E7);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        nbt.func_74773_a("capacity", this.capacity.toByteArray());
        nbt.func_74773_a("stored", this.stored.toByteArray());
        nbt.func_74757_a("wireless_mode", this.wireless_mode);
        nbt.func_74768_a("wireless_mode_cooldown", this.counter);
        super.saveNBTData(nbt);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        this.capacity = new BigInteger(nbt.func_74770_j("capacity"));
        this.stored = new BigInteger(nbt.func_74770_j("stored"));
        this.wireless_mode = nbt.func_74767_n("wireless_mode");
        this.counter = nbt.func_74762_e("wireless_mode_cooldown");
        super.loadNBTData(nbt);
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack stack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }

    public long maxEUStore() {
        return this.capacity.longValue();
    }

    public long getEUVar() {
        return this.stored.longValue();
    }

    public long maxEUInput() {
        if (this.wireless_mode) {
            return Long.MAX_VALUE;
        }
        return this.mMaxEUIn;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public long maxEUOutput() {
        if (this.wireless_mode) {
            return Long.MAX_VALUE;
        }
        return this.mMaxEUOut;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    protected boolean canUseWireless() {
        return this.wirelessCapableCapacitors() != 0;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.canUseWireless()) {
            this.wireless_mode = !this.wireless_mode;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Wireless network mode " + (this.wireless_mode ? "enabled." : "disabled.")));
        } else {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Wireless mode cannot be enabled without at least 1 " + GT_Values.TIER_COLORS[9] + GT_Values.VN[9] + EnumChatFormatting.RESET + "+ capacitor."));
            this.wireless_mode = false;
        }
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                this.canUseWireless = this.canUseWireless();
            }
            if (this.canUseWireless) {
                this.wireless_mode = !this.wireless_mode;
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GT_UITextures.BUTTON_STANDARD);
            if (this.canUseWireless) {
                if (this.wireless_mode) {
                    ret.add(KT_UITextures.OVERLAY_BUTTON_WIRELESS_ON);
                } else {
                    ret.add(KT_UITextures.OVERLAY_BUTTON_WIRELESS_OFF);
                }
            } else {
                ret.add(KT_UITextures.OVERLAY_BUTTON_WIRELESS_OFF_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(80, 91).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"gui.kekztech_lapotronicenergyunit.wireless")).setTooltipShowUpDelay(5))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.wireless_mode, val -> {
            this.wireless_mode = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(this::canUseWireless, val -> {
            this.canUseWireless = val;
        }));
    }

    static /* synthetic */ BigInteger access$000() {
        return MAX_LONG;
    }

    private static enum LSCHatchElement implements IHatchElement<GTMTE_LapotronicSuperCapacitor>
    {
        Energy(new Class[]{GT_MetaTileEntity_Hatch_EnergyMulti.class, GT_MetaTileEntity_Hatch_Energy.class}){

            public long count(GTMTE_LapotronicSuperCapacitor t) {
                return t.mEnergyHatches.size() + t.mEnergyHatchesTT.size() + t.mEnergyTunnelsTT.size();
            }
        }
        ,
        Dynamo(new Class[]{GT_MetaTileEntity_Hatch_DynamoMulti.class, GT_MetaTileEntity_Hatch_Dynamo.class}){

            public long count(GTMTE_LapotronicSuperCapacitor t) {
                return t.mDynamoHatches.size() + t.mDynamoHatchesTT.size() + t.mDynamoTunnelsTT.size();
            }
        };

        private final List<? extends Class<? extends IMetaTileEntity>> mteClasses;

        @SafeVarargs
        private LSCHatchElement(Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Arrays.asList(mteClasses);
        }

        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        public IGT_HatchAdder<? super GTMTE_LapotronicSuperCapacitor> adder() {
            return (rec$, x$0, x$1) -> ((GTMTE_LapotronicSuperCapacitor)((Object)((Object)rec$))).addBottomHatches(x$0, x$1);
        }
    }

    private static enum Capacitor {
        IV(2, BigInteger.valueOf(IB_LapotronicEnergyUnit.IV_cap_storage)),
        LuV(3, BigInteger.valueOf(IB_LapotronicEnergyUnit.LuV_cap_storage)),
        ZPM(4, BigInteger.valueOf(IB_LapotronicEnergyUnit.ZPM_cap_storage)),
        UV(5, BigInteger.valueOf(IB_LapotronicEnergyUnit.UV_cap_storage)),
        UHV(6, GTMTE_LapotronicSuperCapacitor.access$000()),
        None(0, BigInteger.ZERO),
        EV(1, BigInteger.valueOf(IB_LapotronicEnergyUnit.EV_cap_storage)),
        UEV(7, GTMTE_LapotronicSuperCapacitor.access$000()),
        UIV(8, BigInteger.valueOf(IB_LapotronicEnergyUnit.UIV_cap_storage)),
        UMV(9, IB_LapotronicEnergyUnit.UMV_cap_storage);

        private final int minimalGlassTier;
        private final BigInteger providedCapacity;
        static final Capacitor[] VALUES;
        static final Capacitor[] VALUES_BY_TIER;

        private Capacitor(int minimalGlassTier, BigInteger providedCapacity) {
            this.minimalGlassTier = minimalGlassTier;
            this.providedCapacity = providedCapacity;
        }

        public int getMinimalGlassTier() {
            return this.minimalGlassTier;
        }

        public BigInteger getProvidedCapacity() {
            return this.providedCapacity;
        }

        public static int getIndexFromGlassTier(int glassTier) {
            for (int index = 0; index < Capacitor.values().length; ++index) {
                if (Capacitor.values()[index].getMinimalGlassTier() != glassTier) continue;
                return index;
            }
            return -1;
        }

        static {
            VALUES = Capacitor.values();
            VALUES_BY_TIER = (Capacitor[])Arrays.stream(Capacitor.values()).sorted(Comparator.comparingInt(Capacitor::getMinimalGlassTier)).toArray(Capacitor[]::new);
        }
    }

    private static enum TopState {
        MayBeTop,
        Top,
        NotTop;

    }
}

