/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.base;

import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IOverclockDescriptionProvider;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_ChunkManager;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.overclockdescriber.FusionOverclockDescriber;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_HatchElementBuilder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.IDualInputHatch;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class LargeFusionComputer
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements IConstructable,
ISurvivalConstructable,
IOverclockDescriptionProvider {
    public static final String MAIN_NAME = "largeFusion";
    public static final int M = 1000000;
    private boolean isLoadedChunk;
    public GT_Recipe mLastRecipe;
    public int para;
    protected OverclockDescriber overclockDescriber;
    private static final ClassValue<IStructureDefinition<LargeFusionComputer>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<LargeFusionComputer>>(){

        @Override
        protected IStructureDefinition<LargeFusionComputer> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(LargeFusionComputer.MAIN_NAME, StructureUtility.transpose((String[][])new String[][]{L0, L1, L2, L3, L2, L1, L0})).addElement('H', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCoilBlock(), (int)x.getCoilMeta()))).addElement('C', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCasingBlock(), (int)x.getCasingMeta()))).addElement('B', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getGlassBlock(), (int)x.getGlassMeta()))).addElement('I', (IStructureElement)StructureUtility.lazy(x -> GT_HatchElementBuilder.builder().atLeast(new IHatchElement[]{GT_HatchElement.InputHatch.or((IHatchElement)GT_HatchElement.InputBus), GT_HatchElement.OutputHatch}).adder((rec$, x$0, x$1) -> ((LargeFusionComputer)((Object)((Object)((Object)rec$)))).addFluidIO(x$0, x$1)).casingIndex(x.textureIndex()).dot(1).hatchItemFilterAnd(x2 -> GT_StructureUtility.filterByMTETier((int)x2.hatchTier(), (int)Integer.MAX_VALUE)).buildAndChain(x.getGlassBlock(), x.getGlassMeta()))).addElement('E', (IStructureElement)StructureUtility.lazy(x -> GT_HatchElementBuilder.builder().anyOf(new IHatchElement[]{GT_MetaTileEntity_MultiblockBase_EM.HatchElement.EnergyMulti.or((IHatchElement)GT_HatchElement.Energy)}).adder((rec$, x$0, x$1) -> ((LargeFusionComputer)((Object)((Object)((Object)rec$)))).addEnergyInjector(x$0, x$1)).casingIndex(x.textureIndex()).hatchItemFilterAnd(x2 -> GT_StructureUtility.filterByMTETier((int)x2.hatchTier(), (int)Integer.MAX_VALUE)).dot(2).buildAndChain(x.getCasingBlock(), x.getCasingMeta()))).addElement('F', (IStructureElement)StructureUtility.lazy(x -> GT_StructureUtility.ofFrame((Materials)x.getFrameBox()))).build();
        }
    };
    protected long energyStorageCache;
    protected static final NumberFormatMUI numberFormat;
    public static final String[] L0;
    public static final String[] L1;
    public static final String[] L2;
    public static final String[] L3;

    public LargeFusionComputer(String name) {
        super(name);
        this.useLongPower = true;
        this.overclockDescriber = this.createOverclockDescriber();
    }

    public LargeFusionComputer(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
        this.useLongPower = true;
        this.overclockDescriber = this.createOverclockDescriber();
    }

    protected OverclockDescriber createOverclockDescriber() {
        return new FusionOverclockDescriber((byte)this.tier(), this.capableStartupCanonical());
    }

    @Nullable
    public OverclockDescriber getOverclockDescriber() {
        return this.overclockDescriber;
    }

    public abstract int tier();

    public long maxEUStore() {
        return this.capableStartupCanonical() * (long)Math.min(32, this.mEnergyHatches.size() + this.eEnergyMulti.size()) / 32L;
    }

    public abstract long capableStartupCanonical();

    public abstract Block getCasingBlock();

    public abstract int getCasingMeta();

    public abstract Block getCoilBlock();

    public abstract int getCoilMeta();

    public abstract Block getGlassBlock();

    public abstract int getGlassMeta();

    public abstract int hatchTier();

    public abstract Materials getFrameBox();

    public abstract int getMaxPara();

    public abstract int extraPara(int var1);

    public int textureIndex() {
        return 53;
    }

    public abstract ITexture getTextureOverlay();

    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aStack) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.eEnergyMulti.clear();
        if (this.structureCheck_EM(MAIN_NAME, 23, 3, 40) && this.mInputHatches.size() + this.mDualInputHatches.size() != 0 && !this.mOutputHatches.isEmpty() && this.mEnergyHatches.size() + this.eEnergyMulti.size() != 0) {
            this.fixAllIssue();
            return true;
        }
        return false;
    }

    public void fixAllIssue() {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM(MAIN_NAME, 23, 3, 40, itemStack, b);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(MAIN_NAME, stackSize, 23, 3, 40, realBudget, env, false, true);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && !aBaseMetaTileEntity.isAllowedToWork()) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)aBaseMetaTileEntity));
            this.isLoadedChunk = false;
        } else if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && !this.isLoadedChunk) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)aBaseMetaTileEntity));
            int offX = aBaseMetaTileEntity.getFrontFacing().offsetX;
            int offZ = aBaseMetaTileEntity.getFrontFacing().offsetZ;
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + offX, this.getChunkZ() + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + 1 + offX, this.getChunkZ() + 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + 1 + offX, this.getChunkZ() + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + 1 + offX, this.getChunkZ() - 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() - 1 + offX, this.getChunkZ() + 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() - 1 + offX, this.getChunkZ() + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() - 1 + offX, this.getChunkZ() - 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + offX, this.getChunkZ() + 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + offX, this.getChunkZ() - 1 + offZ));
            this.isLoadedChunk = true;
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            if (aTick % 400L == 0L) {
                this.fixAllIssue();
            }
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mRunningOnLoad && this.checkMachine(aBaseMetaTileEntity, this.mInventory[1])) {
                this.checkRecipe();
            }
            if (this.mUpdated) {
                this.mUpdate = 50;
                this.mUpdated = false;
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0 || this.cyclicUpdate_EM() || aBaseMetaTileEntity.hasWorkJustBeenEnabled()) {
                if (this.mUpdate <= -1000) {
                    this.mUpdate = 5000;
                }
                this.checkStructure(true, aBaseMetaTileEntity);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    if (aBaseMetaTileEntity.getStoredEU() <= 0L && this.mMaxProgresstime > 0) {
                        this.criticalStopMachine();
                    }
                    long energyLimit = this.getSingleHatchPower();
                    List hatches = this.getExoticAndNormalEnergyHatchList();
                    for (GT_MetaTileEntity_Hatch hatch : (List)GT_Utility.filterValidMTEs((Collection)hatches)) {
                        long consumableEnergy = Math.min(hatch.getEUVar(), energyLimit);
                        long receivedEnergy = Math.min(consumableEnergy, this.maxEUStore() - aBaseMetaTileEntity.getStoredEU());
                        if (receivedEnergy <= 0L) continue;
                        hatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(receivedEnergy, false);
                        aBaseMetaTileEntity.increaseStoredEnergyUnits(receivedEnergy, true);
                    }
                    if (this.mMaxProgresstime > 0) {
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(-this.lEUt, true);
                        if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                            if (this.mOutputItems != null) {
                                for (ItemStack itemStack : this.mOutputItems) {
                                    if (itemStack == null) continue;
                                    this.addOutput(itemStack);
                                }
                            }
                            if (this.mOutputFluids != null) {
                                for (ItemStack itemStack : this.mOutputFluids) {
                                    if (itemStack == null) continue;
                                    this.addOutput((FluidStack)itemStack);
                                }
                            }
                            this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1])));
                            this.mOutputItems = null;
                            this.mOutputFluids = null;
                            this.mProgresstime = 0;
                            this.mMaxProgresstime = 0;
                            this.mEfficiencyIncrease = 0;
                            this.para = 0;
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.checkRecipe();
                            }
                        }
                    } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                        this.turnCasingActive(this.mMaxProgresstime > 0);
                        if (aBaseMetaTileEntity.isAllowedToWork() && this.checkRecipe()) {
                            if (aBaseMetaTileEntity.getStoredEU() < (long)this.mLastRecipe.mSpecialValue + this.lEUt) {
                                this.mMaxProgresstime = 0;
                                this.turnCasingActive(false);
                                this.criticalStopMachine();
                            }
                            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)this.mLastRecipe.mSpecialValue + this.lEUt, false);
                        }
                        if (this.mMaxProgresstime <= 0) {
                            this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                        }
                    }
                } else {
                    this.turnCasingActive(false);
                    this.mLastRecipe = null;
                    this.stopMachine();
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
        } else {
            this.soundMagic(this.getActivitySound());
        }
    }

    protected long getSingleHatchPower() {
        return GT_Values.V[this.tier()] * (long)this.getMaxPara() * (long)this.extraPara(100) / 32L;
    }

    public boolean turnCasingActive(boolean status) {
        if (this.mEnergyHatches != null) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.mEnergyHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.eEnergyMulti != null) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.eEnergyMulti) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mOutputHatches != null) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.mOutputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mInputHatches != null) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.mInputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mDualInputHatches != null) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.mDualInputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS}).extFacing().build(), this.getTextureOverlay()};
        }
        if (aActive) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)52)};
        }
        return new ITexture[]{TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS}).extFacing().build()};
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public void onMachineBlockUpdate() {
        this.mUpdate = 100;
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.fusionRecipes;
    }

    public int getRecipeCatalystPriority() {
        return -2;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected GT_ParallelHelper createParallelHelper(@NotNull GT_Recipe recipe) {
                return super.createParallelHelper(recipe).setConsumption(!LargeFusionComputer.this.mRunningOnLoad);
            }

            @NotNull
            protected GT_OverclockCalculator createOverclockCalculator(@NotNull GT_Recipe recipe) {
                return LargeFusionComputer.this.overclockDescriber.createCalculator(super.createOverclockCalculator(recipe), recipe);
            }

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                if (!LargeFusionComputer.this.mRunningOnLoad) {
                    if ((long)recipe.mSpecialValue > LargeFusionComputer.this.maxEUStore()) {
                        return CheckRecipeResultRegistry.insufficientStartupPower((int)recipe.mSpecialValue);
                    }
                    if ((long)recipe.mEUt > GT_Values.V[LargeFusionComputer.this.tier()]) {
                        return CheckRecipeResultRegistry.insufficientPower((long)recipe.mEUt);
                    }
                }
                this.maxParallel = LargeFusionComputer.this.getMaxPara() * LargeFusionComputer.this.extraPara(recipe.mSpecialValue);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (LargeFusionComputer.this.mRunningOnLoad) {
                    LargeFusionComputer.this.mRunningOnLoad = false;
                }
                LargeFusionComputer.this.turnCasingActive(result.wasSuccessful());
                LargeFusionComputer.this.mLastRecipe = result.wasSuccessful() ? this.lastRecipe : null;
                LargeFusionComputer.this.para = this.getCurrentParallels();
                return result;
            }
        };
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GT_Values.V[this.tier()]);
        logic.setAvailableAmperage(this.getSingleHatchPower() * 32L / GT_Values.V[this.tier()]);
    }

    public void onRemoval() {
        if (this.isLoadedChunk) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)this.getBaseMetaTileEntity()));
        }
        super.onRemoval();
    }

    public int getChunkX() {
        return this.getBaseMetaTileEntity().getXCoord() >> 4;
    }

    public int getChunkZ() {
        return this.getBaseMetaTileEntity().getZCoord() >> 4;
    }

    private boolean addEnergyInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            GT_MetaTileEntity_Hatch_Energy tHatch = (GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity;
            if (tHatch.getTierForStructure() < this.hatchTier()) {
                return false;
            }
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            GT_MetaTileEntity_Hatch_EnergyMulti tHatch = (GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity;
            if (tHatch.getTierForStructure() < this.hatchTier()) {
                return false;
            }
            tHatch.updateTexture(aBaseCasingIndex);
            return this.eEnergyMulti.add(tHatch);
        }
        return false;
    }

    private boolean addFluidIO(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        GT_MetaTileEntity_Hatch_Input tInput;
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            GT_MetaTileEntity_Hatch hatch = (GT_MetaTileEntity_Hatch)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            tInput = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            if (tInput.getTierForStructure() < this.hatchTier()) {
                return false;
            }
            tInput.mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tInput);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            GT_MetaTileEntity_Hatch_Output tOutput = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
            if (tOutput.getTierForStructure() < this.hatchTier()) {
                return false;
            }
            return this.mOutputHatches.add(tOutput);
        }
        if (aMetaTileEntity instanceof IDualInputHatch) {
            tInput = (IDualInputHatch)aMetaTileEntity;
            tInput.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mDualInputHatches.add(tInput);
        }
        return false;
    }

    public IStructureDefinition<LargeFusionComputer> getStructure_EM() {
        return STRUCTURE_DEFINITION.get(((Object)((Object)this)).getClass());
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected ResourceLocation getActivitySound() {
        return SoundResource.GT_MACHINES_FUSION_LOOP.resourceLocation;
    }

    public String[] getInfoData() {
        String string;
        IGregTechTileEntity baseMetaTileEntity = this.getBaseMetaTileEntity();
        switch (this.tier()) {
            case 6: {
                string = EnumChatFormatting.RED + "I" + EnumChatFormatting.RESET;
                break;
            }
            case 7: {
                string = EnumChatFormatting.RED + "II" + EnumChatFormatting.RESET;
                break;
            }
            case 8: {
                string = EnumChatFormatting.RED + "III" + EnumChatFormatting.RESET;
                break;
            }
            case 9: {
                string = EnumChatFormatting.RED + "IV" + EnumChatFormatting.RESET;
                break;
            }
            default: {
                string = EnumChatFormatting.GOLD + "V" + EnumChatFormatting.RESET;
            }
        }
        String tier = string;
        double plasmaOut = 0.0;
        if (this.mMaxProgresstime > 0) {
            plasmaOut = (double)this.mOutputFluids[0].amount / (double)this.mMaxProgresstime;
        }
        return new String[]{EnumChatFormatting.BLUE + "Fusion Reactor MK " + EnumChatFormatting.RESET + tier, StatCollector.func_74838_a((String)"scanner.info.UX.0") + ": " + EnumChatFormatting.LIGHT_PURPLE + GT_Utility.formatNumbers((long)this.para) + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.fusion.req") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)(-this.lEUt)) + EnumChatFormatting.RESET + "EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)(baseMetaTileEntity != null ? baseMetaTileEntity.getStoredEU() : 0L)) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.maxEUStore()) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.fusion.plasma") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((double)plasmaOut) + EnumChatFormatting.RESET + "L/t"};
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.LargeFusion.0") + " " + numberFormat.format(this.energyStorageCache) + " EU").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.LongSyncer(this::maxEUStore, val -> {
            this.energyStorageCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.LargeFusion.1") + " " + numberFormat.format(this.getEUVar()) + " EU").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> ((LargeFusionComputer)this).getEUVar(), arg_0 -> ((LargeFusionComputer)this).setEUVar(arg_0)));
    }

    static {
        Textures.BlockIcons.setCasingTextureForId((int)52, (ITexture)TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW_GLOW}).extFacing().glow().build()}));
        numberFormat = new NumberFormatMUI();
        L0 = new String[]{"                                               ", "                                               ", "                    FCCCCCF                    ", "                    FCIBICF                    ", "                    FCCCCCF                    ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "  FFF                                     FFF  ", "  CCC                                     CCC  ", "  CIC                                     CIC  ", "  CBC                                     CBC  ", "  CIC                                     CIC  ", "  CCC                                     CCC  ", "  FFF                                     FFF  ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                    FCCCCCF                    ", "                    FCIBICF                    ", "                    FCCCCCF                    ", "                                               ", "                                               "};
        L1 = new String[]{"                                               ", "                    FCBBBCF                    ", "                   CC     CC                   ", "                CCCCC     CCCCC                ", "              CCCCCCC     CCCCCCC              ", "            CCCCCCC FCBBBCF CCCCCCC            ", "           CCCCC               CCCCC           ", "          CCCC                   CCCC          ", "         CCC                       CCC         ", "        CCC                         CCC        ", "       CCC                           CCC       ", "      CCC                             CCC      ", "     CCC                               CCC     ", "     CCC                               CCC     ", "    CCC                                 CCC    ", "    CCC                                 CCC    ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "  CCC                                     CCC  ", " FCCCF                                   FCCCF ", " C   C                                   C   C ", " B   B                                   B   B ", " B   B                                   B   B ", " B   B                                   B   B ", " C   C                                   C   C ", " FCCCF                                   FCCCF ", "  CCC                                     CCC  ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "    CCC                                 CCC    ", "    CCC                                 CCC    ", "     CCC                               CCC     ", "     CCC                               CCC     ", "      CCC                             CCC      ", "       CCC                           CCC       ", "        CCC                         CCC        ", "         CCC                       CCC         ", "          CCCC                   CCCC          ", "           CCCCC               CCCCC           ", "            CCCCCCC FCBBBCF CCCCCCC            ", "              CCCCCCC     CCCCCCC              ", "                CCCCC     CCCCC                ", "                   CC     CC                   ", "                    FCBBBCF                    ", "                                               "};
        L2 = new String[]{"                    FCCCCCF                    ", "                   CC     CC                   ", "                CCCCC     CCCCC                ", "              CCCCCHHHHHHHHHCCCCC              ", "            CCCCHHHCC     CCHHHCCCC            ", "           CCCHHCCCCC     CCCCCHHCCC           ", "          ECHHCCCCC FCCCCCF CCCCCHHCE          ", "         CCHCCCC               CCCCHCC         ", "        CCHCCC                   CCCHCC        ", "       CCHCE                       ECHCC       ", "      ECHCC                         CCHCE      ", "     CCHCE                           ECHCC     ", "    CCHCC                             CCHCC    ", "    CCHCC                             CCHCC    ", "   CCHCC                               CCHCC   ", "   CCHCC                               CCHCC   ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", " CCHCC                                   CCHCC ", "FCCHCCF                                 FCCHCCF", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "FCCHCCF                                 FCCHCCF", " CCHCC                                   CCHCC ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", "   CCHCC                               CCHCC   ", "   CCHCC                               CCHCC   ", "    CCHCC                             CCHCC    ", "    CCHCC                             CCHCC    ", "     CCHCE                           ECHCC     ", "      ECHCC                         CCHCE      ", "       CCHCE                       ECHCC       ", "        CCHCCC                   CCCHCC        ", "         CCHCCCC               CCCCHCC         ", "          ECHHCCCCC FCCCCCF CCCCCHHCE          ", "           CCCHHCCCCC     CCCCCHHCCC           ", "            CCCCHHHCC     CCHHHCCCC            ", "              CCCCCHHHHHHHHHCCCCC              ", "                CCCCC     CCCCC                ", "                   CC     CC                   ", "                    FCCCCCF                    "};
        L3 = new String[]{"                    FCIBICF                    ", "                   CC     CC                   ", "                CCCHHHHHHHHHCCC                ", "              CCHHHHHHHHHHHHHHHCC              ", "            CCHHHHHHHHHHHHHHHHHHHCC            ", "           CHHHHHHHCC     CCHHHHHHHC           ", "          CHHHHHCCC FCIBICF CCCHHHHHC          ", "         CHHHHCC               CCHHHHC         ", "        CHHHCC                   CCHHHC        ", "       CHHHC                       CHHHC       ", "      CHHHC                         CHHHC      ", "     CHHHC                           CHHHC     ", "    CHHHC                             CHHHC    ", "    CHHHC                             CHHHC    ", "   CHHHC                               CHHHC   ", "   CHHHC                               CHHHC   ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", " CHHHC                                   CHHHC ", "FCHHHCF                                 FCHHHCF", "C HHH C                                 C HHH C", "I HHH I                                 I HHH I", "B HHH B                                 B HHH B", "I HHH I                                 I HHH I", "C HHH C                                 C HHH C", "FCHHHCF                                 FCHHHCF", " CHHHC                                   CHHHC ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", "   CHHHC                               CHHHC   ", "   CHHHC                               CHHHC   ", "    CHHHC                             CHHHC    ", "    CHHHC                             CHHHC    ", "     CHHHC                           CHHHC     ", "      CHHHC                         CHHHC      ", "       CHHHC                       CHHHC       ", "        CHHHCC                   CCHHHC        ", "         CHHHHCC               CCHHHHC         ", "          CHHHHHCCC FCI~ICF CCCHHHHHC          ", "           CHHHHHHHCC     CCHHHHHHHC           ", "            CCHHHHHHHHHHHHHHHHHHHCC            ", "              CCHHHHHHHHHHHHHHHCC              ", "                CCCHHHHHHHHHCCC                ", "                   CC     CC                   ", "                    FCIBICF                    "};
    }
}

