/*
 * Decompiled with CFR 0.152.
 */
package net.glease.structurecompat;

import com.gtnewhorizon.structurelib.IStructureCompat;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.glease.structurecompat.CommonProxy;
import net.glease.structurecompat.Compat;
import net.minecraft.util.IIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="structurecompat", version="0.5.1", name="StructureCompat", acceptedMinecraftVersions="[1.7.10]", dependencies="required-after:structurelib")
public class StructureCompat
implements IStructureCompat {
    public static final Logger LOG = LogManager.getLogger((String)"structurecompat");
    private List<String> compats;
    @SidedProxy(serverSide="net.glease.structurecompat.CommonProxy", clientSide="net.glease.structurecompat.ClientProxy")
    static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOG.debug("Starting to identify compats");
        ArrayList<String> list = new ArrayList<String>();
        for (ASMDataTable.ASMData d : event.getAsmData().getAll(Compat.class.getName())) {
            if (((List)d.getAnnotationInfo().get("value")).stream().allMatch(Loader::isModLoaded)) {
                LOG.debug("Compat {} will be loaded", new Object[]{d.getObjectName()});
                list.add(d.getObjectName());
                continue;
            }
            LOG.debug("Compat {} will not be loaded", new Object[]{d.getObjectName()});
        }
        this.compats = list;
        LOG.info("Identified {} compat(s) to load.", new Object[]{this.compats.size()});
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        int success = 0;
        for (String compat : this.compats) {
            LOG.debug("Activating compat {}", new Object[]{compat});
            try {
                Class.forName(compat).getConstructor(new Class[0]).newInstance(new Object[0]);
                ++success;
            }
            catch (InvocationTargetException e) {
                LOG.error("Compat activation errored!", e.getTargetException());
            }
            catch (ReflectiveOperationException e) {
                LOG.error("Cannot load compat!", (Throwable)e);
            }
        }
        LOG.info("Successfully activated {} compat(s).", new Object[]{success});
    }

    public void markTextureUsed(IIcon o) {
        proxy.markTextureUsed(o);
    }
}

