/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.items.wrench;

import aroma1997.core.items.AromicItem;
import aroma1997.core.items.CreativeTabAroma;
import aroma1997.core.items.wrench.IAromaWrenchable;
import aroma1997.core.items.wrench.ItemWrenched;
import aroma1997.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class ItemWrench
extends AromicItem {
    public ItemWrench() {
        this.func_77637_a(CreativeTabAroma.instance);
        this.func_77642_a(this);
        this.func_77625_d(1);
        this.setNameAndTexture("aroma1997core:hammer");
        if (OreDictionary.getOres((String)"nuggetIron") != null && OreDictionary.getOres((String)"nuggetIron").size() > 0) {
            this.setRecipe("IIN", " S ", " S ", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('N'), "nuggetIron", Character.valueOf('S'), "stickWood");
        } else {
            this.setRecipe("IIN", " S ", " S ", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('N'), "cobblestone", Character.valueOf('S'), "stickWood");
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        Block bl = world.func_147439_a(x, y, z);
        if (te == null || !(te instanceof IAromaWrenchable)) {
            if (!(te instanceof IAromaWrenchable) || bl == null || !(bl instanceof IAromaWrenchable)) {
                return false;
            }
            IAromaWrenchable block = (IAromaWrenchable)bl;
            if (player.func_70093_af() && block.canPickup(stack, player, ForgeDirection.values()[side])) {
                ItemStack item = new ItemStack(bl, 1, world.func_72805_g(x, y, z));
                WorldUtil.dropItemsRandom(world, item, x, y, z);
                world.func_147468_f(x, y, z);
                return true;
            }
            return block.onWrenchUsed(stack, player, ForgeDirection.values()[side]);
        }
        IAromaWrenchable w = (IAromaWrenchable)te;
        ForgeDirection dir = ForgeDirection.values()[side];
        if (player.func_70093_af() && w.canPickup(stack, player, dir)) {
            ItemStack item;
            if (w.shouldBeExact() == null) {
                item = ItemWrenched.generateItemFromTE(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), te);
                world.func_147475_p(x, y, z);
            } else {
                item = w.shouldBeExact();
                bl.func_149749_a(world, x, y, z, bl, side);
            }
            WorldUtil.dropItemsRandom(world, item, x, y, z);
            world.func_147475_p(x, y, z);
            world.func_147468_f(x, y, z);
            return true;
        }
        return w.onWrenchUsed(stack, player, dir);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity != null && entity instanceof IAromaWrenchable) {
            IAromaWrenchable wr = (IAromaWrenchable)entity;
            if (player.func_70093_af() && wr.canPickup(stack, player, ForgeDirection.UNKNOWN)) {
                ItemStack item = wr.shouldBeExact();
                if (item != null) {
                    entity.func_70106_y();
                    WorldUtil.dropItems(player.field_70170_p, item, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    return true;
                }
                return false;
            }
            return wr.onWrenchUsed(stack, player, ForgeDirection.UNKNOWN);
        }
        return false;
    }

    public static boolean hasPlayerWrench(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemWrench)) continue;
            return true;
        }
        return false;
    }
}

