/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.mixins;

import com.gtnewhorizons.gravisuiteneo.GraviSuiteNeo;
import com.gtnewhorizons.gravisuiteneo.client.SelectedItemMKII;
import com.gtnewhorizons.gravisuiteneo.common.PacketSortingPoints;
import gravisuite.Helpers;
import gravisuite.ItemRelocator;
import gravisuite.ServerProxy;
import gravisuite.client.GuiRelocatorDisplay;
import gravisuite.network.PacketManagePoints;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={GuiRelocatorDisplay.class})
public abstract class MixinGuiRelocatorDisplay
extends GuiContainer {
    @Unique
    private int pageOffset = 0;
    @Unique
    private int maxOffset = 0;
    @Unique
    private int clickHandled = 0;
    @Unique
    private String mouseDownPointName = null;
    @Unique
    private String sortablePointName = null;
    @Unique
    private static int pageXofYTextX = 23;
    @Unique
    private static int pageXofYTextY = 120;
    @Unique
    private static int prevButtonX = 117;
    @Unique
    private static int prevButtonY = 119;
    @Unique
    private static int nextButtonX = 136;
    @Unique
    private static int nextButtonY = 119;
    @Shadow(remap=false)
    private static ResourceLocation tex = new ResourceLocation("gravisuiteneo", "textures/gui/relocator_display2.png");
    @Shadow(remap=false)
    private int mouseX;
    @Shadow(remap=false)
    private int mouseY;
    @Shadow(remap=false)
    private int itemInterval;
    @Shadow(remap=false)
    private int firstItemX;
    @Shadow(remap=false)
    private int firstItemY;
    @Shadow(remap=false)
    private int cancelBtnX1;
    @Shadow(remap=false)
    private int firstSelX;
    @Shadow(remap=false)
    private int firstSelY;
    @Shadow(remap=false)
    private int selWidth;
    @Shadow(remap=false)
    private int firstItemBGX;
    @Shadow(remap=false)
    private int firstItemBGY;
    @Shadow(remap=false)
    private int itemBGinterval;
    @Shadow(remap=false)
    private int cancelBtnWidth;
    @Shadow(remap=false)
    private int openType;
    @Shadow(remap=false)
    private int itemBGX;
    @Shadow(remap=false)
    private int itemBGY;
    @Shadow(remap=false)
    private int itemBGWidth;
    @Shadow(remap=false)
    private int itemBGHeight;
    @Shadow(remap=false)
    private int itemBGdefX;
    @Shadow(remap=false)
    private int itemBGdefY;
    @Shadow(remap=false)
    private int itemBGselX;
    @Shadow(remap=false)
    private int itemBGselY;
    @Shadow(remap=false)
    private int itemBGdelX;
    @Shadow(remap=false)
    private int itemBGdelY;

    @Overwrite(remap=false)
    public GuiRelocatorDisplay.SelectedItem getSelected(List<ItemRelocator.TeleportPoint> tpList) {
        return null;
    }

    public SelectedItemMKII getSelectedMKII(List<ItemRelocator.TeleportPoint> tpList) {
        if (tpList == null || tpList.isEmpty()) {
            return null;
        }
        SelectedItemMKII tmpSel = new SelectedItemMKII();
        int itemsCount = tpList.size();
        if (this.func_146978_c(this.firstSelX, this.firstSelY + 1, this.selWidth, Math.min(this.itemInterval * 10 - 2, this.itemInterval * itemsCount - 2), this.mouseX, this.mouseY)) {
            int yStart = (this.field_146295_m - this.field_147000_g) / 2;
            int realMouseY = this.mouseY - yStart;
            double newCalc = (double)(realMouseY - this.firstSelY + 1) / (double)this.itemBGinterval;
            tmpSel.guiIDX = (int)Math.ceil(newCalc);
            tmpSel.offset = this.pageOffset;
            if (this.func_146978_c(this.cancelBtnX1, this.firstSelY + 1, this.cancelBtnWidth, Math.min(this.itemInterval * 10 - 1, this.itemInterval * itemsCount - 1), this.mouseX, this.mouseY)) {
                tmpSel.delFlag = true;
            }
            if (tpList.size() > tmpSel.getRealIDX()) {
                return tmpSel;
            }
        }
        return null;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int shift = Mouse.getEventDWheel();
        if (shift != 0) {
            int mousex = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mousey = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.mouseScrolled(mousex, mousey, shift > 0 ? 1 : -1);
        }
    }

    public void func_146286_b(int mousex, int mousey, int button) {
        if (button >= 0 && (this.clickHandled & 1 << button) != 0) {
            this.clickHandled &= ~(1 << button);
            this.mouseUp(mousex, mousey, button);
        } else {
            super.func_146286_b(mousex, mousey, button);
        }
    }

    @Overwrite
    public void func_73864_a(int mousex, int mousey, int button) {
        super.func_73864_a(mousex, mousey, button);
        this.onMouseDown(mousex, mousey, button);
        this.clickHandled |= 1 << button;
    }

    protected void onMouseDown(int mousex, int mousey, int button) {
        EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
        List tpList = ItemRelocator.loadTeleportPoints((ItemStack)player.field_71071_by.func_70448_g());
        SelectedItemMKII selectedItem = this.getSelectedMKII(tpList);
        if (selectedItem != null) {
            this.mouseDownPointName = ((ItemRelocator.TeleportPoint)tpList.get((int)selectedItem.getRealIDX())).pointName;
        }
    }

    public void mouseUp(int mousex, int mousey, int button) {
        this.mouseDownPointName = null;
        if (this.sortablePointName != null) {
            this.sortablePointName = null;
        } else if (this.func_146978_c(prevButtonX, prevButtonY, 9, 9, mousex, mousey)) {
            if (this.pageOffset > 0) {
                --this.pageOffset;
            }
        } else if (this.func_146978_c(nextButtonX, nextButtonY, 9, 9, mousex, mousey)) {
            if (this.pageOffset < this.maxOffset) {
                ++this.pageOffset;
            }
        } else {
            EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
            List tpList = ItemRelocator.loadTeleportPoints((ItemStack)player.field_71071_by.func_70448_g());
            if (tpList == null) {
                return;
            }
            SelectedItemMKII selectedItem = this.getSelectedMKII(tpList);
            if (selectedItem == null) {
                return;
            }
            int realIDX = selectedItem.getRealIDX();
            if (realIDX >= tpList.size()) {
                GraviSuiteNeo.LOGGER.error("WARNING: Caught IndexOutOfBounds while using Translocator");
                ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.relocator.text.invalid")));
                player.func_71053_j();
                return;
            }
            String tPointName = ((ItemRelocator.TeleportPoint)tpList.get((int)selectedItem.getRealIDX())).pointName;
            if (selectedItem.delFlag) {
                ItemRelocator.removeTeleportPoint((ItemStack)player.func_71045_bC(), (String)tPointName);
                PacketManagePoints.issue((EntityPlayer)player, (String)tPointName, (byte)0);
            } else {
                if (this.openType == 0) {
                    PacketManagePoints.issue((EntityPlayer)player, (String)tPointName, (byte)2);
                }
                if (this.openType == 1) {
                    PacketManagePoints.issue((EntityPlayer)player, (String)tPointName, (byte)3);
                }
                player.func_71053_j();
            }
        }
    }

    public void func_146273_a(int mousex, int mousey, int button, long heldTime) {
        int realIDX;
        EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
        List tpList = ItemRelocator.loadTeleportPoints((ItemStack)player.field_71071_by.func_70448_g());
        SelectedItemMKII selectedItem = this.getSelectedMKII(tpList);
        int n = realIDX = selectedItem != null ? selectedItem.getRealIDX() : -1;
        if (button != 0 || tpList == null || realIDX == -1 || this.mouseDownPointName == null) {
            super.func_146273_a(mousex, mousey, button, heldTime);
            return;
        }
        ItemRelocator.TeleportPoint point = (ItemRelocator.TeleportPoint)tpList.get(realIDX);
        if (!(this.sortablePointName != null || point.pointName.equalsIgnoreCase(this.mouseDownPointName) && heldTime <= 250L)) {
            this.sortablePointName = this.mouseDownPointName;
        } else if (this.sortablePointName != null && !point.pointName.equalsIgnoreCase(this.sortablePointName)) {
            PacketSortingPoints.movePoint((EntityPlayer)player, (byte)realIDX, this.sortablePointName);
            PacketSortingPoints.issue((EntityPlayer)player, (byte)realIDX, this.sortablePointName);
        } else {
            super.func_146273_a(mousex, mousey, button, heldTime);
        }
    }

    public void mouseScrolled(int mousex, int mousey, int shift) {
        if (this.func_146978_c(this.firstSelX, this.firstSelY + 1, this.selWidth, this.itemInterval * 10 - 2, mousex, mousey)) {
            if (shift > 0 && this.pageOffset > 0) {
                --this.pageOffset;
            } else if (shift < 0 && this.pageOffset < this.maxOffset) {
                ++this.pageOffset;
            }
        }
    }

    @Overwrite
    protected void func_146979_b(int x, int y) {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        try {
            List tpList = ItemRelocator.loadTeleportPoints((ItemStack)this.field_146297_k.field_71439_g.field_71071_by.func_70448_g());
            this.maxOffset = 0;
            if (tpList != null && !tpList.isEmpty()) {
                ItemRelocator.TeleportPoint tmpPoint;
                this.maxOffset = (int)Math.floor((tpList.size() - 1) / 10);
                SelectedItemMKII selectedItem = this.getSelectedMKII(tpList);
                int realIDX = selectedItem != null ? selectedItem.getRealIDX() : -2;
                for (int index = this.pageOffset * 10; index < (this.pageOffset + 1) * 10 && index < tpList.size(); ++index) {
                    tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(index);
                    int state = 0;
                    if (realIDX == index) {
                        state = selectedItem.delFlag ? 2 : 1;
                    }
                    this.drawItem(tmpPoint, index, state);
                }
                if (GameSettings.func_100015_a((KeyBinding)this.field_146297_k.field_71474_y.field_74311_E) && selectedItem != null) {
                    ArrayList<String> toolTipData = new ArrayList<String>();
                    tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(realIDX);
                    toolTipData.add(StatCollector.func_74838_a((String)"message.relocator.text.dim") + ": " + DimensionManager.getProvider((int)tmpPoint.dimID).func_80007_l());
                    toolTipData.add("X: " + (int)tmpPoint.x);
                    toolTipData.add("Y: " + (int)tmpPoint.y);
                    toolTipData.add("Z: " + (int)tmpPoint.z);
                    int realMouseX = this.mouseX - xStart;
                    int realMouseY = this.mouseY - yStart;
                    Helpers.renderTooltip((int)(realMouseX - 2), (int)realMouseY, toolTipData);
                }
            }
        }
        catch (Exception e) {
            GraviSuiteNeo.LOGGER.error("GuiRelocatorDisplay#drawGuiContainerForegroundLayer failed!", (Throwable)e);
        }
    }

    @Overwrite
    protected void func_146976_a(float opacity, int x, int y) {
        try {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(tex);
            int xStart = (this.field_146294_l - this.field_146999_f) / 2;
            int yStart = (this.field_146295_m - this.field_147000_g) / 2;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
            GL11.glDisable((int)3042);
            if (this.prevButtonAvailable()) {
                this.func_73729_b(xStart + prevButtonX, yStart + prevButtonY, 0, 182, 9, 9);
            } else {
                this.func_73729_b(xStart + prevButtonX, yStart + prevButtonY, 0, 192, 9, 9);
            }
            if (this.nextButtonAvailable()) {
                this.func_73729_b(xStart + nextButtonX, yStart + nextButtonY, 17, 182, 9, 9);
            } else {
                this.func_73729_b(xStart + nextButtonX, yStart + nextButtonY, 17, 192, 9, 9);
            }
            this.field_146289_q.func_78276_b(String.format("%d / %d", this.pageOffset + 1, this.maxOffset + 1), xStart + pageXofYTextX, yStart + pageXofYTextY, 0xFFFFFF);
        }
        catch (Exception e) {
            GraviSuiteNeo.LOGGER.error("GuiRelocatorDisplay#drawGuiContainerBackgroundLayer failed!", (Throwable)e);
        }
    }

    private void drawItem(ItemRelocator.TeleportPoint tmpPoint, int index, int state) {
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        if (state == 1) {
            this.func_73729_b(this.firstItemBGX, this.firstItemBGY + (index - this.pageOffset * 10) * this.itemInterval, this.itemBGselX, this.itemBGselY, this.itemBGWidth, this.itemBGHeight);
        } else if (state == 2) {
            this.func_73729_b(this.firstItemBGX, this.firstItemBGY + (index - this.pageOffset * 10) * this.itemInterval, this.itemBGdelX, this.itemBGdelY, this.itemBGWidth, this.itemBGHeight);
        } else if (tmpPoint.defPoint) {
            this.func_73729_b(this.firstItemBGX, this.firstItemBGY + (index - this.pageOffset * 10) * this.itemInterval, this.itemBGdefX, this.itemBGdefY, this.itemBGWidth, this.itemBGHeight);
        } else {
            this.func_73729_b(this.firstItemBGX, this.firstItemBGY + (index - this.pageOffset * 10) * this.itemInterval, this.itemBGX, this.itemBGY, this.itemBGWidth, this.itemBGHeight);
        }
        this.field_146289_q.func_78276_b(tmpPoint.pointName, this.firstItemX, this.firstItemY + (index - this.pageOffset * 10) * this.itemInterval, 0xFFFFFF);
    }

    @Unique
    private boolean prevButtonAvailable() {
        return this.pageOffset > 0;
    }

    @Unique
    private boolean nextButtonAvailable() {
        return this.pageOffset < this.maxOffset;
    }

    private MixinGuiRelocatorDisplay(Container p_i1072_1_) {
        super(p_i1072_1_);
    }
}

