/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import shedar.mods.ic2.nuclearcontrol.containers.ContainerRangeTrigger;
import shedar.mods.ic2.nuclearcontrol.gui.controls.CompactButton;
import shedar.mods.ic2.nuclearcontrol.gui.controls.GuiRangeTriggerInvertRedstone;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityRangeTrigger;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;

@SideOnly(value=Side.CLIENT)
public class GuiRangeTrigger
extends GuiContainer {
    private static final String TEXTURE_FILE = "nuclearcontrol:textures/gui/GUIRangeTrigger.png";
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("nuclearcontrol:textures/gui/GUIRangeTrigger.png");
    private String name;
    private ContainerRangeTrigger container;
    private ItemStack prevCard;

    public GuiRangeTrigger(Container container) {
        super(container);
        this.field_147000_g = 190;
        this.container = (ContainerRangeTrigger)container;
        this.name = StatCollector.func_74838_a((String)"tile.blockRangeTrigger.name");
    }

    private void initControls() {
        int i;
        ItemStack card = this.container.func_75139_a(0).func_75211_c();
        if (card != null && card.equals(this.prevCard)) {
            return;
        }
        this.field_146292_n.clear();
        this.prevCard = card;
        for (i = 0; i < 10; ++i) {
            this.field_146292_n.add(new CompactButton(i * 10, this.field_147003_i + 30 + i * 12 + (i + 2) / 3 * 6, this.field_147009_r + 20, 12, 12, "-"));
            this.field_146292_n.add(new CompactButton(i * 10 + 1, this.field_147003_i + 30 + i * 12 + (i + 2) / 3 * 6, this.field_147009_r + 42, 12, 12, "+"));
        }
        for (i = 0; i < 10; ++i) {
            this.field_146292_n.add(new CompactButton(100 + i * 10, this.field_147003_i + 30 + i * 12 + (i + 2) / 3 * 6, this.field_147009_r + 57, 12, 12, "-"));
            this.field_146292_n.add(new CompactButton(100 + i * 10 + 1, this.field_147003_i + 30 + i * 12 + (i + 2) / 3 * 6, this.field_147009_r + 79, 12, 12, "+"));
        }
        this.field_146292_n.add(new GuiRangeTriggerInvertRedstone(10, this.field_147003_i + 8, this.field_147009_r + 62, this.container.trigger));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initControls();
    }

    private void renderValue(double value, int x, int y) {
        x += 114;
        for (int i = 0; i < 10; ++i) {
            byte digit = (byte)(value % 10.0);
            String str = Byte.toString(digit);
            this.field_146289_q.func_78276_b(str, x - 12 * i - this.field_146289_q.func_78263_a(str.charAt(0)) / 2 + (9 - i + 2) / 3 * 6, y, 0x404040);
            value /= 10.0;
        }
    }

    protected void func_146284_a(GuiButton button) {
        double initValue;
        int id = button.field_146127_k;
        boolean isPlus = id % 2 == 1;
        int power = 9 - (id /= 10) % 10;
        boolean isEnd = (id /= 10) % 2 == 1;
        double newValue = initValue = isEnd ? this.container.trigger.levelEnd : this.container.trigger.levelStart;
        double delta = (long)Math.pow(10.0, power);
        double digit = initValue / delta % 10.0;
        if (isPlus && digit < 9.0) {
            newValue += delta;
        } else if (!isPlus && digit > 0.0) {
            newValue -= delta;
        }
        if (newValue != initValue) {
            TileEntityRangeTrigger trigger = this.container.trigger;
            NuclearNetworkHelper.setRangeTrigger(trigger.field_145851_c, trigger.field_145848_d, trigger.field_145849_e, newValue, isEnd);
            if (isEnd) {
                trigger.setLevelEnd(newValue);
            } else {
                trigger.setLevelStart(newValue);
            }
        }
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(this.name, (this.field_146999_f - this.field_146289_q.func_78256_a(this.name)) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.renderValue(this.container.trigger.levelStart, 30, 33);
        this.renderValue(this.container.trigger.levelEnd, 30, 70);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE_LOCATION);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

