/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.printer;

import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.client.printer.registry.PlacementData;
import com.github.lunatrius.schematica.client.printer.registry.PlacementRegistry;
import com.github.lunatrius.schematica.client.util.BlockToItemStack;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C0BPacketEntityAction;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;

public class SchematicPrinter {
    public static final SchematicPrinter INSTANCE = new SchematicPrinter();
    public static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private boolean isEnabled;
    private boolean isPrinting;
    private SchematicWorld schematic = null;
    private byte[][][] timeout = null;

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean togglePrinting() {
        this.isPrinting = !this.isPrinting;
        return this.isPrinting;
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public void setPrinting(boolean isPrinting) {
        this.isPrinting = isPrinting;
    }

    public SchematicWorld getSchematic() {
        return this.schematic;
    }

    public void setSchematic(SchematicWorld schematic) {
        this.isPrinting = false;
        this.schematic = schematic;
        this.refresh();
    }

    public void refresh() {
        this.timeout = (byte[][][])(this.schematic != null ? new byte[this.schematic.getWidth()][this.schematic.func_72800_K()][this.schematic.getLength()] : null);
    }

    public boolean print() {
        EntityClientPlayerMP player = this.minecraft.field_71439_g;
        WorldClient world = this.minecraft.field_71441_e;
        this.syncSneaking(player, true);
        Vector3i trans = ClientProxy.playerPosition.clone().sub((double)this.schematic.position.x, (double)this.schematic.position.y, (double)this.schematic.position.z).toVector3i();
        int minX = Math.max(0, trans.x - 3);
        int maxX = Math.min(this.schematic.getWidth(), trans.x + 4);
        int minY = Math.max(0, trans.y - 3);
        int maxY = Math.min(this.schematic.func_72800_K(), trans.y + 4);
        int minZ = Math.max(0, trans.z - 3);
        int maxZ = Math.min(this.schematic.getLength(), trans.z + 4);
        int slot = player.field_71071_by.field_70461_c;
        boolean isSneaking = player.func_70093_af();
        boolean isRenderingLayer = this.schematic.isRenderingLayer;
        int renderingLayer = this.schematic.renderingLayer;
        for (int y = minY; y < maxY; ++y) {
            if (isRenderingLayer && y != renderingLayer) continue;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    try {
                        if (!this.placeBlock((World)world, (EntityPlayer)player, x, y, z)) continue;
                        player.field_71071_by.field_70461_c = slot;
                        this.syncSneaking(player, isSneaking);
                        return true;
                    }
                    catch (Exception e) {
                        Reference.logger.error("Could not place block!", (Throwable)e);
                        player.field_71071_by.field_70461_c = slot;
                        this.syncSneaking(player, isSneaking);
                        return false;
                    }
                }
            }
        }
        player.field_71071_by.field_70461_c = slot;
        this.syncSneaking(player, isSneaking);
        return true;
    }

    private boolean placeBlock(World world, EntityPlayer player, int x, int y, int z) {
        if (this.timeout[x][y][z] > 0) {
            byte[] byArray = this.timeout[x][y];
            int n = z;
            byArray[n] = (byte)(byArray[n] - ConfigurationHandler.placeDelay);
            return false;
        }
        int wx = this.schematic.position.x + x;
        int wy = this.schematic.position.y + y;
        int wz = this.schematic.position.z + z;
        Block block = this.schematic.func_147439_a(x, y, z);
        Block realBlock = world.func_147439_a(wx, wy, wz);
        int metadata = this.schematic.func_72805_g(x, y, z);
        int realMetadata = world.func_72805_g(wx, wy, wz);
        if (block == realBlock && metadata == realMetadata) {
            return false;
        }
        if (ConfigurationHandler.destroyBlocks && !world.func_147437_c(wx, wy, wz) && this.minecraft.field_71442_b.func_78758_h()) {
            this.minecraft.field_71442_b.func_78743_b(wx, wy, wz, 0);
            this.timeout[x][y][z] = (byte)ConfigurationHandler.timeout;
            return !ConfigurationHandler.destroyInstantly;
        }
        if (this.schematic.func_147437_c(x, y, z)) {
            return false;
        }
        if (!realBlock.isReplaceable((IBlockAccess)world, wx, wy, wz)) {
            return false;
        }
        ItemStack itemStack = BlockToItemStack.getItemStack(player, block, this.schematic, x, y, z);
        if (itemStack == null || itemStack.func_77973_b() == null) {
            Reference.logger.debug("{} is missing a mapping!", new Object[]{BLOCK_REGISTRY.func_148750_c((Object)block)});
            return false;
        }
        if (this.placeBlock(world, player, wx, wy, wz, block, metadata, itemStack)) {
            this.timeout[x][y][z] = (byte)ConfigurationHandler.timeout;
            if (!ConfigurationHandler.placeInstantly) {
                return true;
            }
        }
        return false;
    }

    private boolean isSolid(World world, int x, int y, int z, ForgeDirection side) {
        Block block = world.func_147439_a(x += side.offsetX, y += side.offsetY, z += side.offsetZ);
        if (block == null) {
            return false;
        }
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (block instanceof BlockFluidBase) {
            return false;
        }
        return !block.isReplaceable((IBlockAccess)world, x, y, z);
    }

    private ForgeDirection[] getSolidSides(World world, int x, int y, int z) {
        ArrayList<ForgeDirection> list = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isSolid(world, x, y, z, side)) continue;
            list.add(side);
        }
        ForgeDirection[] sides = new ForgeDirection[list.size()];
        return list.toArray(sides);
    }

    private boolean placeBlock(World world, EntityPlayer player, int x, int y, int z, Block block, int metadata, ItemStack itemStack) {
        if (this.isBlacklisted(block, itemStack)) {
            return false;
        }
        PlacementData data = PlacementRegistry.INSTANCE.getPlacementData(block, itemStack);
        if (!this.isValidOrientation(player, x, y, z, data, metadata)) {
            return false;
        }
        ForgeDirection[] solidSides = this.getSolidSides(world, x, y, z);
        ForgeDirection direction = ForgeDirection.UNKNOWN;
        float offsetY = 0.0f;
        int extraClicks = 0;
        if (solidSides.length > 0) {
            if (data != null) {
                ForgeDirection[] validDirections = data.getValidDirections(solidSides, metadata);
                if (validDirections.length > 0) {
                    direction = validDirections[0];
                }
                offsetY = data.getOffsetFromMetadata(metadata);
                extraClicks = data.getExtraClicks(block, metadata);
            } else {
                direction = solidSides[0];
            }
            if (!this.swapToItem(player.field_71071_by, itemStack)) {
                return false;
            }
        }
        if (direction != ForgeDirection.UNKNOWN || !ConfigurationHandler.placeAdjacent) {
            return this.placeBlock(world, player, x, y, z, direction, 0.0f, offsetY, 0.0f, extraClicks);
        }
        return false;
    }

    private boolean isBlacklisted(Block block, ItemStack itemStack) {
        if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
            return true;
        }
        if (itemStack.func_77973_b() instanceof ItemBucket) {
            return true;
        }
        if (itemStack.func_77973_b() == Items.field_151155_ap) {
            return true;
        }
        return ClientProxy.lotrProxy.isBlackListed(block, itemStack) != false;
    }

    private boolean isValidOrientation(EntityPlayer player, int x, int y, int z, PlacementData data, int metadata) {
        if (data != null) {
            switch (data.type) {
                case BLOCK: {
                    return true;
                }
                case PLAYER: {
                    Integer integer = data.mapping.get(ClientProxy.orientation);
                    if (integer == null) break;
                    return integer == (metadata & data.maskMeta);
                }
                case PISTON: {
                    Integer integer = data.mapping.get(ClientProxy.orientation);
                    if (integer == null) break;
                    return BlockPistonBase.func_150071_a(null, (int)x, (int)y, (int)z, (EntityLivingBase)player) == BlockPistonBase.func_150076_b((int)metadata);
                }
            }
            return false;
        }
        return true;
    }

    private boolean placeBlock(World world, EntityPlayer player, int x, int y, int z, ForgeDirection direction, float offsetX, float offsetY, float offsetZ, int extraClicks) {
        ItemStack itemStack = player.func_71045_bC();
        if (!this.minecraft.field_71442_b.func_78758_h() && itemStack != null && itemStack.field_77994_a <= extraClicks) {
            return false;
        }
        int side = direction.getOpposite().ordinal();
        Vec3 hitVec = Vec3.func_72443_a((double)((float)(x += direction.offsetX) + offsetX), (double)((float)(y += direction.offsetY) + offsetY), (double)((float)(z += direction.offsetZ) + offsetZ));
        boolean success = this.placeBlock(world, player, itemStack, x, y, z, side, hitVec);
        for (int i = 0; success && i < extraClicks; ++i) {
            success = this.placeBlock(world, player, itemStack, x, y, z, side, hitVec);
        }
        if (itemStack != null && itemStack.field_77994_a == 0 && success) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
        }
        return success;
    }

    private boolean placeBlock(World world, EntityPlayer player, ItemStack itemStack, int x, int y, int z, int side, Vec3 hitVec) {
        boolean success;
        boolean bl = success = !ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)side, (World)world).isCanceled();
        if (success && (success = this.minecraft.field_71442_b.func_78760_a(player, world, itemStack, x, y, z, side, hitVec))) {
            player.func_71038_i();
        }
        return success;
    }

    private void syncSneaking(EntityClientPlayerMP player, boolean isSneaking) {
        player.func_70095_a(isSneaking);
        player.field_71174_a.func_147297_a((Packet)new C0BPacketEntityAction((Entity)player, isSneaking ? 1 : 2));
    }

    private boolean swapToItem(InventoryPlayer inventory, ItemStack itemStack) {
        return this.swapToItem(inventory, itemStack, true);
    }

    private boolean swapToItem(InventoryPlayer inventory, ItemStack itemStack, boolean swapSlots) {
        int slot = this.getInventorySlotWithItem(inventory, itemStack);
        if (this.minecraft.field_71442_b.func_78758_h() && (slot < 0 || slot >= 9) && !ConfigurationHandler.swapSlotsQueue.isEmpty()) {
            inventory.field_70461_c = this.getNextSlot();
            inventory.func_70299_a(inventory.field_70461_c, itemStack.func_77946_l());
            this.minecraft.field_71442_b.func_78761_a(inventory.func_70301_a(inventory.field_70461_c), 36 + inventory.field_70461_c);
            return true;
        }
        if (slot >= 0 && slot < 9) {
            inventory.field_70461_c = slot;
            return true;
        }
        if (swapSlots && slot >= 9 && slot < 36 && this.swapSlots(inventory, slot)) {
            return this.swapToItem(inventory, itemStack, false);
        }
        return false;
    }

    private int getInventorySlotWithItem(InventoryPlayer inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.field_70462_a.length; ++i) {
            if (inventory.field_70462_a[i] == null || !inventory.field_70462_a[i].func_77969_a(itemStack)) continue;
            return i;
        }
        return -1;
    }

    private boolean swapSlots(InventoryPlayer inventory, int from) {
        if (!ConfigurationHandler.swapSlotsQueue.isEmpty()) {
            int slot = this.getNextSlot();
            this.swapSlots(from, slot);
            return true;
        }
        return false;
    }

    private int getNextSlot() {
        int slot = ConfigurationHandler.swapSlotsQueue.poll() % 9;
        ConfigurationHandler.swapSlotsQueue.offer(slot);
        return slot;
    }

    private boolean swapSlots(int from, int to) {
        return this.minecraft.field_71442_b.func_78753_a(this.minecraft.field_71439_g.field_71069_bz.field_75152_c, from, to, 2, (EntityPlayer)this.minecraft.field_71439_g) == null;
    }
}

