/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.models;

import com.gtnewhorizons.angelica.models.GeometryHelper;
import com.gtnewhorizons.angelica.models.NdQuadBuilder;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class NormalHelper {
    private static final float PACK = 127.0f;
    private static final float UNPACK = 0.007874016f;

    public static void computeFaceNormal(@NotNull Vector3f saveTo, NdQuadBuilder q) {
        float normZ;
        float dx0;
        float dx1;
        float normY;
        float dy1;
        float dz0;
        ForgeDirection nominalFace = q.nominalFace();
        if (nominalFace != null && GeometryHelper.isQuadParallelToFace(nominalFace, q)) {
            Vector3i vec = DirectionUtil.STEP[nominalFace.ordinal()];
            saveTo.set((float)vec.x, (float)vec.y, (float)vec.z);
            return;
        }
        float x0 = q.getX(0);
        float y0 = q.getY(0);
        float z0 = q.getZ(0);
        float x1 = q.getX(1);
        float y1 = q.getY(1);
        float z1 = q.getZ(1);
        float x2 = q.getX(2);
        float y2 = q.getY(2);
        float z2 = q.getZ(2);
        float x3 = q.getX(3);
        float y3 = q.getY(3);
        float dy0 = y2 - y0;
        float z3 = q.getZ(3);
        float dz1 = z3 - z1;
        float normX = dy0 * dz1 - (dz0 = z2 - z0) * (dy1 = y3 - y1);
        float l = (float)Math.sqrt(normX * normX + (normY = dz0 * (dx1 = x3 - x1) - (dx0 = x2 - x0) * dz1) * normY + (normZ = dx0 * dy1 - dy0 * dx1) * normZ);
        if (l != 0.0f) {
            normX /= l;
            normY /= l;
            normZ /= l;
        }
        saveTo.set(normX, normY, normZ);
    }

    public static int packNormal(float x, float y, float z) {
        x = MathHelper.func_76131_a((float)x, (float)-1.0f, (float)1.0f);
        y = MathHelper.func_76131_a((float)y, (float)-1.0f, (float)1.0f);
        z = MathHelper.func_76131_a((float)z, (float)-1.0f, (float)1.0f);
        return (int)(x * 127.0f) & 0xFF | ((int)(y * 127.0f) & 0xFF) << 8 | ((int)(z * 127.0f) & 0xFF) << 16;
    }

    public static int packNormal(Vector3f normal) {
        return NormalHelper.packNormal(normal.x, normal.y, normal.z);
    }
}

