/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util;

import com.gtnewhorizons.angelica.compat.mojang.BlockPosImpl;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import org.joml.Vector3d;

public class WorldUtil {
    public static Vector3d getVelocity(IBlockAccess world, int x, int y, int z, Block thizz) {
        Vector3d velocity = new Vector3d();
        int decay = WorldUtil.getEffectiveFlowDecay(world, x, y, z, thizz);
        for (ForgeDirection dire : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            int adjX = x + dire.offsetX;
            int adjZ = z + dire.offsetZ;
            int adjDecay = WorldUtil.getEffectiveFlowDecay(world, adjX, y, adjZ, thizz);
            if (adjDecay < 0) {
                if (world.func_147439_a(adjX, y, adjZ).func_149688_o().func_76230_c() || (adjDecay = WorldUtil.getEffectiveFlowDecay(world, adjX, y - 1, adjZ, thizz)) < 0) continue;
                velocity = velocity.add((double)((adjX - x) * (adjDecay -= decay - 8)), 0.0, (double)((adjZ - z) * adjDecay));
                continue;
            }
            velocity = velocity.add((double)((adjX - x) * (adjDecay -= decay)), 0.0, (double)((adjZ - z) * adjDecay));
        }
        if (world.func_72805_g(x, y, z) >= 8 && (thizz.func_149747_d(world, x, y, z - 1, 2) || thizz.func_149747_d(world, x, y, z + 1, 3) || thizz.func_149747_d(world, x - 1, y, z, 4) || thizz.func_149747_d(world, x + 1, y, z, 5) || thizz.func_149747_d(world, x, y + 1, z - 1, 2) || thizz.func_149747_d(world, x, y + 1, z + 1, 3) || thizz.func_149747_d(world, x - 1, y + 1, z, 4) || thizz.func_149747_d(world, x + 1, y + 1, z, 5))) {
            velocity = velocity.normalize().add(0.0, -6.0, 0.0);
        }
        if (velocity.x == 0.0 && velocity.y == 0.0 && velocity.z == 0.0) {
            return velocity.zero();
        }
        return velocity.normalize();
    }

    public static boolean method_15756(IBlockAccess world, BlockPosImpl pos, Fluid fluid) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                Block block = world.func_147439_a(pos.x, pos.y, pos.z);
                if (block.func_149662_c() || WorldUtil.getFluid(block) == fluid) continue;
                return true;
            }
        }
        return false;
    }

    public static float getFluidHeight(Fluid fluid, int meta) {
        return fluid == null ? 0.0f : 1.0f - BlockLiquid.func_149801_b((int)meta);
    }

    public static int getEffectiveFlowDecay(IBlockAccess world, int x, int y, int z, Block thiz) {
        if (world.func_147439_a(x, y, z).func_149688_o() != thiz.func_149688_o()) {
            return -1;
        }
        int decay = world.func_72805_g(x, y, z);
        return decay >= 8 ? 0 : decay;
    }

    public static boolean shouldDisplayFluidOverlay(Block block) {
        return !block.func_149688_o().func_76218_k() || block.func_149688_o() == Material.field_151584_j;
    }

    public static Fluid getFluid(Block b) {
        return b instanceof IFluidBlock ? ((IFluidBlock)b).getFluid() : null;
    }

    public static boolean isEmptyOrSame(Fluid fluid, Fluid otherFluid) {
        return otherFluid == null || fluid == otherFluid;
    }

    public static boolean method_15749(IBlockAccess world, Fluid thiz, BlockPosImpl pos, ForgeDirection dir) {
        Block b = world.func_147439_a(pos.x, pos.y, pos.z);
        Fluid f = WorldUtil.getFluid(b);
        if (f == thiz) {
            return false;
        }
        if (dir == ForgeDirection.UP) {
            return true;
        }
        return b.func_149688_o() != Material.field_151588_w && b.isSideSolid(world, pos.x, pos.y, pos.z, dir);
    }
}

