/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.recipe;

import codechicken.nei.PositionedStack;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.GT_NEI_DefaultHandler;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.GregtechMetaTileEntityTreeFarm;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TGSFrontend
extends RecipeMapFrontend {
    private static final int SLOT_SIZE = 18;
    private static final int CENTER_X = 90;
    private static final int SPECIAL_X = 81;
    private static final int SPECIAL_Y = 9;
    private static final int INPUTS_X = 36;
    private static final int INPUTS_Y = 36;
    private static final int OUTPUTS_X = 108;
    private static final int OUTPUTS_Y = 36;
    private static final String[] tooltipInputs = new String[]{StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.saw"), StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.cutter"), StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.shears"), StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.knife")};
    private static final String[] tooltipOutputs = new String[]{StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.needsSaw"), StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.needsCutter"), StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.needsShears"), StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.needsKnife")};
    private static final String tooltipSapling = StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.sapling");
    private static final String tooltipMultiplier = StatCollector.func_74838_a((String)"gtpp.nei.tgs.tooltip.multiplier");

    public TGSFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder.addNEITransferRect(new Rectangle(72, 45, 36, 18)).progressBarPos(new Pos2d(80, 45)), neiPropertiesBuilder.neiSpecialInfoFormatter((INEISpecialInfoFormatter)new TGSSpecialValueFormatter()));
    }

    protected void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
    }

    public Pos2d getSpecialItemPosition() {
        return new Pos2d(81, 9);
    }

    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return UIHelper.getGridPositions((int)GregtechMetaTileEntityTreeFarm.Mode.values().length, (int)36, (int)36, (int)2);
    }

    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return UIHelper.getGridPositions((int)GregtechMetaTileEntityTreeFarm.Mode.values().length, (int)108, (int)36, (int)2);
    }

    public List<String> handleNEIItemTooltip(ItemStack stack, List<String> currentTip, GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
        int mode;
        if (stack == ((PositionedStack)neiCachedRecipe.mInputs.get((int)(neiCachedRecipe.mInputs.size() - 1))).item) {
            currentTip.add(EnumChatFormatting.YELLOW + tooltipSapling);
            super.handleNEIItemTooltip(stack, currentTip, neiCachedRecipe);
            return currentTip;
        }
        GT_Recipe.GT_Recipe_WithAlt recipe = (GT_Recipe.GT_Recipe_WithAlt)neiCachedRecipe.mRecipe;
        int slot = 0;
        for (mode = 0; mode < GregtechMetaTileEntityTreeFarm.Mode.values().length; ++mode) {
            if (mode >= recipe.mOreDictAlt.length || recipe.mOreDictAlt[mode] == null) continue;
            if (slot < neiCachedRecipe.mInputs.size() && stack == ((PositionedStack)neiCachedRecipe.mInputs.get((int)slot)).item) {
                int toolMultiplier = GregtechMetaTileEntityTreeFarm.getToolMultiplier(stack, GregtechMetaTileEntityTreeFarm.Mode.values()[mode]);
                currentTip.add(EnumChatFormatting.YELLOW + tooltipInputs[mode]);
                if (toolMultiplier > 0) {
                    currentTip.add(EnumChatFormatting.YELLOW + tooltipMultiplier + " " + toolMultiplier + "x");
                }
                return currentTip;
            }
            ++slot;
        }
        slot = 0;
        for (mode = 0; mode < GregtechMetaTileEntityTreeFarm.Mode.values().length; ++mode) {
            if (mode >= recipe.mOutputs.length || recipe.mOutputs[mode] == null) continue;
            if (slot < neiCachedRecipe.mOutputs.size() && stack == ((PositionedStack)neiCachedRecipe.mOutputs.get((int)slot)).item) {
                currentTip.add(EnumChatFormatting.YELLOW + tooltipOutputs[mode]);
                return currentTip;
            }
            ++slot;
        }
        return currentTip;
    }

    private static class TGSSpecialValueFormatter
    implements INEISpecialInfoFormatter {
        private TGSSpecialValueFormatter() {
        }

        public List<String> format(RecipeDisplayInfo recipeInfo) {
            return Arrays.asList(StatCollector.func_74838_a((String)"gtpp.nei.tgs.info-1"), StatCollector.func_74838_a((String)"gtpp.nei.tgs.info-2"), StatCollector.func_74838_a((String)"gtpp.nei.tgs.info-3"));
        }
    }
}

