/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util;

import cpw.mods.fml.common.FMLCommonHandler;
import gregtech.api.GregTech_API;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.resources.ItemCell;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.EnumUtils;

public class Utils {
    private static short cellID = (short)15;

    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static TC_Aspects.TC_AspectStack getTcAspectStack(TC_Aspects aspect, long size) {
        return Utils.getTcAspectStack(aspect.name(), (int)size);
    }

    public static TC_Aspects.TC_AspectStack getTcAspectStack(String aspect, long size) {
        return Utils.getTcAspectStack(aspect, (int)size);
    }

    public static TC_Aspects.TC_AspectStack getTcAspectStack(TC_Aspects aspect, int size) {
        return Utils.getTcAspectStack(aspect.name(), size);
    }

    public static TC_Aspects.TC_AspectStack getTcAspectStack(String aspect, int size) {
        TC_Aspects.TC_AspectStack returnValue;
        block15: {
            returnValue = null;
            if (aspect.equalsIgnoreCase("COGNITIO")) {
                try {
                    if (EnumUtils.isValidEnum(TC_Aspects.class, (String)"COGNITIO")) {
                        Logger.WARNING("TC Aspect found - " + aspect);
                        returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"COGNITIO"), (long)size);
                        break block15;
                    }
                    Logger.INFO("Fallback TC Aspect found - " + aspect + " - PLEASE UPDATE GREGTECH TO A NEWER VERSION TO REMOVE THIS MESSAGE - THIS IS NOT AN ERROR");
                    returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"COGNITO"), (long)size);
                }
                catch (NoSuchFieldError r) {
                    Logger.INFO("Invalid Thaumcraft Aspects - Report this issue to Alkalus");
                }
            } else if (aspect.equalsIgnoreCase("EXANIMUS")) {
                try {
                    if (EnumUtils.isValidEnum(TC_Aspects.class, (String)"EXANIMUS")) {
                        Logger.WARNING("TC Aspect found - " + aspect);
                        returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"EXANIMUS"), (long)size);
                        break block15;
                    }
                    Logger.INFO("Fallback TC Aspect found - " + aspect + " - PLEASE UPDATE GREGTECH TO A NEWER VERSION TO REMOVE THIS MESSAGE - THIS IS NOT AN ERROR");
                    returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"EXAMINIS"), (long)size);
                }
                catch (NoSuchFieldError r) {
                    Logger.INFO("Invalid Thaumcraft Aspects - Report this issue to Alkalus");
                }
            } else if (aspect.equalsIgnoreCase("PRAECANTATIO")) {
                try {
                    if (EnumUtils.isValidEnum(TC_Aspects.class, (String)"PRAECANTATIO")) {
                        Logger.WARNING("TC Aspect found - " + aspect);
                        returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"PRAECANTATIO"), (long)size);
                        break block15;
                    }
                    Logger.INFO("Fallback TC Aspect found - " + aspect + " - PLEASE UPDATE GREGTECH TO A NEWER VERSION TO REMOVE THIS MESSAGE - THIS IS NOT AN ERROR");
                    returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"PRAECANTIO"), (long)size);
                }
                catch (NoSuchFieldError r) {
                    Logger.INFO("Invalid Thaumcraft Aspects - Report this issue to Alkalus");
                }
            } else {
                Logger.WARNING("TC Aspect found - " + aspect);
                returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)aspect), (long)size);
            }
        }
        return returnValue;
    }

    public static void registerEvent(Object o) {
        MinecraftForge.EVENT_BUS.register(o);
        FMLCommonHandler.instance().bus().register(o);
    }

    public static void sendServerMessage(String translationKey) {
        Utils.sendServerMessage((IChatComponent)new ChatComponentText(translationKey));
    }

    public static void sendServerMessage(IChatComponent chatComponent) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a(chatComponent);
    }

    public static boolean isIC2Steam(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(Utils.getIC2Steam(1L));
    }

    public static FluidStack getIC2Steam(long aAmount) {
        return FluidRegistry.getFluidStack((String)"ic2steam", (int)((int)aAmount));
    }

    public static int rgbtoHexValue(int r, int g, int b) {
        if (r > 255 || g > 255 || b > 255 || r < 0 || g < 0 || b < 0) {
            return 0;
        }
        Color c = new Color(r, g, b);
        String temp = Integer.toHexString(c.getRGB() & 0xFFFFFF).toUpperCase();
        temp = Utils.appenedHexNotationToString(temp);
        return Integer.decode(temp);
    }

    public static String padWithZerosLefts(String originalString, int length) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() + originalString.length() < length) {
            sb.append('0');
        }
        sb.append(originalString);
        return sb.toString();
    }

    public static Map<Integer, String> hexColourGeneratorRandom(int colorCount) {
        HashMap<Integer, String> hexColorMap = new HashMap<Integer, String>();
        for (int a = 0; a < colorCount; ++a) {
            String code = "" + (int)(Math.random() * 256.0);
            code = code + code + code;
            int i = Integer.parseInt(code);
            hexColorMap.put(a, Integer.toHexString(0x1000000 | i).substring(1).toUpperCase());
            Logger.WARNING("" + Integer.toHexString(0x1000000 | i).substring(1).toUpperCase());
        }
        return hexColorMap;
    }

    public static String appenedHexNotationToString(Object hexAsStringOrInt) {
        String hexChar = "0x";
        if (hexAsStringOrInt.getClass() == String.class) {
            if (((String)hexAsStringOrInt).length() != 6) {
                String string = Utils.padWithZerosLefts((String)hexAsStringOrInt, 6);
            }
            String result = "0x" + hexAsStringOrInt;
            return result;
        }
        if (hexAsStringOrInt.getClass() == Integer.class) {
            String aa = String.valueOf(hexAsStringOrInt);
            String result = aa.length() != 6 ? Utils.padWithZerosLefts(aa, 6) : "0x" + hexAsStringOrInt;
            return result;
        }
        return null;
    }

    public static File getMcDir() {
        if (Utils.isClient() && Minecraft.func_71410_x() != null) {
            return Minecraft.func_71410_x().field_71412_D;
        }
        return new File(".");
    }

    public static ItemStack createInternalNameAndFluidCell(String s) {
        Logger.WARNING("1");
        InternalName yourName = (InternalName)EnumHelper.addEnum(InternalName.class, (String)s, (Class[])new Class[0], (Object[])new Object[0]);
        Logger.WARNING("2 " + yourName.name());
        ItemCell item = (ItemCell)Ic2Items.cell.func_77973_b();
        Logger.WARNING("3 " + item.func_77658_a());
        try {
            Logger.WARNING("4");
            Class<?> clz = item.getClass();
            Logger.WARNING("5 " + clz.getSimpleName());
            Method methode = clz.getDeclaredMethod("addCell", Integer.TYPE, InternalName.class, Block[].class);
            Logger.WARNING("6 " + methode.getName());
            methode.setAccessible(true);
            Logger.WARNING("7 " + methode.isAccessible());
            Object[] objectArray = new Object[3];
            short s2 = cellID;
            cellID = (short)(s2 + 1);
            objectArray[0] = s2;
            objectArray[1] = yourName;
            objectArray[2] = new Block[0];
            ItemStack temp = (ItemStack)methode.invoke((Object)item, objectArray);
            Logger.WARNING("Successfully created " + temp.func_82833_r() + "s.");
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidUtils.getFluidStack(s.toLowerCase(), 1000), (ItemStack)temp.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
            ItemUtils.addItemToOreDictionary(temp.func_77946_l(), "cell" + s);
            return temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sanitizeString(String input, char[] dontRemove) {
        HashSet toRemoveSet = new HashSet();
        Collections.addAll(toRemoveSet, Character.valueOf(' '), Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('?'), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'));
        for (char e : dontRemove) {
            toRemoveSet.remove(Character.valueOf(e));
        }
        StringBuilder sanitized = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (toRemoveSet.contains(Character.valueOf(c))) continue;
            sanitized.append(c);
        }
        return sanitized.toString();
    }

    public static String sanitizeString(String input) {
        String temp = input.replace(" ", "");
        temp = temp.replace("-", "");
        temp = temp.replace("_", "");
        temp = temp.replace("?", "");
        temp = temp.replace("!", "");
        temp = temp.replace("@", "");
        temp = temp.replace("#", "");
        temp = temp.replace("(", "");
        temp = temp.replace(")", "");
        temp = temp.replace("{", "");
        temp = temp.replace("}", "");
        temp = temp.replace("[", "");
        temp = temp.replace("]", "");
        String output = temp = temp.replace(" ", "");
        return output;
    }

    public static String sanitizeStringKeepBrackets(String input) {
        String temp = input.replace(" ", "");
        temp = temp.replace("-", "");
        temp = temp.replace("_", "");
        temp = temp.replace("?", "");
        temp = temp.replace("!", "");
        temp = temp.replace("@", "");
        temp = temp.replace("#", "");
        String output = temp = temp.replace(" ", "");
        return output;
    }

    public static String addBookTitleLocalization(String aTitle) {
        return GT_LanguageManager.addStringLocalization((String)("Book." + aTitle + ".Name"), (String)aTitle, (!GregTech_API.sPostloadFinished ? 1 : 0) != 0);
    }

    public static String[] addBookPagesLocalization(String aTitle, String[] aPages) {
        String[] aLocalizationPages = new String[aPages.length];
        for (byte i = 0; i < aPages.length; i = (byte)(i + 1)) {
            aLocalizationPages[i] = GT_LanguageManager.addStringLocalization((String)("Book." + aTitle + ".Page" + (i < 10 ? "0" + i : Byte.valueOf(i))), (String)aPages[i], (!GregTech_API.sPostloadFinished ? 1 : 0) != 0);
        }
        return aLocalizationPages;
    }

    public static ItemStack getWrittenBook(ItemStack book, int ID, String mapping, String title, String author, String[] pages) {
        if (GT_Utility.isStringInvalid((Object)mapping)) {
            return null;
        }
        ItemStack stack = CORE.sBookList.get(mapping);
        if (stack != null) {
            return GT_Utility.copyAmount((long)1L, (ItemStack)stack);
        }
        if (GT_Utility.isStringInvalid((Object)title) || GT_Utility.isStringInvalid((Object)author) || pages.length <= 0) {
            return null;
        }
        stack = book == null ? new ItemStack(ModItems.itemCustomBook, 1, ID) : book;
        NBTTagCompound NBT2 = new NBTTagCompound();
        String localizationTitle = Utils.addBookTitleLocalization(title);
        NBT2.func_74778_a("title", localizationTitle);
        NBT2.func_74778_a("author", author);
        NBTTagList NBTList = new NBTTagList();
        String[] localizationPages = Utils.addBookPagesLocalization(title, pages);
        for (int i = 0; i < pages.length; i = (int)((byte)(i + 1))) {
            pages[i] = localizationPages[i].replaceAll("<BR>", "\n");
            if (i < 48) {
                if (pages[i].length() < 256) {
                    NBTList.func_74742_a((NBTBase)new NBTTagString(pages[i]));
                    continue;
                }
                Logger.INFO("WARNING: String for written Book too long! -> " + pages[i]);
                GT_Log.err.println("WARNING: String for written Book too long! -> " + pages[i]);
                continue;
            }
            Logger.INFO("WARNING: Too much Pages for written Book! -> " + title);
            GT_Log.err.println("WARNING: Too much Pages for written Book! -> " + title);
            break;
        }
        String credits = String.format("Credits to %s for writing this Book. This was Book Nr. %d at its creation. Gotta get 'em all!", author, ID);
        NBTList.func_74742_a((NBTBase)new NBTTagString(credits));
        NBT2.func_74782_a("pages", (NBTBase)NBTList);
        stack.func_77982_d(NBT2);
        String logMessage = String.format("GT++_Mod: Added Book to Book++ List  -  Mapping: '%s'  -  Name: '%s'  -  Author: '%s'", mapping, title, author);
        GT_Log.out.println(logMessage);
        NBTUtils.createIntegerTagCompound(stack, "stats", "mMeta", ID);
        CORE.sBookList.put(mapping, stack);
        Logger.INFO(String.format("Creating book: %s by %s. Using Meta %d.", title, author, ID));
        return GT_Utility.copy((ItemStack)stack);
    }
}

