/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.fixes.vanilla;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gtPlusPlus.api.interfaces.IPlugin;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.plugin.fixes.interfaces.IBugFix;
import gtPlusPlus.preloader.CORE_Preloader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;

public class VanillaBedHeightFix
implements IBugFix {
    private final Method mSleepInBedAt;
    private final IPlugin mParent;

    public VanillaBedHeightFix(IPlugin minstance) {
        this.mParent = minstance;
        Method m = !CORE_Preloader.DEV_ENVIRONMENT ? ReflectionUtils.getMethod(EntityPlayer.class, "func_71018_a", Integer.TYPE, Integer.TYPE, Integer.TYPE) : ReflectionUtils.getMethod(EntityPlayer.class, "sleepInBedAt", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        if (m != null) {
            this.mSleepInBedAt = m;
            this.mParent.log("Registering Bed Height Fix.");
            Utils.registerEvent(this);
        } else {
            this.mSleepInBedAt = null;
        }
    }

    @Override
    public boolean isFixValid() {
        return this.mSleepInBedAt != null;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerSleepInBed(PlayerSleepInBedEvent evt) {
        Logger.WARNING("Sleep Event Detected. Player is sleeping at Y: " + evt.y);
        if (evt.y <= 0 && this.isFixValid()) {
            int correctY = 256 + evt.y;
            if (correctY <= 0) {
                Logger.WARNING("You're trying to sleep at y=" + evt.y + ", which is impossibly low. However, fixed y value is " + correctY + ", which is still below 0. Falling back to default behavior.");
            } else {
                Logger.WARNING("You're trying to sleep at y=" + evt.y + ". This is probably caused by overflow, stopping original event; retrying with y=" + correctY + ".");
                evt.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
                try {
                    this.mSleepInBedAt.invoke((Object)evt.entityPlayer, evt.x, correctY, evt.z);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Logger.WARNING("Encountered an error trying to sleep.");
                }
            }
        } else if (!this.isFixValid()) {
            Logger.WARNING("Method sleepInBedAt was not found in EntityPlayer (wrong MC and/or Forge version?), unable to fix");
        }
    }
}

