/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.generators;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.math.MathUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class GregtechMetaBoilerBase
extends GT_MetaTileEntity_BasicTank {
    public int mTemperature = 20;
    public int mProcessingEnergy = 0;
    public int mLossTimer = 0;
    public FluidStack mSteam = null;
    public boolean mHadNoWater = false;
    public long RI = MathUtils.randLong(5L, 30L);

    public GregtechMetaBoilerBase(int aID, String aName, String aNameRegional, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, 0, 4, aDescription, aTextures);
    }

    public GregtechMetaBoilerBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] tmp = this.mTextures[side.offsetY == 0 ? (byte)(side != facing ? 2 : (byte)(aActive ? 4 : 3)) : side.ordinal()][aColorIndex + 1];
        if (side != facing && tmp.length == 2) {
            tmp = new ITexture[]{tmp[0]};
        }
        return tmp;
    }

    public boolean isElectric() {
        return false;
    }

    public boolean isPneumatic() {
        return false;
    }

    public boolean isSteampowered() {
        return false;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return facing.offsetY == 0;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public int getProgresstime() {
        return this.mTemperature;
    }

    public int maxProgresstime() {
        return 500;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (aPlayer != null) {
            if (GT_Utility.areStacksEqual((ItemStack)aPlayer.func_71045_bC(), (ItemStack)new ItemStack(Items.field_151131_as, 1))) {
                this.fill(Materials.Water.getFluid((long)(1000 * aPlayer.func_71045_bC().field_77994_a)), true);
                aPlayer.func_71045_bC().func_150996_a(Items.field_151133_ar);
            } else {
                GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
            }
        }
        return true;
    }

    public boolean doesFillContainers() {
        return true;
    }

    public boolean doesEmptyContainers() {
        return true;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    public boolean displaysItemStack() {
        return false;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return GT_ModHandler.isWater((FluidStack)aFluid);
    }

    public FluidStack getDrainableStack() {
        return this.mSteam;
    }

    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mSteam = aFluid;
        return this.mSteam;
    }

    public boolean isDrainableStackSeparate() {
        return true;
    }

    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aCover) {
        return GregTech_API.getCoverBehaviorNew((ItemStack)aCover.toStack()).isSimpleCover();
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mLossTimer", this.mLossTimer);
        aNBT.func_74768_a("mTemperature", this.mTemperature);
        aNBT.func_74768_a("mProcessingEnergy", this.mProcessingEnergy);
        if (this.mSteam != null) {
            try {
                aNBT.func_74782_a("mSteam", (NBTBase)this.mSteam.writeToNBT(new NBTTagCompound()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mLossTimer = aNBT.func_74762_e("mLossTimer");
        this.mTemperature = aNBT.func_74762_e("mTemperature");
        this.mProcessingEnergy = aNBT.func_74762_e("mProcessingEnergy");
        this.mSteam = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mSteam"));
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick > 20L) {
            if (this.mTemperature <= 20) {
                this.mTemperature = 20;
                this.mLossTimer = 0;
            }
            if (++this.mLossTimer > 40) {
                --this.mTemperature;
                this.mLossTimer = 0;
            }
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                int tFilledAmount;
                FluidStack tDrained;
                IFluidHandler tTileEntity;
                if (side == aBaseMetaTileEntity.getFrontFacing() || (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(side)) == null || (tDrained = aBaseMetaTileEntity.drain(side, Math.max(1, this.mSteam.amount / 2), false)) == null || (tFilledAmount = tTileEntity.fill(side.getOpposite(), tDrained, false)) <= 0) continue;
                tTileEntity.fill(side.getOpposite(), aBaseMetaTileEntity.drain(side, tFilledAmount, true), true);
            }
            if (aTick % 10L == 0L) {
                if (this.mTemperature > 100) {
                    if (this.mFluid == null || !GT_ModHandler.isWater((FluidStack)this.mFluid) || this.mFluid.amount <= 0) {
                        this.mHadNoWater = true;
                    } else {
                        if (this.mHadNoWater) {
                            aBaseMetaTileEntity.doExplosion(2048L);
                            return;
                        }
                        --this.mFluid.amount;
                        if (this.mSteam == null) {
                            this.mSteam = GT_ModHandler.getSteam((long)150L);
                        } else if (GT_ModHandler.isSteam((FluidStack)this.mSteam)) {
                            this.mSteam.amount += 150;
                        } else {
                            this.mSteam = GT_ModHandler.getSteam((long)150L);
                        }
                    }
                } else {
                    this.mHadNoWater = false;
                }
            }
            if (this.mSteam != null && this.mSteam.amount > this.getSteamCapacity()) {
                this.sendSound((byte)1);
                this.mSteam.amount = this.getSteamCapacity() * 3 / 4;
            }
            if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork() && this.mInventory[2] != null) {
                if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)OrePrefixes.gem.get((Object)Materials.Coal)) || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)OrePrefixes.dust.get((Object)Materials.Coal)) || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)OrePrefixes.dustImpure.get((Object)Materials.Coal)) || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)OrePrefixes.crushed.get((Object)Materials.Coal))) {
                    this.mProcessingEnergy += 160;
                    aBaseMetaTileEntity.func_70298_a(2, 1);
                    if (aBaseMetaTileEntity.getRandomNumber(3) == 0) {
                        aBaseMetaTileEntity.addStackToSlot(3, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)1L));
                    }
                } else if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)OrePrefixes.gem.get((Object)Materials.Charcoal))) {
                    this.mProcessingEnergy += 160;
                    aBaseMetaTileEntity.func_70298_a(2, 1);
                    if (aBaseMetaTileEntity.getRandomNumber(3) == 0) {
                        aBaseMetaTileEntity.addStackToSlot(3, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Ash, (long)1L));
                    }
                } else if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)"fuelCoke")) {
                    this.mProcessingEnergy += 640;
                    aBaseMetaTileEntity.func_70298_a(2, 1);
                    if (aBaseMetaTileEntity.getRandomNumber(2) == 0) {
                        aBaseMetaTileEntity.addStackToSlot(3, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Ash, (long)1L));
                    }
                } else if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)OrePrefixes.gem.get((Object)Materials.Lignite)) || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)OrePrefixes.dust.get((Object)Materials.Lignite)) || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)OrePrefixes.dustImpure.get((Object)Materials.Lignite)) || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[2], (Object)OrePrefixes.crushed.get((Object)Materials.Lignite))) {
                    this.mProcessingEnergy += 40;
                    aBaseMetaTileEntity.func_70298_a(2, 1);
                    if (aBaseMetaTileEntity.getRandomNumber(8) == 0) {
                        aBaseMetaTileEntity.addStackToSlot(3, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)1L));
                    }
                }
            }
            if (this.mTemperature < 1000 && this.mProcessingEnergy > 0 && aTick % 12L == 0L) {
                this.mProcessingEnergy -= 2;
                ++this.mTemperature;
            }
            aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        return new FluidTankInfo[]{new FluidTankInfo(this.mFluid, this.getCapacity()), new FluidTankInfo(this.mSteam, this.getSteamCapacity())};
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex == 1 || aIndex == 3;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex == 2;
    }

    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient((SoundResource)SoundResource.RANDOM_FIZZ, (int)2, (float)1.0f, (double)aX, (double)aY, (double)aZ);
            for (int l = 0; l < 8; ++l) {
                this.getBaseMetaTileEntity().getWorld().func_72869_a("largesmoke", aX - 0.5 + Math.random(), aY, aZ - 0.5 + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getCapacity() {
        return 16000;
    }

    public int getSteamCapacity() {
        return 32000;
    }

    public int getTankPressure() {
        return 100;
    }
}

