/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.GregtechMetaTileEntity_LargerTurbineBase;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MTE_LargeTurbine_SCSteam
extends GregtechMetaTileEntity_LargerTurbineBase {
    public GT_MTE_LargeTurbine_SCSteam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MTE_LargeTurbine_SCSteam(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MTE_LargeTurbine_SCSteam(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 15;
    }

    @Override
    public int getCasingTextureIndex() {
        return 1538;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return true;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        return 0;
    }

    @Override
    long fluidIntoPower(ArrayList<FluidStack> aFluids, long aOptFlow, int aBaseEff, float[] flowMultipliers) {
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        this.realOptFlow = aOptFlow;
        int remainingFlow = MathUtils.safeInt((long)(this.realOptFlow * 1.25));
        this.storedFluid = 0;
        FluidStack tSCSteam = FluidRegistry.getFluidStack((String)"supercriticalsteam", (int)1);
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            if (!GT_Utility.areFluidsEqual((FluidStack)aFluids.get(i), (FluidStack)tSCSteam, (boolean)true)) continue;
            flow = Math.min(aFluids.get((int)i).amount, remainingFlow);
            this.depleteInput(new FluidStack(aFluids.get(i), flow));
            this.storedFluid += aFluids.get((int)i).amount;
            remainingFlow -= flow;
            totalFlow += flow;
        }
        if (totalFlow <= 0) {
            return 0L;
        }
        tEU = totalFlow;
        this.addOutput(GT_ModHandler.getSteam((long)totalFlow));
        if ((double)totalFlow != this.realOptFlow) {
            float efficiency = 1.0f - Math.abs(((float)totalFlow - (float)this.realOptFlow) / (float)this.realOptFlow);
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, MathUtils.safeInt((long)tEU * (long)aBaseEff / 10000L));
        } else {
            tEU = MathUtils.safeInt((long)tEU * (long)aBaseEff / 10000L);
        }
        return (long)tEU * 100L;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 8;
    }

    @Override
    public String getMachineType() {
        return "Large Supercritical Steam Turbine";
    }

    @Override
    protected String getTurbineType() {
        return "Supercritical Steam";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced SC Turbine Casing";
    }

    @Override
    protected ITexture getTextureFrontFace() {
        return TextureFactory.of((IIconContainer)TexturesGtBlock.Overlay_Machine_Controller_Advanced);
    }

    @Override
    protected ITexture getTextureFrontFaceActive() {
        return TextureFactory.of((IIconContainer)TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active);
    }
}

