/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.tiles.TileJarFillable;

public class TileBlockProtector
extends TileJarFillable {
    private static final int UPDATE_TICKS = 15;
    private static final int MAX_RANGE = 15;
    private static final Aspect ASPECT = Aspect.ORDER;
    private int range;
    private int saturation;
    private int count;
    private static List<TileBlockProtector> protectors = new ArrayList<TileBlockProtector>();

    public TileBlockProtector() {
        this.maxAmount = 8;
        this.aspectFilter = ASPECT;
    }

    public int getCurrentRange() {
        return this.range;
    }

    public int getPowerLevel() {
        return Math.min(this.field_145850_b.func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e), 15);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("ProtectSaturation", this.saturation);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.saturation = compound.func_74762_e("ProtectSaturation");
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.aspectFilter = ASPECT;
        int oldRange = this.range;
        this.range = compound.func_74762_e("ProtectRange");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && oldRange != this.range) {
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_82580_o("AspectFilter");
        compound.func_74768_a("ProtectRange", this.range);
    }

    public void func_145845_h() {
        if (!protectors.contains((Object)this)) {
            protectors.add(this);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (++this.count % 5 == 0 && this.amount < this.maxAmount) {
                this.fillJar();
            }
            if (this.count % 15 == 0) {
                boolean executeDecrease;
                if (this.range == 0) {
                    this.saturation = 0;
                }
                if (this.saturation > 0) {
                    --this.saturation;
                    return;
                }
                int powerLevel = this.getPowerLevel();
                boolean bl = executeDecrease = this.range > powerLevel;
                if (this.range <= powerLevel && powerLevel > 0) {
                    executeDecrease = true;
                    if (this.takeFromContainer(ASPECT, 1)) {
                        if (this.range < powerLevel) {
                            ++this.range;
                            this.func_70296_d();
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            this.saturation = 16 - this.range;
                        }
                        executeDecrease = false;
                    }
                }
                if (executeDecrease && this.range > 0) {
                    --this.range;
                    this.func_70296_d();
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        } else if (this.range > 0) {
            float sizeMod = 1.0f - (float)this.range / 15.0f;
            if (this.field_145850_b.field_73012_v.nextInt(9 - Thaumcraft.proxy.particleCount(2)) == 0) {
                Thaumcraft.proxy.wispFX3(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.68f), (double)((float)this.field_145849_e + 0.5f), (double)((float)this.field_145851_c + 0.3f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f), (double)((float)this.field_145848_d + 0.68f), (double)((float)this.field_145849_e + 0.3f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f), 0.3f - 0.15f * sizeMod, 6, true, -0.025f);
            }
            if (this.field_145850_b.field_73012_v.nextInt(15 - Thaumcraft.proxy.particleCount(4)) == 0) {
                Thaumcraft.proxy.wispFX3(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.68f), (double)((float)this.field_145849_e + 0.5f), (double)((float)this.field_145851_c + 0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f), (double)((float)this.field_145848_d + 0.68f), (double)((float)this.field_145849_e + 0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f), 0.2f - 0.15f * sizeMod, 6, true, -0.02f);
            }
        }
        if (this.range > 0) {
            for (EntityLivingBase entity : this.field_145850_b.func_72872_a(EntityLivingBase.class, this.getProtectedAABB())) {
                if (entity instanceof EntityCreeper) {
                    ((EntityCreeper)entity).field_70833_d = 0;
                }
                if (!this.field_145850_b.field_72995_K || entity instanceof EntityPlayer) continue;
                this.spawnEntityParticles(entity);
            }
        }
    }

    private void spawnEntityParticles(EntityLivingBase entity) {
        AxisAlignedBB cube = entity.field_70121_D;
        if (cube != null && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
            double posX = this.field_145850_b.field_73012_v.nextDouble() * (cube.field_72336_d - cube.field_72340_a) + cube.field_72340_a;
            double posY = this.field_145850_b.field_73012_v.nextDouble() * (cube.field_72336_d - cube.field_72340_a) + cube.field_72338_b;
            double posZ = this.field_145850_b.field_73012_v.nextDouble() * (cube.field_72336_d - cube.field_72340_a) + cube.field_72339_c;
            switch (this.field_145850_b.field_73012_v.nextInt(5)) {
                case 0: {
                    posX = cube.field_72336_d;
                    break;
                }
                case 1: {
                    posY = cube.field_72337_e;
                    break;
                }
                case 2: {
                    posZ = cube.field_72334_f;
                    break;
                }
                case 3: {
                    posX = cube.field_72340_a;
                    break;
                }
                case 4: {
                    posZ = cube.field_72339_c;
                }
            }
            Thaumcraft.proxy.wispFX3(this.field_145850_b, posX, posY, posZ, posX + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f), posY, posZ + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f), 0.2f, 6, true, -0.02f);
        }
    }

    private void fillJar() {
        TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)ForgeDirection.DOWN);
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(ForgeDirection.UP)) {
                return;
            }
            Aspect ta = null;
            if (this.aspectFilter != null) {
                ta = this.aspectFilter;
            } else if (this.aspect != null && this.amount > 0) {
                ta = this.aspect;
            } else if (ic.getEssentiaAmount(ForgeDirection.UP) > 0 && ic.getSuctionAmount(ForgeDirection.UP) < this.getSuctionAmount(ForgeDirection.DOWN) && this.getSuctionAmount(ForgeDirection.DOWN) >= ic.getMinimumSuction()) {
                ta = ic.getEssentiaType(ForgeDirection.UP);
            }
            if (ta != null && ic.getSuctionAmount(ForgeDirection.UP) < this.getSuctionAmount(ForgeDirection.DOWN)) {
                this.addToContainer(ta, ic.takeEssentia(ta, 1, ForgeDirection.UP));
            }
        }
    }

    public int getMinimumSuction() {
        return super.getMinimumSuction() * 2;
    }

    public int getSuctionAmount(ForgeDirection loc) {
        return super.getSuctionAmount(loc) * 2;
    }

    public boolean isConnectable(ForgeDirection face) {
        return face == ForgeDirection.DOWN;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return face == ForgeDirection.DOWN;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public static boolean isSpotProtected(World world, final double x, final double y, final double z) {
        return TileBlockProtector.isSpotProtected(world, new ProtectionHelper(){

            @Override
            public boolean checkProtection(TileBlockProtector tile) {
                return TileBlockProtector.isSpotProtected(tile, x, y, z);
            }
        });
    }

    public static boolean isSpotProtected(World world, final Entity entity) {
        return TileBlockProtector.isSpotProtected(world, new ProtectionHelper(){

            @Override
            public boolean checkProtection(TileBlockProtector tile) {
                return TileBlockProtector.isSpotProtected(tile, entity);
            }
        });
    }

    public static boolean isSpotProtected(World world, ProtectionHelper helper) {
        for (int i = 0; i < protectors.size(); ++i) {
            TileBlockProtector protector = protectors.get(i);
            if (protector.func_145837_r()) {
                protectors.remove(i);
                --i;
                continue;
            }
            if (protector.field_145850_b.field_72995_K != world.field_72995_K || !helper.checkProtection(protector)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpotProtected(TileBlockProtector tile, Entity entity) {
        AxisAlignedBB entityAABB = entity.field_70121_D;
        if (entityAABB != null) {
            return tile.getProtectedAABB().func_72326_a(entityAABB.func_72321_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
        }
        return TileBlockProtector.isSpotProtected(tile, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    private AxisAlignedBB getProtectedAABB() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.range), (double)(this.field_145848_d - this.range), (double)(this.field_145849_e - this.range), (double)(this.field_145851_c + this.range), (double)(this.field_145848_d + this.range), (double)(this.field_145849_e + this.range));
    }

    private static boolean isSpotProtected(TileBlockProtector tile, double x, double y, double z) {
        return tile.getProtectedAABB().func_72318_a(Vec3.func_72443_a((double)x, (double)y, (double)z));
    }

    private static interface ProtectionHelper {
        public boolean checkProtection(TileBlockProtector var1);
    }
}

