/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils;

import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import makeo.gadomancy.api.GadomancyApi;
import makeo.gadomancy.api.golems.AdditionalGolemType;
import makeo.gadomancy.client.events.ResourceReloadListener;
import makeo.gadomancy.common.Gadomancy;
import makeo.gadomancy.common.entities.golems.types.RemovedGolemType;
import makeo.gadomancy.common.utils.Injector;
import net.minecraftforge.common.util.EnumHelper;
import thaumcraft.common.entities.golems.EnumGolemType;

public class GolemEnumHelper {
    private static final RemovedGolemType REMOVED_GOLEM_TYPE = new RemovedGolemType();
    private static final Injector INJECTOR = new Injector(EnumGolemType.class);
    private static final Injector ENUM_INJECTOR = new Injector(Enum.class);
    private static final Injector CLASS_INJECTOR = new Injector(Class.class);
    private static Field valuesField;
    private static final Class<?>[] ENUM_PARAMS;
    private static Field ordinalField;
    private static Map<String, Integer> defaultMapping;

    private static Field getValuesField() {
        if (valuesField == null) {
            for (Field field : EnumGolemType.class.getDeclaredFields()) {
                if (!field.getType().equals(EnumGolemType[].class)) continue;
                field.setAccessible(true);
                valuesField = field;
                return field;
            }
            throw new IllegalStateException("Couldn't find the values$ field of EnumGolemType");
        }
        return valuesField;
    }

    public static Field getOrdinalField() {
        if (ordinalField == null) {
            try {
                ordinalField = Enum.class.getDeclaredField("ordinal");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return ordinalField;
    }

    private static EnumGolemType createEnum(String name, int ordinal, AdditionalGolemType type) {
        GolemEnumHelper.resetEnumCache();
        return (EnumGolemType)INJECTOR.invokeUnsafeConstructor(ENUM_PARAMS, name, ordinal, type.maxHealth, type.armor, Float.valueOf(type.movementSpeed), type.fireResist, type.upgradeAmount, type.carryLimit, type.regenDelay, type.strength);
    }

    private static void resetEnumCache() {
        CLASS_INJECTOR.setObject(EnumGolemType.class);
        try {
            Field enumConstants = EnumGolemType.class.getClass().getDeclaredField("enumConstants");
            CLASS_INJECTOR.setField(enumConstants, null);
        }
        catch (Exception enumConstants) {
            // empty catch block
        }
        try {
            Field enumConstantDirectory = EnumGolemType.class.getClass().getDeclaredField("enumConstantDirectory");
            CLASS_INJECTOR.setField(enumConstantDirectory, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addEnum(int ordinal, EnumGolemType type) {
        EnumGolemType[] values = GolemEnumHelper.resizeValues(ordinal + 1);
        values[ordinal] = type;
        GolemEnumHelper.resetEnumCache();
    }

    private static EnumGolemType addEnum(String name, int ordinal, AdditionalGolemType type) {
        EnumGolemType enumEntry = GolemEnumHelper.createEnum(name, ordinal, type);
        GolemEnumHelper.addEnum(ordinal, enumEntry);
        type.setEnumEntry(enumEntry);
        GolemEnumHelper.resetEnumCache();
        return enumEntry;
    }

    private static EnumGolemType[] resizeValues(int size) {
        EnumGolemType[] values = (EnumGolemType[])INJECTOR.getField(GolemEnumHelper.getValuesField());
        if (size > values.length) {
            EnumGolemType[] newValues = new EnumGolemType[size];
            System.arraycopy(values, 0, newValues, 0, values.length);
            for (int i = values.length; i < newValues.length; ++i) {
                newValues[i] = GolemEnumHelper.createEnum("REMOVED", i, REMOVED_GOLEM_TYPE);
            }
            GolemEnumHelper.setValues(newValues);
            GolemEnumHelper.resetEnumCache();
            return newValues;
        }
        return values;
    }

    private static void setValues(EnumGolemType[] values) {
        try {
            EnumHelper.setFailsafeFieldValue((Field)GolemEnumHelper.getValuesField(), null, (Object)values);
            GolemEnumHelper.resetEnumCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static EnumGolemType addGolemType(String name, AdditionalGolemType type) {
        return GolemEnumHelper.addEnum(name, GolemEnumHelper.getOrdinal(name), type);
    }

    private static int getOrdinal(String name) {
        Map<String, Integer> map = GolemEnumHelper.getCurrentMapping();
        if (map.containsKey(name)) {
            return map.get(name);
        }
        int returnVal = -1;
        int i = GolemEnumHelper.calcDefaultGolemCount();
        do {
            boolean contains = false;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() != i) continue;
                contains = true;
            }
            if (!contains) {
                returnVal = i;
            }
            ++i;
        } while (returnVal < 0);
        map.put(name, returnVal);
        GolemEnumHelper.saveCurrentMapping(map);
        return returnVal;
    }

    public static void reorderEnum() {
        GolemEnumHelper.reorderEnum(GolemEnumHelper.getCurrentMapping());
    }

    public static void reorderEnum(Map<String, Integer> mapping) {
        EnumGolemType[] oldValues = EnumGolemType.values();
        GolemEnumHelper.resetEnum();
        for (Map.Entry<String, Integer> entry : mapping.entrySet()) {
            for (EnumGolemType type : oldValues) {
                if (!type.name().equals(entry.getKey())) continue;
                ENUM_INJECTOR.setObject(type);
                ENUM_INJECTOR.setFieldInt(GolemEnumHelper.getOrdinalField(), entry.getValue());
                GolemEnumHelper.addEnum(entry.getValue(), type);
            }
        }
        new Injector(EnumGolemType.class).setField("codeToTypeMapping", null);
        GolemEnumHelper.resetEnumCache();
        if (Gadomancy.proxy.getSide() == Side.CLIENT) {
            ResourceReloadListener.getInstance().reloadGolemResources();
        }
    }

    private static void resetEnum() {
        EnumGolemType[] newValues = Arrays.copyOfRange(EnumGolemType.values(), 0, GolemEnumHelper.calcDefaultGolemCount());
        GolemEnumHelper.setValues(newValues);
        GolemEnumHelper.resetEnumCache();
    }

    private static int calcDefaultGolemCount() {
        EnumGolemType[] values = EnumGolemType.values();
        for (int i = 0; i < values.length; ++i) {
            if (!GadomancyApi.isAdditionalGolemType(values[i])) continue;
            return i;
        }
        return values.length;
    }

    public static void validateSavedMapping() {
        if (GolemEnumHelper.hasCurrentMapping()) {
            Map<String, Integer> mapping = GolemEnumHelper.getCurrentMapping();
            for (Map.Entry<String, Integer> entry : defaultMapping.entrySet()) {
                if (mapping.containsKey(entry.getKey())) continue;
                mapping.put(entry.getKey(), GolemEnumHelper.getOrdinal(entry.getKey()));
            }
        }
    }

    public static Map<String, Integer> getCurrentMapping() {
        if (GolemEnumHelper.hasCurrentMapping()) {
            return Gadomancy.getModData().get("GolemTypeMapping", new HashMap());
        }
        if (Gadomancy.getModData() != null) {
            Gadomancy.getModData().set("GolemTypeMapping", defaultMapping);
        }
        return defaultMapping;
    }

    public static boolean hasCurrentMapping() {
        return Gadomancy.getModData() != null && Gadomancy.getModData().contains("GolemTypeMapping");
    }

    private static void saveCurrentMapping(Map<String, Integer> map) {
        if (Gadomancy.getModData() != null) {
            Gadomancy.getModData().set("GolemTypeMapping", map);
        }
    }

    static {
        ENUM_PARAMS = new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        defaultMapping = new HashMap<String, Integer>();
    }
}

