/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import com.google.common.collect.ImmutableList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWarpEvent;

public class WarpBuff
extends IWarpEvent {
    private final boolean preventCure;
    private final ImmutableList<PotionEffect> potionEffects;

    public WarpBuff(String name, int minWarp, boolean preventCure, PotionEffect ... effects) {
        super(name, minWarp);
        this.preventCure = preventCure;
        this.potionEffects = ImmutableList.copyOf((Object[])effects);
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return true;
        }
        for (PotionEffect effect : this.potionEffects) {
            int id = effect.func_76456_a();
            int duration = effect.func_76459_b();
            int level = effect.func_76458_c();
            if (player.func_82165_m(id)) {
                for (PotionEffect e : player.func_70651_bq()) {
                    if (e.func_76456_a() != id) continue;
                    effect = new PotionEffect(id, duration + e.func_76459_b(), level);
                    break;
                }
            } else {
                effect = new PotionEffect(id, duration, level);
            }
            if (this.preventCure) {
                effect.getCurativeItems().clear();
            }
            player.func_70690_d(effect);
        }
        this.sendChatMessage(player);
        return true;
    }
}

