/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];
    static RenderItem uniformRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }
    };
    static EntityItem entityItem;

    public static void renderFluidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, IIcon icon, double res) {
        RenderUtils.renderFluidQuad(point2, vectors[0].set(point4).subtract(point1), vectors[1].set(point1).subtract(point2), icon, res);
    }

    public static void renderFluidQuad(Vector3 base, Vector3 wide, Vector3 high, IIcon icon, double res) {
        double rx;
        Tessellator t = Tessellator.field_78398_a;
        double u1 = icon.func_94209_e();
        double du = icon.func_94212_f() - icon.func_94209_e();
        double v2 = icon.func_94210_h();
        double dv = icon.func_94210_h() - icon.func_94206_g();
        double wlen = wide.mag();
        double hlen = high.mag();
        for (double x = 0.0; x < wlen; x += rx) {
            double ry;
            rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < hlen; y += ry) {
                ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y + ry) / hlen);
                t.func_78374_a(base.x + dx1.x + dy2.x, base.y + dx1.y + dy2.y, base.z + dx1.z + dy2.z, u1, v2 - ry / res * dv);
                t.func_78374_a(base.x + dx1.x + dy1.x, base.y + dx1.y + dy1.y, base.z + dx1.z + dy1.z, u1, v2);
                t.func_78374_a(base.x + dx2.x + dy1.x, base.y + dx2.y + dy1.y, base.z + dx2.z + dy1.z, u1 + rx / res * du, v2);
                t.func_78374_a(base.x + dx2.x + dy2.x, base.y + dx2.y + dy2.y, base.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv);
            }
        }
    }

    public static void translateToWorldCoords(Entity entity, float frame) {
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawCuboidOutline(Cuboid6 c) {
        Tessellator var2 = Tessellator.field_78398_a;
        var2.func_78371_b(3);
        var2.func_78377_a(c.min.x, c.min.y, c.min.z);
        var2.func_78377_a(c.max.x, c.min.y, c.min.z);
        var2.func_78377_a(c.max.x, c.min.y, c.max.z);
        var2.func_78377_a(c.min.x, c.min.y, c.max.z);
        var2.func_78377_a(c.min.x, c.min.y, c.min.z);
        var2.func_78381_a();
        var2.func_78371_b(3);
        var2.func_78377_a(c.min.x, c.max.y, c.min.z);
        var2.func_78377_a(c.max.x, c.max.y, c.min.z);
        var2.func_78377_a(c.max.x, c.max.y, c.max.z);
        var2.func_78377_a(c.min.x, c.max.y, c.max.z);
        var2.func_78377_a(c.min.x, c.max.y, c.min.z);
        var2.func_78381_a();
        var2.func_78371_b(1);
        var2.func_78377_a(c.min.x, c.min.y, c.min.z);
        var2.func_78377_a(c.min.x, c.max.y, c.min.z);
        var2.func_78377_a(c.max.x, c.min.y, c.min.z);
        var2.func_78377_a(c.max.x, c.max.y, c.min.z);
        var2.func_78377_a(c.max.x, c.min.y, c.max.z);
        var2.func_78377_a(c.max.x, c.max.y, c.max.z);
        var2.func_78377_a(c.min.x, c.min.y, c.max.z);
        var2.func_78377_a(c.min.x, c.max.y, c.max.z);
        var2.func_78381_a();
    }

    public static void renderFluidCuboid(CCRenderState state, Cuboid6 bound, IIcon tex, double res) {
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void renderFluidCuboid(Cuboid6 bound, IIcon tex, double res) {
        RenderUtils.renderFluidCuboid(CCRenderState.instance(), bound, tex, res);
    }

    public static void renderBlockOverlaySide(int x, int y, int z, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x - 0.009, (double)x + 1.009, (double)y - 0.009, (double)y + 1.009, (double)z - 0.009, (double)z + 1.009};
        Tessellator tessellator = Tessellator.field_78398_a;
        switch (side) {
            case 0: {
                tessellator.func_78374_a(points[0], points[2], points[4], tx1, ty1);
                tessellator.func_78374_a(points[1], points[2], points[4], tx2, ty1);
                tessellator.func_78374_a(points[1], points[2], points[5], tx2, ty2);
                tessellator.func_78374_a(points[0], points[2], points[5], tx1, ty2);
                break;
            }
            case 1: {
                tessellator.func_78374_a(points[1], points[3], points[4], tx2, ty1);
                tessellator.func_78374_a(points[0], points[3], points[4], tx1, ty1);
                tessellator.func_78374_a(points[0], points[3], points[5], tx1, ty2);
                tessellator.func_78374_a(points[1], points[3], points[5], tx2, ty2);
                break;
            }
            case 2: {
                tessellator.func_78374_a(points[0], points[3], points[4], tx2, ty1);
                tessellator.func_78374_a(points[1], points[3], points[4], tx1, ty1);
                tessellator.func_78374_a(points[1], points[2], points[4], tx1, ty2);
                tessellator.func_78374_a(points[0], points[2], points[4], tx2, ty2);
                break;
            }
            case 3: {
                tessellator.func_78374_a(points[1], points[3], points[5], tx2, ty1);
                tessellator.func_78374_a(points[0], points[3], points[5], tx1, ty1);
                tessellator.func_78374_a(points[0], points[2], points[5], tx1, ty2);
                tessellator.func_78374_a(points[1], points[2], points[5], tx2, ty2);
                break;
            }
            case 4: {
                tessellator.func_78374_a(points[0], points[3], points[5], tx2, ty1);
                tessellator.func_78374_a(points[0], points[3], points[4], tx1, ty1);
                tessellator.func_78374_a(points[0], points[2], points[4], tx1, ty2);
                tessellator.func_78374_a(points[0], points[2], points[5], tx2, ty2);
                break;
            }
            case 5: {
                tessellator.func_78374_a(points[1], points[3], points[4], tx2, ty1);
                tessellator.func_78374_a(points[1], points[3], points[5], tx1, ty1);
                tessellator.func_78374_a(points[1], points[2], points[5], tx1, ty2);
                tessellator.func_78374_a(points[1], points[2], points[4], tx2, ty2);
            }
        }
    }

    public static boolean shouldRenderFluid(FluidStack stack) {
        return stack.amount > 0 && stack.getFluid() != null;
    }

    public static IIcon prepareFluidRender(CCRenderState state, FluidStack stack, int alpha) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Fluid fluid = stack.getFluid();
        state.setColour(fluid.getColor(stack) << 8 | alpha);
        TextureUtils.bindAtlas(fluid.getSpriteNumber());
        return TextureUtils.safeIcon(fluid.getIcon(stack));
    }

    public static IIcon prepareFluidRender(FluidStack stack, int alpha) {
        return RenderUtils.prepareFluidRender(CCRenderState.instance(), stack, alpha);
    }

    public static void postFluidRender() {
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public static double fluidDensityToAlpha(double density) {
        return Math.pow(density, 0.4);
    }

    public static void renderFluidCuboid(CCRenderState state, FluidStack stack, Cuboid6 bound, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            bound.max.y = bound.min.y + (bound.max.y - bound.min.y) * density;
        }
        IIcon tex = RenderUtils.prepareFluidRender(state, stack, alpha);
        state.startDrawing();
        RenderUtils.renderFluidCuboid(state, bound, tex, res);
        state.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderFluidCuboid(FluidStack stack, Cuboid6 bound, double density, double res) {
        RenderUtils.renderFluidCuboid(CCRenderState.instance(), stack, bound, density, res);
    }

    public static void renderFluidGauge(CCRenderState state, FluidStack stack, Rectangle4i rect, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            int height = (int)((double)rect.h * density);
            rect.y += rect.h - height;
            rect.h = height;
        }
        IIcon tex = RenderUtils.prepareFluidRender(state, stack, alpha);
        state.startDrawing();
        RenderUtils.renderFluidQuad(new Vector3(rect.x, rect.y + rect.h, 0.0), new Vector3(rect.w, 0.0, 0.0), new Vector3(0.0, -rect.h, 0.0), tex, res);
        state.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderFluidGauge(FluidStack stack, Rectangle4i rect, double density, double res) {
        RenderUtils.renderFluidGauge(CCRenderState.instance(), stack, rect, density, res);
    }

    public static void renderItemUniform(ItemStack item) {
        RenderUtils.renderItemUniform(item, 0.0);
    }

    public static void renderItemUniform(ItemStack item, double spin) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        boolean is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        boolean larger = false;
        if (item.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)item.func_77973_b()).func_149645_b())) {
            int renderType = Block.func_149634_a((Item)item.func_77973_b()).func_149645_b();
            larger = renderType != 1 && renderType != 19 && renderType != 12 && renderType != 2;
        } else if (is3D) {
            larger = true;
        }
        double d = 2.0;
        double d1 = 1.0 / d;
        if (larger) {
            GL11.glScaled((double)d, (double)d, (double)d);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityItem.func_92058_a(item);
        uniformRenderItem.func_76986_a(entityItem, 0.0, larger ? 0.09 : 0.06, 0.0, 0.0f, (float)(spin * 9.0 / Math.PI));
        if (larger) {
            GL11.glScaled((double)d1, (double)d1, (double)d1);
        }
    }

    static {
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
        uniformRenderItem.func_76976_a(RenderManager.field_78727_a);
        entityItem = new EntityItem(null);
        RenderUtils.entityItem.field_70290_d = 0.0f;
    }
}

