/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.integration.simplyjetpacks.tag;

import cofh.api.energy.IEnergyContainerItem;
import com.github.lunatrius.ingameinfo.tag.TagIntegration;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import tonius.simplyjetpacks.item.ItemPack;
import tonius.simplyjetpacks.item.meta.Jetpack;

public abstract class TagSimplyJetpacks
extends TagIntegration {
    @Override
    public String getCategory() {
        return "simplyjetpacks";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new Energy().setName("sjenergy"));
        TagRegistry.INSTANCE.register(new MaxEnergy().setName("sjmaxenergy"));
        TagRegistry.INSTANCE.register(new Percent().setName("sjpercent"));
        TagRegistry.INSTANCE.register(new Enabled().setName("sjenabled"));
        TagRegistry.INSTANCE.register(new Hover().setName("sjhover"));
    }

    public static class Hover
    extends TagSimplyJetpacks {
        @Override
        public String getValue() {
            try {
                ItemStack chestplate = player.func_82169_q(2);
                if (chestplate != null && chestplate.func_77973_b() instanceof ItemPack.ItemJetpack) {
                    ItemPack.ItemJetpack item = (ItemPack.ItemJetpack)chestplate.func_77973_b();
                    Jetpack jetpack = (Jetpack)item.getPack(chestplate);
                    return String.valueOf(jetpack != null && jetpack.isHoverModeOn(chestplate));
                }
            }
            catch (Throwable e) {
                this.log(this, e);
            }
            return String.valueOf(false);
        }
    }

    public static class Enabled
    extends TagSimplyJetpacks {
        @Override
        public String getValue() {
            try {
                ItemStack chestplate = player.func_82169_q(2);
                if (chestplate != null && chestplate.func_77973_b() instanceof ItemPack.ItemJetpack) {
                    ItemPack.ItemJetpack item = (ItemPack.ItemJetpack)chestplate.func_77973_b();
                    Jetpack jetpack = (Jetpack)item.getPack(chestplate);
                    return String.valueOf(jetpack != null && jetpack.isOn(chestplate));
                }
            }
            catch (Throwable e) {
                this.log(this, e);
            }
            return String.valueOf(false);
        }
    }

    public static class Percent
    extends TagSimplyJetpacks {
        @Override
        public String getValue() {
            try {
                ItemStack chestplate = player.func_82169_q(2);
                if (chestplate != null && chestplate.func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem item = (IEnergyContainerItem)chestplate.func_77973_b();
                    return String.format(Locale.ENGLISH, "%.2f", 100.0 * (double)item.getEnergyStored(chestplate) / (double)item.getMaxEnergyStored(chestplate));
                }
            }
            catch (Throwable e) {
                this.log(this, e);
            }
            return "-1";
        }
    }

    public static class MaxEnergy
    extends TagSimplyJetpacks {
        @Override
        public String getValue() {
            try {
                ItemStack chestplate = player.func_82169_q(2);
                if (chestplate != null && chestplate.func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem item = (IEnergyContainerItem)chestplate.func_77973_b();
                    return String.valueOf(item.getMaxEnergyStored(chestplate));
                }
            }
            catch (Throwable e) {
                this.log(this, e);
            }
            return "-1";
        }
    }

    public static class Energy
    extends TagSimplyJetpacks {
        @Override
        public String getValue() {
            try {
                ItemStack chestplate = player.func_82169_q(2);
                if (chestplate != null && chestplate.func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem item = (IEnergyContainerItem)chestplate.func_77973_b();
                    return String.valueOf(item.getEnergyStored(chestplate));
                }
            }
            catch (Throwable e) {
                this.log(this, e);
            }
            return "-1";
        }
    }
}

