/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.util;

import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import com.gtnewhorizon.structurelib.util.InventoryIterable;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import com.gtnewhorizon.structurelib.util.SortedRegistry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.ItemStack;

public class InventoryUtility {
    private static final SortedRegistry<ItemStackExtractor> stackExtractors = new SortedRegistry();
    private static final List<Predicate<? super EntityPlayerMP>> enableEnder = new CopyOnWriteArrayList<Predicate<? super EntityPlayerMP>>();
    private static final SortedRegistry<InventoryProvider<?>> inventoryProviders = new SortedRegistry();

    public static void registerEnableEnderCondition(Predicate<? super EntityPlayerMP> predicate) {
        enableEnder.add(predicate);
    }

    public static void registerStackExtractor(String key, ItemStackExtractor val) {
        if (Arrays.stream(ItemStackExtractor.APIType.values()).noneMatch(val::isAPIImplemented)) {
            throw new IllegalArgumentException("Must implement at least one API");
        }
        stackExtractors.register(key, val);
    }

    public static <Inv extends IInventory> void registerStackExtractor(String key, Function<ItemStack, ? extends Inv> extractor) {
        InventoryUtility.registerStackExtractor(key, InventoryUtility.newItemStackProvider(extractor));
    }

    public static void registerInventoryProvider(String key, InventoryProvider<?> val) {
        inventoryProviders.register(key, val);
    }

    public static <Inv extends IInventory> void registerInventoryProvider(String key, Function<EntityPlayerMP, ? extends Inv> extractor) {
        InventoryUtility.registerInventoryProvider(key, InventoryUtility.newInventoryProvider(extractor));
    }

    public static Iterator<? extends ItemStackExtractor> getStackExtractors() {
        return stackExtractors.iterator();
    }

    public static <Inv extends IInventory> InventoryProvider<InventoryIterable<Inv>> newInventoryProvider(final Function<EntityPlayerMP, ? extends Inv> extractor) {
        return new InventoryProvider<InventoryIterable<Inv>>(){

            @Override
            public InventoryIterable<Inv> getInventory(EntityPlayerMP player) {
                IInventory inv = (IInventory)extractor.apply(player);
                return inv != null ? new InventoryIterable<IInventory>(inv) : null;
            }

            @Override
            public void markDirty(InventoryIterable<Inv> inv) {
                inv.getInventory().func_70296_d();
            }
        };
    }

    public static ItemStackExtractor newItemStackProvider(final Function<ItemStack, ? extends IInventory> extractor) {
        return new ItemStackExtractor(){

            @Override
            public boolean isAPIImplemented(ItemStackExtractor.APIType type) {
                return type == ItemStackExtractor.APIType.MAIN;
            }

            @Override
            public int takeFromStack(Predicate<ItemStack> predicate, boolean simulate, int count, ItemStackCounter store, ItemStack stack, ItemStack filter, EntityPlayerMP player) {
                IInventory inv = (IInventory)extractor.apply(stack);
                if (inv == null) {
                    return 0;
                }
                int found = InventoryUtility.takeFromInventory(new InventoryIterable<IInventory>(inv), predicate, simulate, count, store, filter, player, false);
                if (found > 0) {
                    inv.func_70296_d();
                }
                return found;
            }
        };
    }

    public static Map<ItemStack, Integer> takeFromInventory(EntityPlayerMP player, Predicate<ItemStack> predicate, boolean simulate, int count) {
        ItemStackCounterImpl store = new ItemStackCounterImpl();
        int sum = 0;
        for (InventoryProvider<?> provider : inventoryProviders) {
            if ((sum += InventoryUtility.takeFromPlayer(player, predicate, simulate, count - sum, store, provider, null)) < count) continue;
            return store.getStore();
        }
        return store.getStore();
    }

    public static int takeFromInventory(EntityPlayerMP player, ItemStack filter, boolean simulate) {
        int sum = 0;
        int count = filter.field_77994_a;
        ItemStackPredicate predicate = ItemStackPredicate.from(filter, ItemStackPredicate.NBTMode.EXACT);
        ItemStackCounterImpl store = new ItemStackCounterImpl();
        for (InventoryProvider<?> provider : inventoryProviders) {
            if ((sum += InventoryUtility.takeFromPlayer(player, predicate, simulate, count - sum, store, provider, filter)) < count) continue;
            return sum;
        }
        return sum;
    }

    private static <R extends Iterable<ItemStack>> int takeFromPlayer(EntityPlayerMP player, Predicate<ItemStack> predicate, boolean simulate, int count, ItemStackCounterImpl store, InventoryProvider<R> provider, ItemStack filter) {
        R inv = provider.getInventory(player);
        if (inv == null) {
            return 0;
        }
        int taken = InventoryUtility.takeFromInventory(inv, predicate, simulate, count, store, filter, player, true);
        if (taken > 0) {
            provider.markDirty(inv);
        }
        return taken;
    }

    public static Map<ItemStack, Integer> takeFromInventory(Iterable<ItemStack> inv, Predicate<ItemStack> predicate, boolean simulate, int count, boolean recursive) {
        ItemStackCounterImpl store = new ItemStackCounterImpl();
        InventoryUtility.takeFromInventory(inv, predicate, simulate, count, store, null, null, recursive);
        return store.getStore();
    }

    private static int takeFromInventory(@Nonnull Iterable<ItemStack> inv, @Nonnull Predicate<ItemStack> predicate, boolean simulate, int count, @Nonnull ItemStackCounter store, @Nullable ItemStack filter, @Nullable EntityPlayerMP player, boolean recursive) {
        int found = 0;
        ItemStack copiedFilter = null;
        if (filter != null) {
            copiedFilter = new ItemStack(filter.func_77973_b(), filter.field_77994_a, Items.field_151008_G.getDamage(filter));
            copiedFilter.func_77982_d(filter.field_77990_d);
        }
        Iterator<ItemStack> iterator = inv.iterator();
        block0: while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (stack == null || stack.func_77973_b() == null || stack.field_77994_a <= 0) continue;
            if (predicate.test(stack)) {
                if ((found += stack.field_77994_a) > count) {
                    int surplus = found - count;
                    store.add(stack, stack.field_77994_a - surplus);
                    if (!simulate) {
                        stack.field_77994_a = surplus;
                    }
                    return count;
                }
                store.add(stack, stack.field_77994_a);
                if (!simulate) {
                    iterator.remove();
                }
                if (found == count) {
                    return count;
                }
            }
            if (!recursive) continue;
            for (ItemStackExtractor f : stackExtractors) {
                boolean end = f.isAPIImplemented(ItemStackExtractor.APIType.IS_VALID_SOURCE);
                if (!f.isValidSource(stack, player)) continue;
                if (filter != null && f.isAPIImplemented(ItemStackExtractor.APIType.EXTRACT_ONE_STACK)) {
                    copiedFilter.field_77994_a = count - found;
                    found += f.getItem(stack, copiedFilter, simulate, player);
                } else {
                    found += f.takeFromStack(predicate, simulate, count - found, store, stack, filter, player);
                }
                if (found >= count) {
                    return found;
                }
                if (!end) continue;
                continue block0;
            }
        }
        return found;
    }

    static {
        inventoryProviders.register("5000-main-inventory", new InventoryProvider<InventoryIterable<InventoryPlayer>>(){

            @Override
            public InventoryIterable<InventoryPlayer> getInventory(EntityPlayerMP player) {
                return new InventoryIterable<InventoryPlayer>(player.field_71071_by, player.field_71071_by.field_70462_a.length);
            }

            @Override
            public void markDirty(InventoryIterable<InventoryPlayer> inv) {
                inv.getInventory().field_70458_d.field_71069_bz.func_75142_b();
            }
        });
        inventoryProviders.register("7000-ender-inventory", new InventoryProvider<InventoryIterable<InventoryEnderChest>>(){

            @Override
            public InventoryIterable<InventoryEnderChest> getInventory(EntityPlayerMP player) {
                if (enableEnder.stream().anyMatch(p -> p.test(player))) {
                    return new InventoryIterable<InventoryEnderChest>(player.func_71005_bN());
                }
                return null;
            }

            @Override
            public void markDirty(InventoryIterable<InventoryEnderChest> inv) {
            }
        });
    }

    private static class ItemStackCounterImpl
    implements ItemStackCounter {
        private final Map<ItemStack, Integer> store = new ItemStackMap(true);

        private ItemStackCounterImpl() {
        }

        @Override
        public void add(ItemStack stack, int stackSize) {
            if (stack == null || stack.func_77973_b() == null || stackSize <= 0) {
                throw new IllegalArgumentException();
            }
            this.store.merge(stack, stackSize, Integer::sum);
        }

        public Map<ItemStack, Integer> getStore() {
            return this.store;
        }
    }

    public static interface ItemStackCounter {
        public void add(ItemStack var1, int var2);
    }

    public static interface ItemStackExtractor {
        public boolean isAPIImplemented(APIType var1);

        default public boolean isValidSource(ItemStack is, EntityPlayerMP player) {
            return true;
        }

        public int takeFromStack(Predicate<ItemStack> var1, boolean var2, int var3, ItemStackCounter var4, ItemStack var5, ItemStack var6, EntityPlayerMP var7);

        default public int getItem(ItemStack source, ItemStack toExtract, boolean simulate, EntityPlayerMP player) {
            return -1;
        }

        public static ItemStackExtractor createOnlyOptimized(final @Nonnull OptimizedExtractor optimizedExtractor) {
            return new ItemStackExtractor(){

                @Override
                public boolean isAPIImplemented(APIType type) {
                    return type == APIType.EXTRACT_ONE_STACK;
                }

                @Override
                public int takeFromStack(Predicate<ItemStack> predicate, boolean simulate, int count, ItemStackCounter store, ItemStack stack, ItemStack filter, EntityPlayerMP player) {
                    return 0;
                }

                @Override
                public int getItem(ItemStack source, ItemStack toExtract, boolean simulate, EntityPlayerMP player) {
                    return optimizedExtractor.extract(source, toExtract, simulate, player);
                }
            };
        }

        public static enum APIType {
            MAIN,
            EXTRACT_ONE_STACK,
            IS_VALID_SOURCE;

        }
    }

    public static interface InventoryProvider<R extends Iterable<ItemStack>> {
        public R getInventory(EntityPlayerMP var1);

        public void markDirty(R var1);
    }

    public static interface OptimizedExtractor {
        public int extract(ItemStack var1, ItemStack var2, boolean var3, EntityPlayerMP var4);
    }
}

