/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.generators;

import com.rwtema.extrautils.tileentity.generators.TileEntityGeneratorSimpleSolar;

public class TileEntityGeneratorSolar
extends TileEntityGeneratorSimpleSolar {
    public int curLevel = -1;

    @Override
    public String getBlurb(double coolDown, double energy) {
        if (this.isPowered()) {
            if (coolDown == 0.0) {
                return "Transmitting: Deactivate redstone signal to resume charging";
            }
            return "Time Remaining until transmittion starts:\n" + TileEntityGeneratorSolar.getCoolDownString(coolDown);
        }
        if (coolDown == 0.0) {
            return "\n\n\nCharging: Apply redstone signal to transmit energy";
        }
        return "PowerLevel:\n" + energy + "\n\nCharging: Apply redstone signal to transmit energy";
    }

    @Override
    public int transferLimit() {
        return 20 + (int)(this.genLevel() / 2.0);
    }

    @Override
    public int getMaxCoolDown() {
        return 200;
    }

    @Override
    public double genLevel() {
        if (this.curLevel == -1 || this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.curLevel = this.genLevelForTime();
        }
        if (this.curLevel == 0) {
            return 0.0;
        }
        if (!this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            return 0.0;
        }
        if (this.isPowered()) {
            return 0.0;
        }
        return this.curLevel;
    }

    @Override
    public boolean processInput() {
        if (this.genLevel() > 0.0) {
            this.coolDown = this.getMaxCoolDown();
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldTransmit() {
        return this.coolDown == 0.0;
    }
}

