/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;

public class ControlCheckbox
extends Control
implements IControlValue<Boolean> {
    boolean value;
    String text;

    public ControlCheckbox(IWidget parent, float x, float y, boolean bool) {
        this(parent, x, y, 0.0f, "", bool);
    }

    public ControlCheckbox(IWidget parent, float x, float y, float w, String text, boolean bool) {
        super(parent, x, y, w > 16.0f ? w : 16.0f, 16.0f);
        this.text = text;
        this.value = bool;
        if (w > 16.0f) {
            new ControlText(this, new IArea(16.0f, 1.0f, w - 16.0f, 16.0f), text, TextJustification.MIDDLE_CENTER).setColor(0x444444);
        }
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.addEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                ControlCheckbox.this.toggleValue();
            }
        }.setOrigin(EventHandler.Origin.Self, this));
    }

    @Override
    public void onRenderBackground() {
        CraftGUITexture texture;
        CraftGUITexture craftGUITexture = texture = this.getValue() != false ? CraftGUITexture.CheckboxChecked : CraftGUITexture.Checkbox;
        if (this.isMouseOver()) {
            texture = this.getValue() != false ? CraftGUITexture.CheckboxCheckedHighlighted : CraftGUITexture.CheckboxHighlighted;
        }
        CraftGUI.render.texture((Object)texture, IPoint.ZERO);
    }

    protected void onValueChanged(boolean value) {
    }

    public void toggleValue() {
        this.setValue(this.getValue() == false);
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean value) {
        this.value = value;
        this.onValueChanged(value);
        this.callEvent(new EventValueChanged<Boolean>(this, value));
    }
}

