/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventWidget;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.nei.NEIHook;
import net.minecraft.item.ItemStack;

public abstract class ControlSlotBase
extends Control
implements ITooltip {
    private ControlItemDisplay itemDisplay;

    public ControlSlotBase(IWidget parent, float x, float y) {
        this(parent, x, y, 18);
    }

    public ControlSlotBase(IWidget parent, float x, float y, int size) {
        super(parent, x, y, size, size);
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.itemDisplay = new ControlItemDisplay(this, 1.0f, 1.0f, size - 2);
        this.addSelfEventHandler((EventHandler)new EventWidget.ChangeSize.Handler(){

            @Override
            public void onEvent(EventWidget.ChangeSize event) {
                if (ControlSlotBase.this.itemDisplay != null) {
                    ControlSlotBase.this.itemDisplay.setSize(ControlSlotBase.this.getSize().sub(new IPoint(2.0f, 2.0f)));
                }
            }
        });
    }

    protected void setRotating() {
        this.itemDisplay.setRotating();
    }

    @Override
    public void onRenderBackground() {
        CraftGUI.render.texture((Object)CraftGUITexture.Slot, this.getArea());
        if (this.getSuperParent().getMousedOverWidget() == this) {
            CraftGUI.render.gradientRect(new IArea(new IPoint(1.0f, 1.0f), this.getArea().size().sub(new IPoint(2.0f, 2.0f))), -2130706433, -2130706433);
        }
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        this.itemDisplay.setItemStack(this.getItemStack());
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (NEIHook.enabled) {
            return;
        }
        ItemStack item = this.getItemStack();
        if (item == null) {
            return;
        }
        tooltip.add(item.func_82840_a(((Window)this.getSuperParent()).getPlayer(), false));
    }

    public abstract ItemStack getItemStack();
}

