/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.nei;

import binnie.core.nei.NEIUtils;
import binnie.core.nei.PositionedFluidTank;
import binnie.core.nei.PositionedStackAdv;
import binnie.core.nei.RecipeHandlerBase;
import binnie.genetics.Genetics;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.item.ItemSequence;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class PolymeriserRecipeHandler
extends RecipeHandlerBase {
    private static final List<PolymeriserRecipe> recipes = new ArrayList<PolymeriserRecipe>();

    @Override
    public void prepare() {
        recipes.add(new PolymeriserRecipe(new ItemStack(Genetics.itemSequencer, 1, Short.MAX_VALUE)));
        recipes.add(new PolymeriserRecipe(new ItemStack(Genetics.itemSerum, 1, Short.MAX_VALUE)));
        recipes.add(new PolymeriserRecipe(new ItemStack((Item)Genetics.itemSerumArray, 1, Short.MAX_VALUE)));
    }

    public String getOverlayIdentifier() {
        return "genetics.polymeriser";
    }

    public String getGuiTexture() {
        return "genetics:textures/gui/nei/polymeriser.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"genetics.machine.machine.polymeriser");
    }

    public void loadTransferRects() {
        this.addTransferRect(95, 27, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)74);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(95, 27, 176, 0, 24, 17, 40, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (PolymeriserRecipe recipe : recipes) {
            this.arecipes.add(new CachedPolymeriserRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (PolymeriserRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedPolymeriserRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)new ItemStack(Items.field_151074_bl), (ItemStack)ingredient)) {
            this.loadAllRecipes();
        } else {
            for (PolymeriserRecipe recipe : recipes) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getSerum(), (ItemStack)ingredient)) continue;
                this.arecipes.add(new CachedPolymeriserRecipe(recipe));
            }
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (NEIUtils.areFluidsSameType(GeneticLiquid.BacteriaPoly.get(0), ingredient) || NEIUtils.areFluidsSameType(GeneticLiquid.RawDNA.get(0), ingredient)) {
            this.loadAllRecipes();
        }
    }

    public class CachedPolymeriserRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack input;
        public PositionedStack output;
        public PositionedStack goldNugget;
        public PositionedFluidTank bacteriaPoly;
        public PositionedFluidTank rawDNA;
        public List<PositionedStack> ingredients = new ArrayList<PositionedStack>();
        public List<PositionedFluidTank> tanks = new ArrayList<PositionedFluidTank>();

        public CachedPolymeriserRecipe(PolymeriserRecipe recipe) {
            if (recipe.getSerum() != null) {
                ItemStack temp;
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
                ArrayList<FluidStack> bacteriaPolyTanks = new ArrayList<FluidStack>();
                ArrayList<FluidStack> rawDNATanks = new ArrayList<FluidStack>();
                for (ItemStack itemStack : ItemList.itemMap.get((Object)recipe.getSerum().func_77973_b())) {
                    if (itemStack.func_77978_p() == null) continue;
                    temp = itemStack.func_77946_l();
                    if (itemStack.func_77973_b() instanceof IItemSerum) {
                        temp.func_77964_b(itemStack.func_77958_k());
                    }
                    inputs.add(temp);
                    int bacteriaPolyAmount = 10 * temp.func_77960_j() * (temp.func_77978_p() == null ? 1 : Engineering.getGenes(temp).length);
                    bacteriaPolyTanks.add(GeneticLiquid.BacteriaPoly.get(bacteriaPolyAmount));
                    rawDNATanks.add(GeneticLiquid.RawDNA.get(bacteriaPolyAmount * 5));
                }
                this.input = new PositionedStack(inputs, 73, 27);
                this.goldNugget = new PositionedStackAdv(new ItemStack(Items.field_151074_bl), 73, 48).addToTooltip(StatCollector.func_74837_a((String)"genetics.nei.tip.processSpeed", (Object[])new Object[]{5}));
                this.ingredients.add(this.input);
                this.ingredients.add(this.goldNugget);
                this.bacteriaPoly = new PositionedFluidTank(bacteriaPolyTanks, 10000, new Rectangle(27, 6, 16, 58), null, null);
                this.rawDNA = new PositionedFluidTank(rawDNATanks, 20000, new Rectangle(48, 6, 16, 58), null, null);
                this.tanks.add(this.bacteriaPoly);
                this.tanks.add(this.rawDNA);
                for (ItemStack itemStack : ItemList.itemMap.get((Object)recipe.getOutput().func_77973_b())) {
                    if (itemStack.func_77978_p() == null) continue;
                    temp = itemStack.func_77946_l();
                    if (recipe.getOutput().func_77973_b() instanceof ItemSequence) {
                        temp.func_77964_b(0);
                    }
                    outputs.add(temp);
                }
                this.output = new PositionedStack(outputs, 125, 27);
            }
        }

        public List<PositionedStack> getIngredients() {
            this.input.setPermutationToRender(PolymeriserRecipeHandler.this.cycleticks / 40 % this.input.items.length);
            this.bacteriaPoly.setPermutationToRender(PolymeriserRecipeHandler.this.cycleticks / 40 % this.bacteriaPoly.tanks.length);
            this.rawDNA.setPermutationToRender(PolymeriserRecipeHandler.this.cycleticks / 40 % this.rawDNA.tanks.length);
            return this.ingredients;
        }

        public PositionedStack getResult() {
            this.output.setPermutationToRender(PolymeriserRecipeHandler.this.cycleticks / 40 % this.output.items.length);
            return this.output;
        }

        @Override
        public List<PositionedFluidTank> getFluidTanks() {
            return this.tanks;
        }
    }

    private static class PolymeriserRecipe {
        private final ItemStack serum;

        public PolymeriserRecipe(ItemStack serum) {
            this.serum = serum;
        }

        public ItemStack getSerum() {
            return this.serum;
        }

        public ItemStack getOutput() {
            return this.serum;
        }
    }
}

