/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.nei;

import binnie.core.nei.RecipeHandlerBase;
import binnie.genetics.Genetics;
import binnie.genetics.item.GeneticsItems;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class SequencerRecipeHandler
extends RecipeHandlerBase {
    public String getOverlayIdentifier() {
        return "genetics.sequencer";
    }

    public String getGuiTexture() {
        return "genetics:textures/gui/nei/sequencer.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"genetics.machine.machine.sequencer");
    }

    public void loadTransferRects() {
        this.addTransferRect(75, 19, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)74);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(75, 19, 176, 0, 24, 17, 40, 0);
    }

    @Override
    public void loadAllRecipes() {
        this.arecipes.add(new CachedSequencerRecipe());
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)GeneticsItems.EmptySequencer.get(1), (ItemStack)result)) {
            this.loadAllRecipes();
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)new ItemStack(Genetics.itemSequencer), (ItemStack)ingredient) || NEIServerUtils.areStacksSameTypeCrafting((ItemStack)GeneticsItems.FluorescentDye.get(1), (ItemStack)ingredient) || NEIServerUtils.areStacksSameTypeCrafting((ItemStack)new ItemStack((Item)Genetics.database), (ItemStack)ingredient)) {
            this.loadAllRecipes();
        }
    }

    public class CachedSequencerRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack seq;
        public PositionedStack fluorescentDye = new PositionedStack((Object)GeneticsItems.FluorescentDye.get(1), 53, 40);
        public PositionedStack database = new PositionedStack((Object)new ItemStack((Item)Genetics.database), 105, 19);
        public PositionedStack emptySeq = new PositionedStack((Object)GeneticsItems.EmptySequencer.get(1), 105, 40);
        public List<PositionedStack> ingredients = new ArrayList<PositionedStack>();
        public List<PositionedStack> results = new ArrayList<PositionedStack>();

        public CachedSequencerRecipe() {
            ArrayList<ItemStack> seqList = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ItemList.itemMap.get((Object)Genetics.itemSequencer)) {
                for (int i = Genetics.itemSequencer.func_77612_l(); i >= 0; --i) {
                    ItemStack temp = itemStack.func_77946_l();
                    temp.func_77964_b(i);
                    seqList.add(temp);
                }
            }
            this.seq = new PositionedStack(seqList, 53, 19);
            this.ingredients.add(this.seq);
            this.ingredients.add(this.fluorescentDye);
            this.results.add(this.database);
            this.results.add(this.emptySeq);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            this.seq.setPermutationToRender(SequencerRecipeHandler.this.cycleticks / 40 % this.seq.items.length);
            return this.ingredients;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.results;
        }
    }
}

