/*
 * Decompiled with CFR 0.152.
 */
package serverutils;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.config.Configuration;
import serverutils.data.ClaimedChunks;
import serverutils.lib.config.EnumTristate;
import serverutils.lib.io.DataReader;
import serverutils.lib.item.ItemStackSerializer;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.JsonUtils;
import serverutils.lib.util.ServerUtils;

public class ServerUtilitiesConfig {
    public static Configuration config;
    public static final String GEN_CAT = "general";
    public static final String TEAM_CAT = "team";
    public static final String DEBUG_CAT = "debugging";
    public static final String AUTO_SHUTDOWN = "auto_shutdown";
    public static final String AFK = "afk";
    public static final String CHAT = "chat";
    public static final String COMMANDS = "commands";
    public static final String LOGIN = "login";
    public static final String RANKS = "ranks";
    public static final String WORLD = "world";
    public static final String LOGGING = "world.logging";
    public static final String DEBUGGING = "debugging";
    public static final String BACKUPS = "backups";
    public static final String[] TRISTATE_VALUES;
    public static final AutoShutdown auto_shutdown;
    public static final AFK afk;
    public static final Chat chat;
    public static final Commands commands;
    public static final Login login;
    public static final RanksConfig ranks;
    public static final WorldConfig world;
    public static final Debugging debugging;
    public static final Backups backups;
    public static final General general;
    public static final Teams teams;

    public static void init(FMLPreInitializationEvent event) {
        config = new Configuration(new File(event.getModConfigurationDirectory() + "/../serverutilities/serverutilities.cfg"));
        config.load();
        ServerUtilitiesConfig.sync();
    }

    public static boolean sync() {
        ServerUtilitiesConfig.general.replace_reload_command = config.get(GEN_CAT, "replace_reload_command", true, "This will replace /reload with ServerUtilities version of it.").getBoolean();
        ServerUtilitiesConfig.general.merge_offline_mode_players = EnumTristate.string2tristate(config.get(GEN_CAT, "merge_offline_mode_players", EnumTristate.TRUE.getName(), "Merges player profiles, in case player logged in without internet connection/in offline mode server. If set to DEFAULT, it will only merge on singleplayer worlds.").getString());
        config.setCategoryRequiresWorldRestart(GEN_CAT, true);
        ServerUtilitiesConfig.teams.disable_teams = config.get(TEAM_CAT, "disable_teams", false).getBoolean();
        ServerUtilitiesConfig.teams.autocreate_mp = config.get(TEAM_CAT, "autocreate_mp", false, "Automatically creates a team for player on multiplayer, based on their username and with a random color.").getBoolean();
        ServerUtilitiesConfig.teams.autocreate_sp = config.get(TEAM_CAT, "autocreate_sp", true, "Automatically creates (or joins) a team on singleplayer/LAN with ID 'singleplayer'.").getBoolean();
        ServerUtilitiesConfig.teams.hide_team_notification = config.get(TEAM_CAT, "hide_team_notification", false, "Disable no team notification entirely.").setLanguageKey("player_config.serverutilities.hide_team_notification").getBoolean();
        ServerUtilitiesConfig.teams.grief_protection = config.get(TEAM_CAT, "grief_protection", true, "Don't allow other players to break blocks in claimed chunks").getBoolean();
        ServerUtilitiesConfig.teams.interaction_protection = config.get(TEAM_CAT, "interaction_protection", true, "Don't allow other players to interact with blocks in claimed chunks").getBoolean();
        config.setCategoryComment("debugging", "Don't set any values to true, unless you are debugging the mod.");
        ServerUtilitiesConfig.debugging.special_commands = config.get("debugging", "special_commands", false, "Enables special debug commands.").getBoolean();
        ServerUtilitiesConfig.debugging.print_more_info = config.get("debugging", "print_more_info", false, "Print more info.").getBoolean();
        ServerUtilitiesConfig.debugging.print_more_errors = config.get("debugging", "print_more_errors", false, "Print more errors.").getBoolean();
        ServerUtilitiesConfig.debugging.log_network = config.get("debugging", "log_network", false, "Log incoming and outgoing network messages.").getBoolean();
        ServerUtilitiesConfig.debugging.log_teleport = config.get("debugging", "log_teleport", false, "Log player teleporting.").getBoolean();
        ServerUtilitiesConfig.debugging.log_config_editing = config.get("debugging", "log_config_editing", false, "Log config editing.").getBoolean();
        ServerUtilitiesConfig.debugging.dev_sidebar_buttons = config.get("debugging", "dev_sidebar_buttons", false, "See dev-only sidebar buttons. They probably don't do anything.").getBoolean();
        ServerUtilitiesConfig.debugging.gui_widget_bounds = config.get("debugging", "gui_widget_bounds", false, "See GUI widget bounds when you hold B.").getBoolean();
        ServerUtilitiesConfig.debugging.log_events = config.get("debugging", "log_events", false, "Log all events that extend EventBase.").getBoolean();
        ServerUtilitiesConfig.debugging.log_chunkloading = config.get("debugging", "log_chunkloading", false, "Print a message in console every time a chunk is forced or unforced. Recommended to be off, because spam.").getBoolean();
        config.setCategoryRequiresWorldRestart(AUTO_SHUTDOWN, true);
        ServerUtilitiesConfig.auto_shutdown.enabled = config.get(AUTO_SHUTDOWN, "enabled", false, "Enables auto-shutdown.").getBoolean();
        ServerUtilitiesConfig.auto_shutdown.enabled_singleplayer = config.get(AUTO_SHUTDOWN, "enabled_singleplayer", false, "Enables auto-shutdown in singleplayer worlds.").getBoolean();
        ServerUtilitiesConfig.auto_shutdown.times = config.get(AUTO_SHUTDOWN, "times", new String[]{"04:00", "16:00"}, "Server will automatically shut down after X hours.\nTime Format: HH:MM. If the system time matches a value, server will shut down.\nIt will look for closest value available that is not equal to current time.").getStringList();
        ServerUtilitiesConfig.afk.enabled = config.get(AFK, "enabled", true, "Enables afk timer.").getBoolean();
        ServerUtilitiesConfig.afk.enabled_singleplayer = config.get(AFK, "enabled_singleplayer", false, "Enables afk timer in singleplayer.").getBoolean();
        ServerUtilitiesConfig.afk.notification_timer = config.get(AFK, "notificationTimer", "5m", "After how much time it will display notification to all players.").getString();
        ServerUtilitiesConfig.afk.log_afk = config.get(AFK, "log_afk", false, "Will print in console when someone goes/comes back from AFK.").getBoolean();
        ServerUtilitiesConfig.backups.enable_backups = config.get(BACKUPS, "enable_backups", true, "Enables backups.").getBoolean();
        ServerUtilitiesConfig.backups.compression_level = config.get(BACKUPS, "compression_level", 1, "How much the backup file will be compressed. 1 - best speed 9 - smallest file size.").getInt();
        ServerUtilitiesConfig.backups.backups_to_keep = config.get(BACKUPS, "backups_to_keep", 12, "Number of backup files to keep before deleting old ones.").getInt();
        ServerUtilitiesConfig.backups.backup_folder_path = config.get(BACKUPS, "backup_folder_path", "./backups/", "Path to backups folder.").getString();
        ServerUtilitiesConfig.backups.backup_timer = config.get(BACKUPS, "backup_timer", "0.5", "Time between backups in hours. \n1.0 - backups every hour 6.0 - backups every 6 hours 0.5 - backups every 30 minutes.").getDouble();
        ServerUtilitiesConfig.backups.display_file_size = config.get(BACKUPS, "display_file_size", true, "Prints (current size | total size) when backup is done").getBoolean();
        ServerUtilitiesConfig.backups.silent_backup = config.get(BACKUPS, "silent_backup", false, "Silence backup notifications.").getBoolean();
        ServerUtilitiesConfig.backups.use_separate_thread = config.get(BACKUPS, "use_separate_thread", true, "Run backup in a separated thread (recommended)").getBoolean();
        ServerUtilitiesConfig.backups.need_online_players = config.get(BACKUPS, "need_online_players", true, "Backups won't run if no players are online.").getBoolean();
        ServerUtilitiesConfig.chat.add_nickname_tilde = config.get(CHAT, "add_nickname_tilde", false, "Adds ~ to player names that have changed nickname to prevent trolling.").getBoolean();
        ServerUtilitiesConfig.commands.warp = config.get(COMMANDS, "warp", true).getBoolean();
        ServerUtilitiesConfig.commands.home = config.get(COMMANDS, "home", true).getBoolean();
        ServerUtilitiesConfig.commands.back = config.get(COMMANDS, "back", true).getBoolean();
        ServerUtilitiesConfig.commands.spawn = config.get(COMMANDS, "spawn", true).getBoolean();
        ServerUtilitiesConfig.commands.inv = config.get(COMMANDS, "inv", true).getBoolean();
        ServerUtilitiesConfig.commands.tpl = config.get(COMMANDS, "tpl", true).getBoolean();
        ServerUtilitiesConfig.commands.trash_can = config.get(COMMANDS, "trash_can", true).getBoolean();
        ServerUtilitiesConfig.commands.chunks = config.get(COMMANDS, "chunks", true).getBoolean();
        ServerUtilitiesConfig.commands.kickme = config.get(COMMANDS, "kickme", true).getBoolean();
        ServerUtilitiesConfig.commands.ranks = config.get(COMMANDS, RANKS, true).getBoolean();
        ServerUtilitiesConfig.commands.heal = config.get(COMMANDS, "heal", true).getBoolean();
        ServerUtilitiesConfig.commands.killall = config.get(COMMANDS, "killall", true).getBoolean();
        ServerUtilitiesConfig.commands.nbtedit = config.get(COMMANDS, "nbtedit", true).getBoolean();
        ServerUtilitiesConfig.commands.fly = config.get(COMMANDS, "fly", true).getBoolean();
        ServerUtilitiesConfig.commands.leaderboard = config.get(COMMANDS, "leaderboard", true).getBoolean();
        ServerUtilitiesConfig.commands.tpa = config.get(COMMANDS, "tpa", true).getBoolean();
        ServerUtilitiesConfig.commands.nick = config.get(COMMANDS, "nick", true).getBoolean();
        ServerUtilitiesConfig.commands.mute = config.get(COMMANDS, "mute", true).getBoolean();
        ServerUtilitiesConfig.commands.rtp = config.get(COMMANDS, "rtp", true).getBoolean();
        ServerUtilitiesConfig.commands.god = config.get(COMMANDS, "god", true).getBoolean();
        ServerUtilitiesConfig.commands.rec = config.get(COMMANDS, "rec", true).getBoolean();
        ServerUtilitiesConfig.commands.backup = config.get(COMMANDS, "backup", true).getBoolean();
        ServerUtilitiesConfig.commands.dump_chunkloaders = config.get(COMMANDS, "dump_chunkloaders", true).getBoolean();
        ServerUtilitiesConfig.commands.dump_permissions = config.get(COMMANDS, "dump_permissions", true).getBoolean();
        ServerUtilitiesConfig.login.enable_motd = config.get(LOGIN, "enable_motd", false, "Enables message of the day.").getBoolean();
        ServerUtilitiesConfig.login.enable_starting_items = config.get(LOGIN, "enable_starting_items", false, "Enables starting items.").getBoolean();
        ServerUtilitiesConfig.login.motd = config.get(LOGIN, "motd", new String[]{"\"Hello player!\""}, "Message of the day. This will be displayed when player joins the server.").getStringList();
        ServerUtilitiesConfig.login.starting_items = config.get(LOGIN, "starting_items", new String[]{"{id:\"minecraft:stone_sword\",Count:1,Damage:1,tag:{display:{Name:\"Epic Stone Sword\"}}}"}, "Items to give player when they first join the server.\nFormat: '{id:\"ID\",Count:X,Damage:X,tag:{}}', Use /print_item to get NBT of item in your hand.").getStringList();
        ServerUtilitiesConfig.ranks.enabled = config.get(RANKS, "enabled", true, "Enables ranks and adds command.x permissions and allows ranks to control them.").getBoolean();
        ServerUtilitiesConfig.ranks.override_chat = config.get(RANKS, "override_chat", true, "Adds chat colors/rank-specific syntax.").getBoolean();
        ServerUtilitiesConfig.ranks.override_commands = config.get(RANKS, "override_commands", true, "Allow to configure commands with ranks. Disable this if you want to use other permission mod for that.").getBoolean();
        config.setCategoryRequiresMcRestart(RANKS, true);
        ServerUtilitiesConfig.world.logging.enabled = config.get(LOGGING, "enabled", false, "Enables world logging.").getBoolean();
        ServerUtilitiesConfig.world.logging.include_creative_players = config.get(LOGGING, "include_creative_players", false, "Includes creative players in world logging.").getBoolean();
        ServerUtilitiesConfig.world.logging.include_fake_players = config.get(LOGGING, "include_fake_players", false, "Includes fake players in world logging.").getBoolean();
        ServerUtilitiesConfig.world.logging.block_placed = config.get(LOGGING, "block_placed", true, "Logs block placement.").getBoolean();
        ServerUtilitiesConfig.world.logging.block_broken = config.get(LOGGING, "block_broken", true, "Logs block breaking.").getBoolean();
        ServerUtilitiesConfig.world.logging.item_clicked_in_air = config.get(LOGGING, "item_clicked_in_air", true, "Logs item clicking in air.").getBoolean();
        ServerUtilitiesConfig.world.logging.entity_attacked = config.get(LOGGING, "entity_attacked", true, "Logs player attacks on other players/entites.").getBoolean();
        ServerUtilitiesConfig.world.logging.exclude_mob_entity = config.get(LOGGING, "exclude_mob_entity", true, "Exclude mobs from entity attack logging.").getBoolean();
        ServerUtilitiesConfig.world.logging.chat_enable = config.get(LOGGING, "chat_enable", false, "Enables chat logging.").getBoolean();
        config.setCategoryComment(LOGGING, "Logs different events in logs/world.log file.");
        ServerUtilitiesConfig.world.chunk_claiming = config.get(WORLD, "chunk_claiming", true, "Enables chunk claiming.").getBoolean();
        ServerUtilitiesConfig.world.chunk_loading = config.get(WORLD, "chunk_loading", true, "Enables chunk loading. If chunk_claiming is set to false, changing this won't do anything.").getBoolean();
        ServerUtilitiesConfig.world.safe_spawn = config.get(WORLD, "safe_spawn", false, "If set to true, explosions and hostile mobs in spawn area will be disabled, players won't be able to attack each other in spawn area.").getBoolean();
        ServerUtilitiesConfig.world.spawn_area_in_sp = config.get(WORLD, "spawn_area_in_sp", false, "Enable spawn area in singleplayer.").getBoolean();
        ServerUtilitiesConfig.world.blocked_claiming_dimensions = config.get(WORLD, "blocked_claiming_dimensions", new int[0], "Dimensions where chunk claiming isn't allowed.").getIntList();
        ServerUtilitiesConfig.world.enable_pvp = EnumTristate.string2tristate(config.get(WORLD, "enable_pvp", EnumTristate.TRUE.getName(), "Allowed values:\nDEFAULT = Players can choose their own PVP status.\nTRUE = PVP on for everyone.\nFALSE = PVP disabled for everyone.").setValidValues(TRISTATE_VALUES).getString());
        ServerUtilitiesConfig.world.enable_explosions = EnumTristate.string2tristate(config.get(WORLD, "enable_explosions", EnumTristate.DEFAULT.getName(), "Allowed values:\nDEFAULT = Teams can decide their explosion setting\nTRUE = Explosions on for everyone.\nFALSE = Explosions disabled for everyone.").setValidValues(TRISTATE_VALUES).getString());
        ServerUtilitiesConfig.world.spawn_radius = config.get(WORLD, "spawn_radius", 0, "Spawn radius. You must set spawn-protection in server.properties file to 0!").getInt();
        ServerUtilitiesConfig.world.spawn_dimension = config.get(WORLD, "spawn_dimension", 0, "Spawn dimension. Overworld by default.").getInt();
        ServerUtilitiesConfig.world.unload_erroring_chunks = config.get(WORLD, "unload_erroring_chunks", false, "Unloads erroring chunks if dimension isn't loaded or some other problem occurs.").getBoolean();
        ServerUtilitiesConfig.world.rtp_min_distance = config.get(WORLD, "rtp_min_distance", 1000.0, "Min /rtp distance").getDouble();
        ServerUtilitiesConfig.world.rtp_max_distance = config.get(WORLD, "rtp_max_distance", 100000.0, "Max /rtp distance").getDouble();
        ServerUtilitiesConfig.world.rtp_max_tries = config.get(WORLD, "rtp_max_tries", 200, "Max tries /rtp does before failure.").getInt();
        ServerUtilitiesConfig.world.disabled_right_click_items = config.get(WORLD, "disabled_right_click_items", new String[0], "List of items that will have right-click function disabled on both sides.\nYou can use '/inv disable_right_click' command to do with from in-game.\nSyntax: modid:item:metadata. Set metadata to * to ignore it.").getStringList();
        ServerUtilitiesConfig.world.forced_spawn_dimension_time = config.get(WORLD, "forced_spawn_dimension_time", -1, "Locked time in ticks in spawn dimension.\n-1 - Disabled\n0 - Morning\n6000 - Noon\n12000 - Evening\n18000 - Midnight", -1, 23999).getInt();
        ServerUtilitiesConfig.world.forced_spawn_dimension_weather = config.get(WORLD, "forced_spawn_dimension_weather", -1, "Locked weather type in spawn dimension.\n-1 - Disabled\n0 - Clear\n1 - Raining\n2 - Thunderstorm", -1, 2).getInt();
        ServerUtilitiesConfig.world.disable_player_suffocation_damage = config.get(WORLD, "disable_player_suffocation_damage", false, "Disables player damage when they are stuck in walls.").getBoolean();
        ServerUtilitiesConfig.world.show_playtime = config.get(WORLD, "show_playtime", false, "Show play time in corner.").getBoolean();
        config.setCategoryRequiresWorldRestart(WORLD, true);
        login.motdComponents = null;
        login.startingItems = null;
        afk.notificationTimer = -1L;
        world.disabledItems = null;
        config.save();
        return true;
    }

    static {
        TRISTATE_VALUES = new String[]{"TRUE", "FALSE", "DEFAULT"};
        auto_shutdown = new AutoShutdown();
        afk = new AFK();
        chat = new Chat();
        commands = new Commands();
        login = new Login();
        ranks = new RanksConfig();
        world = new WorldConfig();
        debugging = new Debugging();
        backups = new Backups();
        general = new General();
        teams = new Teams();
    }

    public static class General {
        public boolean replace_reload_command;
        public EnumTristate merge_offline_mode_players;
    }

    public static class Teams {
        public boolean disable_teams;
        public boolean autocreate_mp;
        public boolean autocreate_sp;
        public boolean hide_team_notification;
        public boolean grief_protection;
        public boolean interaction_protection;
    }

    public static class Debugging {
        public boolean special_commands;
        public boolean print_more_info;
        public boolean print_more_errors;
        public boolean log_network;
        public boolean log_teleport;
        public boolean log_config_editing;
        public boolean dev_sidebar_buttons;
        public boolean gui_widget_bounds;
        public boolean log_events;
        public boolean log_chunkloading;
    }

    public static class AutoShutdown {
        public boolean enabled;
        public boolean enabled_singleplayer;
        public String[] times;
    }

    public static class AFK {
        public boolean enabled;
        public boolean enabled_singleplayer;
        public String notification_timer;
        public boolean log_afk;
        private long notificationTimer;

        public boolean isEnabled(MinecraftServer server) {
            return this.enabled && (this.enabled_singleplayer || !server.func_71264_H());
        }

        public long getNotificationTimer() {
            if (this.notificationTimer < 0L) {
                this.notificationTimer = Ticks.get(this.notification_timer).millis();
            }
            return this.notificationTimer;
        }
    }

    public static class Backups {
        public boolean enable_backups;
        public double backup_timer;
        public int backups_to_keep;
        public int compression_level;
        public String backup_folder_path;
        public boolean use_separate_thread;
        public boolean display_file_size;
        public boolean need_online_players;
        public boolean silent_backup;
    }

    public static class Chat {
        public boolean add_nickname_tilde;
        public boolean replace_tab_names;
    }

    public static class Commands {
        public boolean warp;
        public boolean home;
        public boolean back;
        public boolean spawn;
        public boolean inv;
        public boolean tpl;
        public boolean trash_can;
        public boolean chunks;
        public boolean kickme;
        public boolean ranks;
        public boolean heal;
        public boolean killall;
        public boolean nbtedit;
        public boolean fly;
        public boolean leaderboard;
        public boolean tpa;
        public boolean nick;
        public boolean mute;
        public boolean rtp;
        public boolean god;
        public boolean rec;
        public boolean backup;
        public boolean dump_chunkloaders;
        public boolean dump_permissions;
    }

    public static class Login {
        public boolean enable_motd;
        public boolean enable_starting_items;
        public boolean enable_global_badges;
        public boolean enable_event_badges;
        public String[] motd;
        private List<IChatComponent> motdComponents = null;
        private List<ItemStack> startingItems = null;
        public String[] starting_items;

        public List<IChatComponent> getMOTD() {
            if (this.motdComponents == null) {
                this.motdComponents = new ArrayList<IChatComponent>();
                if (this.enable_motd) {
                    for (String s : this.motd) {
                        IChatComponent t = JsonUtils.deserializeTextComponent(DataReader.get(s).safeJson());
                        if (t == null) continue;
                        this.motdComponents.add(t);
                    }
                }
            }
            return this.motdComponents;
        }

        public List<ItemStack> getStartingItems() {
            if (this.startingItems == null) {
                this.startingItems = new ArrayList<ItemStack>();
                if (this.enable_starting_items) {
                    for (String s : this.starting_items) {
                        try {
                            ItemStack stack = ItemStackSerializer.parseItem(s);
                            if (stack == null) continue;
                            this.startingItems.add(stack);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            return this.startingItems;
        }
    }

    public static class RanksConfig {
        public boolean enabled;
        public boolean override_chat;
        public boolean override_commands;
    }

    public static class WorldConfig {
        public final WorldLogging logging = new WorldLogging();
        public boolean chunk_claiming;
        public boolean chunk_loading;
        public boolean safe_spawn;
        public boolean spawn_area_in_sp;
        public int[] blocked_claiming_dimensions;
        public EnumTristate enable_pvp;
        public EnumTristate enable_explosions;
        public int spawn_radius;
        public int spawn_dimension;
        public boolean unload_erroring_chunks;
        public double rtp_min_distance;
        public double rtp_max_distance;
        public int rtp_max_tries;
        public String[] disabled_right_click_items;
        private List<DisabledItem> disabledItems = null;
        public int forced_spawn_dimension_time;
        public int forced_spawn_dimension_weather;
        public boolean disable_player_suffocation_damage;
        public boolean show_playtime;

        public boolean blockDimension(int dimension) {
            if (!ClaimedChunks.isActive()) {
                return true;
            }
            for (int i : this.blocked_claiming_dimensions) {
                if (i != dimension) continue;
                return true;
            }
            return false;
        }

        public boolean isItemRightClickDisabled(ItemStack stack) {
            if (this.disabledItems == null) {
                this.disabledItems = new ArrayList<DisabledItem>();
                for (String s : this.disabled_right_click_items) {
                    String[] s1 = s.split("@", 2);
                    Item item = (Item)GameData.getItemRegistry().func_82594_a(s1[0]);
                    if (item == null) continue;
                    DisabledItem di = new DisabledItem();
                    di.item = item;
                    di.metadata = s1.length == 1 || s1[1].startsWith("*") ? Short.MAX_VALUE : Integer.parseInt(s1[1].trim());
                    this.disabledItems.add(di);
                }
            }
            if (this.disabledItems.isEmpty()) {
                return false;
            }
            Item item = stack.func_77973_b();
            int meta = stack.func_77960_j();
            for (DisabledItem disabledItem : this.disabledItems) {
                if (disabledItem.item != item || disabledItem.metadata != Short.MAX_VALUE && disabledItem.metadata != meta) continue;
                return true;
            }
            return false;
        }

        public static class WorldLogging {
            public boolean enabled;
            public boolean include_creative_players;
            public boolean include_fake_players;
            public boolean block_placed;
            public boolean block_broken;
            public boolean item_clicked_in_air;
            public boolean entity_attacked;
            public boolean exclude_mob_entity;
            public boolean chat_enable;

            public boolean log(EntityPlayerMP player) {
                return !(!this.enabled || !this.include_creative_players && player.field_71075_bZ.field_75098_d || !this.include_fake_players && ServerUtils.isFake(player));
            }
        }

        private static class DisabledItem {
            private Item item;
            private int metadata;

            private DisabledItem() {
            }
        }
    }
}

