/*
 * Decompiled with CFR 0.152.
 */
package serverutils.backups;

import java.io.File;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.backups.ThreadBackup;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.ServerUtils;

public class Backups {
    public static File backupsFolder;
    public static long nextBackup;
    public static ThreadBackup thread;
    public static boolean hadPlayer;

    public static void init() {
        File file = backupsFolder = ServerUtilitiesConfig.backups.backup_folder_path.isEmpty() ? new File(Minecraft.func_71410_x().field_71412_D, "/backups/") : new File(ServerUtilitiesConfig.backups.backup_folder_path);
        if (!backupsFolder.exists()) {
            backupsFolder.mkdirs();
        }
        thread = null;
        Backups.clearOldBackups();
        ServerUtilities.LOGGER.info("Backups folder - " + backupsFolder.getAbsolutePath());
    }

    public static boolean run(ICommandSender ics, String customName) {
        boolean auto;
        if (thread != null) {
            return false;
        }
        boolean bl = auto = ics == null;
        if (auto && !ServerUtilitiesConfig.backups.enable_backups) {
            return false;
        }
        MinecraftServer server = ServerUtils.getServer();
        nextBackup = System.currentTimeMillis() + Backups.backupMillis();
        if (auto && ServerUtilitiesConfig.backups.need_online_players) {
            if (!Backups.hasOnlinePlayers() && !hadPlayer) {
                return true;
            }
            hadPlayer = false;
        }
        ServerUtilitiesNotifications.backupNotification(ServerUtilitiesNotifications.BACKUP_START, "cmd.backup_start", new Object[0]);
        try {
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                WorldServer worldserver = server.field_71305_c[i];
                worldserver.field_73058_d = true;
                worldserver.func_73044_a(true, null);
            }
        }
        catch (Exception ex) {
            ServerUtilities.LOGGER.info("Error while saving world: " + ex.getMessage());
        }
        File wd = server.func_130014_f_().func_72860_G().func_75765_b();
        if (ServerUtilitiesConfig.backups.use_separate_thread) {
            thread = new ThreadBackup(wd, customName);
            thread.start();
        } else {
            ThreadBackup.doBackup(wd, customName);
        }
        return true;
    }

    public static void clearOldBackups() {
        Object[] backups = backupsFolder.list();
        if (backups != null && backups.length > ServerUtilitiesConfig.backups.backups_to_keep) {
            Arrays.sort(backups);
            int toDelete = backups.length - ServerUtilitiesConfig.backups.backups_to_keep;
            ServerUtilities.LOGGER.info("Deleting " + toDelete + " old backups");
            for (int i = 0; i < toDelete; ++i) {
                File f = new File(backupsFolder, (String)backups[i]);
                ServerUtilities.LOGGER.info("Deleted old backup: " + f.getPath());
                FileUtils.delete(f);
            }
        }
    }

    public static long backupMillis() {
        return (long)(ServerUtilitiesConfig.backups.backup_timer * 3600.0 * 1000.0);
    }

    public static boolean hasOnlinePlayers() {
        return !ServerUtils.getServer().func_71203_ab().field_72404_b.isEmpty();
    }

    public static void postBackup() {
        try {
            MinecraftServer server = ServerUtils.getServer();
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                WorldServer worldserver = server.field_71305_c[i];
                if (!worldserver.field_73058_d) continue;
                worldserver.field_73058_d = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        nextBackup = -1L;
        thread = null;
        hadPlayer = false;
    }
}

