/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.config.ConfigCategory;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.ServerUtilitiesTeamData;
import serverutils.data.ServerUtilitiesUniverseData;
import serverutils.lib.EnumTeamColor;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.TeamType;
import serverutils.lib.data.Universe;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.util.JsonUtils;
import serverutils.lib.util.StringUtils;
import serverutils.ranks.Rank;

public class BackwardsCompat {
    public static JsonObject LATCONFIG;

    public static void load() {
        BackwardsCompat.loadPlayers();
        BackwardsCompat.loadChunks();
        BackwardsCompat.loadWarps();
        BackwardsCompat.loadConfig();
    }

    public static void loadPlayers() {
        NBTTagCompound tagPlayers = BackwardsCompat.readMap(new File(Universe.get().latModFolder, "LMPlayers.dat"));
        ServerUtilities.LOGGER.info("Loading players from LatMod");
        if (tagPlayers != null && tagPlayers.func_74764_b("Players")) {
            NBTTagCompound pTag = tagPlayers.func_74775_l("Players");
            Map map = BackwardsCompat.toMapWithType(pTag);
            for (Map.Entry e : map.entrySet()) {
                NBTTagCompound tag1 = (NBTTagCompound)e.getValue();
                UUID uuid = StringUtils.fromString(tag1.func_74779_i("UUID"));
                if (uuid == null) continue;
                ForgePlayer player = new ForgePlayer(Universe.get(), uuid, tag1.func_74779_i("Name"));
                Universe.get().players.put(uuid, player);
                player.lastTimeSeen = tag1.func_74775_l("Stats").func_74763_f("LastSeen");
                ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(player);
                NBTTagCompound homes = tag1.func_74775_l("Homes");
                for (String s1 : BackwardsCompat.getMapKeys(homes)) {
                    data.homes.set(s1, BlockDimPos.fromIntArray(homes.func_74759_k(s1)));
                }
                data.player.markDirty();
            }
        }
        ServerUtilities.LOGGER.info("Finished loading players from LatMod");
    }

    public static void loadChunks() {
        Universe universe = Universe.get();
        JsonObject group = JsonUtils.fromJson(new File(universe.latModFolder, "ClaimedChunks.json")).getAsJsonObject();
        if (group == null) {
            return;
        }
        ServerUtilities.LOGGER.info("Loading claimed chunks from LatMod");
        if (!ClaimedChunks.isActive()) {
            ClaimedChunks.instance = new ClaimedChunks(universe);
        }
        for (Map.Entry e : group.entrySet()) {
            int dim = Integer.parseInt((String)e.getKey());
            for (Map.Entry e1 : ((JsonElement)e.getValue()).getAsJsonObject().entrySet()) {
                try {
                    ForgePlayer p = Universe.get().getPlayer(StringUtils.fromString((String)e1.getKey()));
                    if (p == null) continue;
                    if (p.team.type == TeamType.NONE) {
                        ForgeTeam team = new ForgeTeam(universe, universe.generateTeamUID((short)0), p.getName(), TeamType.PLAYER);
                        team.owner = p;
                        team.setColor(EnumTeamColor.NAME_MAP.getRandom(universe.world.field_73012_v));
                        universe.addTeam(team);
                        p.team = team;
                        p.markDirty();
                    }
                    ServerUtilitiesTeamData data = ServerUtilitiesTeamData.get(p.team);
                    JsonArray chunksList = ((JsonElement)e1.getValue()).getAsJsonArray();
                    for (int k = 0; k < chunksList.size(); ++k) {
                        int[] ai = BackwardsCompat.fromIntArray(chunksList.get(k));
                        if (ai == null) continue;
                        ClaimedChunk c = new ClaimedChunk(new ChunkDimPos(new ChunkCoordIntPair(ai[0], ai[1]), dim), data);
                        if (ai.length >= 3 && ai[2] == 1) {
                            c.setLoaded(true);
                        }
                        ClaimedChunks.instance.addChunk(c);
                    }
                    p.team.markDirty();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        ServerUtilities.LOGGER.info("Finished loading claimed chunks from LatMod");
        ClaimedChunks.instance.forceSave();
    }

    public static void loadWarps() {
        JsonObject warps = JsonUtils.fromJson(new File(Universe.get().latModFolder, "LMWorld.json")).getAsJsonObject().get("warps").getAsJsonObject();
        ServerUtilities.LOGGER.info("Loading warps from LatMod");
        if (warps != null) {
            for (Map.Entry e : warps.entrySet()) {
                if (((JsonElement)e.getValue()).isJsonArray()) {
                    int[] val = BackwardsCompat.fromIntArray((JsonElement)e.getValue());
                    ServerUtilitiesUniverseData.WARPS.set(((String)e.getKey()).toLowerCase(), BlockDimPos.fromIntArray(val));
                    continue;
                }
                JsonObject o = ((JsonElement)e.getValue()).getAsJsonObject();
                ServerUtilitiesUniverseData.WARPS.set(((String)e.getKey()).toLowerCase(), new BlockDimPos(o.get("x").getAsInt(), o.get("y").getAsInt(), o.get("z").getAsInt(), o.get("dim").getAsInt()));
            }
        }
        ServerUtilities.LOGGER.info("Finished loading warps from LatMod");
    }

    public static void loadConfig() {
        if (LATCONFIG == null) {
            return;
        }
        ServerUtilities.LOGGER.info("Loading config from LatMod");
        JsonObject latBackup = LATCONFIG.get("backups").getAsJsonObject();
        ConfigCategory backupConfig = ServerUtilitiesConfig.config.getCategory("backups");
        backupConfig.get("enable_backups").set(latBackup.get("enabled").getAsBoolean());
        backupConfig.get("backup_timer").set(latBackup.get("backup_timer").getAsDouble());
        backupConfig.get("backups_to_keep").set(latBackup.get("backups_to_keep").getAsInt());
        backupConfig.get("backup_folder_path").set(latBackup.get("folder").getAsString());
        backupConfig.get("use_separate_thread").set(latBackup.get("use_separate_thread").getAsBoolean());
        backupConfig.get("need_online_players").set(latBackup.get("need_online_players").getAsBoolean());
        backupConfig.get("compression_level").set(latBackup.get("compression_level").getAsInt());
        backupConfig.get("display_file_size").set(latBackup.get("display_file_size").getAsBoolean());
        JsonObject latGeneral = LATCONFIG.get("general").getAsJsonObject();
        ConfigCategory worldConfig = ServerUtilitiesConfig.config.getCategory("world");
        worldConfig.get("safe_spawn").set(latGeneral.get("safe_spawn").getAsBoolean());
        worldConfig.get("spawn_area_in_sp").set(latGeneral.get("spawn_area_in_sp").getAsBoolean());
        worldConfig.get("chunk_loading").set(LATCONFIG.get("chunkloading").getAsJsonObject().get("enabled").getAsBoolean());
        ServerUtilitiesConfig.sync();
        ServerUtilities.LOGGER.info("Finished loading warps from LatMod");
    }

    public static void loadRanks(Rank player, Rank admin) {
        if (LATCONFIG == null) {
            return;
        }
        JsonObject permissionsPlayer = LATCONFIG.get("permissions_player").getAsJsonObject();
        player.setPermission("serverutilities.homes.max", permissionsPlayer.get("max_homes").getAsInt());
        player.setPermission("serverutilities.claims.max_chunks", permissionsPlayer.get("max_claims").getAsInt());
        player.setPermission("serverutilities.chunkloader.max_chunks", permissionsPlayer.get("max_loaded_chunks").getAsInt());
        if (permissionsPlayer.get("cross_dim_homes").getAsBoolean()) {
            player.setPermission("serverutilities.homes.cross_dim", true);
        }
        JsonObject permissionsAdmin = LATCONFIG.get("permissions_admin").getAsJsonObject();
        admin.setPermission("serverutilities.homes.max", permissionsAdmin.get("max_homes").getAsInt());
        admin.setPermission("serverutilities.claims.max_chunks", permissionsAdmin.get("max_claims").getAsInt());
        admin.setPermission("serverutilities.chunkloader.max_chunks", permissionsAdmin.get("max_loaded_chunks").getAsInt());
        if (permissionsAdmin.get("cross_dim_homes").getAsBoolean()) {
            admin.setPermission("serverutilities.homes.cross_dim", true);
        }
    }

    public static <E extends NBTBase> Map<String, E> toMapWithType(NBTTagCompound tag) {
        HashMap<String, NBTBase> map = new HashMap<String, NBTBase>();
        if (tag.func_82582_d()) {
            return map;
        }
        for (Object s : tag.func_150296_c()) {
            map.put(s.toString(), tag.func_74781_a(s.toString()));
        }
        return map;
    }

    public static NBTTagCompound readMap(File f) {
        if (!f.exists()) {
            return null;
        }
        try {
            return CompressedStreamTools.func_74797_a((File)f);
        }
        catch (Exception e) {
            e.printStackTrace();
            ServerUtilities.LOGGER.info("Possibly corrupted / old file. Trying the old method");
            try {
                FileInputStream is = new FileInputStream(f);
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                return CompressedStreamTools.func_152457_a((byte[])b, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public static String[] getMapKeys(NBTTagCompound tag) {
        if (tag.func_82582_d()) {
            return new String[0];
        }
        return BackwardsCompat.toStringArray(tag.func_150296_c());
    }

    public static String[] toStringArray(Collection<?> c) {
        if (c.isEmpty()) {
            return null;
        }
        String[] s = new String[c.size()];
        int i = -1;
        for (Object o : c) {
            s[++i] = String.valueOf(o);
        }
        return s;
    }

    public static int[] fromIntArray(JsonElement e) {
        if (e.isJsonNull()) {
            return null;
        }
        if (e.isJsonArray()) {
            JsonArray a = e.getAsJsonArray();
            int[] ai = new int[a.size()];
            if (ai.length == 0) {
                return ai;
            }
            for (int i = 0; i < ai.length; ++i) {
                ai[i] = a.get(i).getAsInt();
            }
            return ai;
        }
        return new int[]{e.getAsInt()};
    }

    static {
        File ftbuFile = Universe.get().server.func_71209_f("local/ftbu/config.json");
        if (ftbuFile.exists()) {
            LATCONFIG = JsonUtils.fromJson(ftbuFile).getAsJsonObject();
        }
    }
}

