/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import java.util.Comparator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.StringUtils;

public class Leaderboard {
    public final ResourceLocation id;
    private final IChatComponent title;
    private final Function<ForgePlayer, IChatComponent> playerToValue;
    private final Comparator<ForgePlayer> comparator;
    private final Predicate<ForgePlayer> validValue;

    public Leaderboard(ResourceLocation _id, IChatComponent t, Function<ForgePlayer, IChatComponent> v, Comparator<ForgePlayer> c, Predicate<ForgePlayer> vv) {
        this.id = _id;
        this.title = t;
        this.playerToValue = v;
        this.comparator = c.thenComparing((o1, o2) -> o1.getDisplayNameString().compareToIgnoreCase(o2.getDisplayNameString()));
        this.validValue = vv;
    }

    public final IChatComponent getTitle() {
        return this.title;
    }

    public final Comparator<ForgePlayer> getComparator() {
        return this.comparator;
    }

    public final IChatComponent createValue(ForgePlayer player) {
        return this.playerToValue.apply(player);
    }

    public final boolean hasValidValue(ForgePlayer player) {
        return this.validValue.test(player);
    }

    public static class FromStat
    extends Leaderboard {
        public static final IntFunction<IChatComponent> DEFAULT = value -> new ChatComponentText(value <= 0 ? "0" : Integer.toString(value));
        public static final IntFunction<IChatComponent> TIME = value -> new ChatComponentText("[" + (int)((double)value / 72000.0 + 0.5) + "h] " + Ticks.get(value).toTimeString());

        public FromStat(ResourceLocation id, IChatComponent t, StatBase statBase, boolean from0to1, IntFunction<IChatComponent> valueToString) {
            super(id, t, (ForgePlayer player) -> (IChatComponent)valueToString.apply(player.stats().func_77444_a(statBase)), (o1, o2) -> {
                int i = Integer.compare(o1.stats().func_77444_a(statBase), o2.stats().func_77444_a(statBase));
                return from0to1 ? i : -i;
            }, (ForgePlayer player) -> player.stats().func_77444_a(statBase) > 0);
        }

        public FromStat(ResourceLocation id, StatBase statBase, boolean from0to1, IntFunction<IChatComponent> valueToString) {
            this(id, StringUtils.color(statBase.func_150951_e(), null), statBase, from0to1, valueToString);
        }
    }
}

