/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.AllDiagramsButton;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Grid;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Lines;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.SlotGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class LayoutHandler {
    static final Point LENS_COLOUR_POSITION = Grid.GRID.grid(2, 0);
    static final int MAX_RECIPES_PER_PAGE = 24;
    static final ImmutableList<Layout.SlotKey> SLOT_RECIPE_INPUTS = ImmutableList.copyOf((Collection)IntStream.range(0, 24).mapToObj(i -> Layout.SlotKey.create("recipe-input-" + i)).collect(Collectors.toList()));
    static final ImmutableList<Layout.SlotKey> SLOT_RECIPE_OUTPUTS = ImmutableList.copyOf((Collection)IntStream.range(0, 24).mapToObj(i -> Layout.SlotKey.create("recipe-output-" + i)).collect(Collectors.toList()));
    private final DiagramGroupInfo info;
    private ImmutableList<Layout> requiredLayouts;
    private ImmutableList<Layout> optionalLayouts;

    LayoutHandler(DiagramGroupInfo info) {
        this.info = info;
    }

    void initialize() {
        this.requiredLayouts = ImmutableList.of((Object)this.buildHeaderLayout());
        this.optionalLayouts = ImmutableList.copyOf((Collection)IntStream.range(0, 24).mapToObj(this::buildRecipeLayout).collect(Collectors.toList()));
    }

    ImmutableList<Layout> requiredLayouts() {
        return this.requiredLayouts;
    }

    ImmutableList<Layout> optionalLayouts() {
        return this.optionalLayouts;
    }

    private Layout buildHeaderLayout() {
        return Layout.builder().addInteractable(new AllDiagramsButton(this.info, Grid.GRID.grid(0, 0))).putSlotGroup(SlotGroupKeys.SAME_COLOUR_LENSES, SlotGroup.builder(9, 1, Grid.GRID.grid(6, 2), Grid.Direction.C).setDefaultTooltip(Tooltip.create(Lang.GREGTECH_5_LENSES.trans("samecolourlensesslot"), Tooltip.SLOT_FORMATTING)).build()).build();
    }

    private Layout buildRecipeLayout(int index) {
        int gridX = index % 2 == 0 ? 3 : 9;
        int gridY = 4 + 2 * (index / 2);
        int inputX = gridX - 1;
        int outputX = gridX + 1;
        return Layout.builder().addLines(Lines.builder(Grid.GRID.grid(inputX, gridY)).addArrow(Grid.GRID.edge(outputX, gridY, Grid.Direction.W)).build()).putSlot((Layout.SlotKey)SLOT_RECIPE_INPUTS.get(index), Slot.builder(Grid.GRID.grid(inputX, gridY)).setTooltip(Tooltip.create(Lang.GREGTECH_5_LENSES.trans("recipeinputslot"), Tooltip.SLOT_FORMATTING)).build()).putSlot((Layout.SlotKey)SLOT_RECIPE_OUTPUTS.get(index), Slot.builder(Grid.GRID.grid(outputX, gridY)).setTooltip(Tooltip.create(Lang.GREGTECH_5_LENSES.trans("recipeoutputslot"), Tooltip.SLOT_FORMATTING)).build()).build();
    }

    static final class SlotGroupKeys {
        static final Layout.SlotGroupKey SAME_COLOUR_LENSES = Layout.SlotGroupKey.create("same-colour-lenses");

        SlotGroupKeys() {
        }
    }
}

